/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.types.ResettableValue;

@Public
public class ShortValue
implements NormalizableKey<ShortValue>,
ResettableValue<ShortValue>,
CopyableValue<ShortValue> {
    private static final long serialVersionUID = 1L;
    private short value;

    public ShortValue() {
        this.value = 0;
    }

    public ShortValue(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    @Override
    public void setValue(short value) {
        this.value = value;
    }

    @Override
    public void setValue(ShortValue value) {
        this.value = value.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.value = in.readShort();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeShort(this.value);
    }

    @Override
    public int compareTo(ShortValue o) {
        short other = o.value;
        return this.value < other ? -1 : (this.value > other ? 1 : 0);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ShortValue) {
            return ((ShortValue)obj).value == this.value;
        }
        return false;
    }

    @Override
    public int getMaxNormalizedKeyLen() {
        return 2;
    }

    @Override
    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        if (len == 2) {
            int highByte = this.value >>> 8 & 0xFF;
            target.put(offset, (byte)(highByte += 128));
            target.put(offset + 1, (byte)(this.value & 0xFF));
        } else if (len > 0) {
            if (len == 1) {
                int highByte = this.value >>> 8 & 0xFF;
                target.put(offset, (byte)(highByte += 128));
            } else {
                int highByte = this.value >>> 8 & 0xFF;
                target.put(offset, (byte)(highByte += 128));
                target.put(offset + 1, (byte)(this.value & 0xFF));
                for (int i = 2; i < len; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    @Override
    public int getBinaryLength() {
        return 2;
    }

    @Override
    public void copyTo(ShortValue target) {
        target.value = this.value;
    }

    @Override
    public ShortValue copy() {
        return new ShortValue(this.value);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 2);
    }
}

