/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client.trait;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.cli.ExecutionConfigAccessor;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.PipelineOptionsInternal;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointConfigOptions;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.conf.Workspace$;
import org.apache.streampark.common.enums.ApplicationType;
import org.apache.streampark.common.enums.DevelopmentMode;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.DeflaterUtils$;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.bean.SubmitResponse;
import org.apache.streampark.flink.client.trait.FlinkSubmitTrait;
import org.apache.streampark.flink.client.trait.FlinkSubmitTrait$;
import org.apache.streampark.flink.core.FlinkClusterClient;
import org.apache.streampark.flink.core.conf.FlinkRunOption$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public abstract class FlinkSubmitTrait$class {
    public static String PARAM_KEY_FLINK_CONF(FlinkSubmitTrait $this) {
        return ConfigConst$.MODULE$.KEY_FLINK_CONF("--");
    }

    public static String PARAM_KEY_FLINK_SQL(FlinkSubmitTrait $this) {
        return ConfigConst$.MODULE$.KEY_FLINK_SQL("--");
    }

    public static String PARAM_KEY_APP_CONF(FlinkSubmitTrait $this) {
        return ConfigConst$.MODULE$.KEY_APP_CONF("--");
    }

    public static String PARAM_KEY_APP_NAME(FlinkSubmitTrait $this) {
        return ConfigConst$.MODULE$.KEY_APP_NAME("--");
    }

    public static String PARAM_KEY_FLINK_PARALLELISM(FlinkSubmitTrait $this) {
        return ConfigConst$.MODULE$.KEY_FLINK_PARALLELISM("--");
    }

    public static SubmitResponse submit(FlinkSubmitTrait $this, SubmitRequest submitRequest) throws Exception {
        $this.logInfo((Function0)new Serializable($this, submitRequest){
            public static final long serialVersionUID = 0L;
            private final SubmitRequest submitRequest$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |--------------------------------------- flink job start ---------------------------------------\n         |    userFlinkHome    : ", "\n         |    flinkVersion     : ", "\n         |    appName          : ", "\n         |    devMode          : ", "\n         |    execMode         : ", "\n         |    k8sNamespace     : ", "\n         |    flinkExposedType : ", "\n         |    clusterId        : ", "\n         |    applicationType  : ", "\n         |    savePoint        : ", "\n         |    properties       : ", "\n         |    args             : ", "\n         |    appConf          : ", "\n         |    flinkBuildResult : ", "\n         |-------------------------------------------------------------------------------------------\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.submitRequest$2.flinkVersion().flinkHome(), this.submitRequest$2.flinkVersion().version(), this.submitRequest$2.appName(), this.submitRequest$2.developmentMode().name(), this.submitRequest$2.executionMode().name(), this.submitRequest$2.k8sSubmitParam().kubernetesNamespace(), this.submitRequest$2.k8sSubmitParam().flinkRestExposedType(), this.submitRequest$2.k8sSubmitParam().clusterId(), this.submitRequest$2.applicationType().getName(), this.submitRequest$2.savePoint(), JavaConversions$.MODULE$.mapAsScalaMap(this.submitRequest$2.properties()).mkString(" "), this.submitRequest$2.args(), this.submitRequest$2.appConf(), this.submitRequest$2.buildResult()})))).stripMargin();
            }
            {
                this.submitRequest$2 = submitRequest$2;
            }
        });
        Tuple2 tuple2 = FlinkSubmitTrait$class.org$apache$streampark$flink$client$trait$FlinkSubmitTrait$$getCommandLineAndFlinkConfig($this, submitRequest);
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            Tuple2 tuple22;
            CommandLine commandLine = (CommandLine)tuple2._1();
            Configuration flinkConfig = (Configuration)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)commandLine, (Object)flinkConfig);
            CommandLine commandLine2 = (CommandLine)tuple23._1();
            Configuration flinkConfig2 = (Configuration)tuple23._2();
            if (submitRequest.userJarFile() == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                URI uri = PackagedProgramUtils.resolveURI((String)submitRequest.userJarFile().getAbsolutePath());
                ProgramOptions programOptions = ProgramOptions.create((CommandLine)commandLine2);
                ExecutionConfigAccessor executionParameters = ExecutionConfigAccessor.fromProgramOptions((ProgramOptions)programOptions, Collections.singletonList(uri.toString()));
                boxedUnit = executionParameters.applyToConfiguration(flinkConfig2);
            }
            $this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration($this.EnhanceFlinkConfiguration(flinkConfig2).safeSet(PipelineOptions.NAME, submitRequest.effectiveAppName())).safeSet(DeploymentOptions.TARGET, submitRequest.executionMode().getName())).safeSet(SavepointConfigOptions.SAVEPOINT_PATH, submitRequest.savePoint())).safeSet(ApplicationConfiguration.APPLICATION_MAIN_CLASS, submitRequest.appMain())).safeSet(ApplicationConfiguration.APPLICATION_ARGS, FlinkSubmitTrait$class.org$apache$streampark$flink$client$trait$FlinkSubmitTrait$$extractProgramArgs($this, submitRequest))).safeSet(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID, submitRequest.jobId());
            Configuration flinkDefaultConfiguration = $this.getFlinkDefaultConfiguration(submitRequest.flinkVersion().flinkHome());
            ConfigOption retainedOption = CheckpointingOptions.MAX_RETAINED_CHECKPOINTS;
            $this.EnhanceFlinkConfiguration(flinkConfig2).safeSet(retainedOption, flinkDefaultConfiguration.get(retainedOption));
            if (submitRequest.savePoint() != null) {
                $this.EnhanceFlinkConfiguration(flinkConfig2).safeSet(SavepointConfigOptions.SAVEPOINT_PATH, submitRequest.savePoint());
                flinkConfig2.setBoolean(SavepointConfigOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE, submitRequest.allowNonRestoredState());
            }
            $this.setJvmOptions(submitRequest, flinkConfig2);
            $this.setConfig(submitRequest, flinkConfig2);
            return $this.doSubmit(submitRequest, flinkConfig2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static void setJvmOptions(FlinkSubmitTrait $this, SubmitRequest submitRequest, Configuration flinkConfig) {
        if (MapUtils.isNotEmpty((Map)submitRequest.properties())) {
            JavaConversions$.MODULE$.mapAsScalaMap(submitRequest.properties()).foreach((Function1)new Serializable($this, flinkConfig){
                public static final long serialVersionUID = 0L;
                private final Configuration flinkConfig$1;

                public final Object apply(Tuple2<String, Object> x) {
                    Object object;
                    String k = ((String)x._1()).trim();
                    String v = x._2().toString();
                    String string = k;
                    String string2 = CoreOptions.FLINK_JVM_OPTIONS.key();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        object = this.flinkConfig$1.set(CoreOptions.FLINK_JVM_OPTIONS, (Object)v);
                    } else {
                        String string3 = k;
                        String string4 = CoreOptions.FLINK_JM_JVM_OPTIONS.key();
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            object = this.flinkConfig$1.set(CoreOptions.FLINK_JM_JVM_OPTIONS, (Object)v);
                        } else {
                            String string5 = k;
                            String string6 = CoreOptions.FLINK_HS_JVM_OPTIONS.key();
                            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                                object = this.flinkConfig$1.set(CoreOptions.FLINK_HS_JVM_OPTIONS, (Object)v);
                            } else {
                                String string7 = k;
                                String string8 = CoreOptions.FLINK_TM_JVM_OPTIONS.key();
                                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                                    object = this.flinkConfig$1.set(CoreOptions.FLINK_TM_JVM_OPTIONS, (Object)v);
                                } else {
                                    String string9 = k;
                                    String string10 = CoreOptions.FLINK_CLI_JVM_OPTIONS.key();
                                    object = !(string9 != null ? !string9.equals(string10) : string10 != null) ? this.flinkConfig$1.set(CoreOptions.FLINK_CLI_JVM_OPTIONS, (Object)v) : BoxedUnit.UNIT;
                                }
                            }
                        }
                    }
                    return object;
                }
                {
                    this.flinkConfig$1 = flinkConfig$1;
                }
            });
        }
    }

    public static CancelResponse cancel(FlinkSubmitTrait $this, CancelRequest cancelRequest) throws Exception {
        $this.logInfo((Function0)new Serializable($this, cancelRequest){
            public static final long serialVersionUID = 0L;
            private final CancelRequest cancelRequest$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |----------------------------------------- flink job cancel --------------------------------------\n         |     userFlinkHome  : ", "\n         |     flinkVersion   : ", "\n         |     clusterId      : ", "\n         |     withSavePoint  : ", "\n         |     savePointPath  : ", "\n         |     withDrain      : ", "\n         |     k8sNamespace   : ", "\n         |     appId          : ", "\n         |     jobId          : ", "\n         |-------------------------------------------------------------------------------------------\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cancelRequest$1.flinkVersion().flinkHome(), this.cancelRequest$1.flinkVersion().version(), this.cancelRequest$1.clusterId(), BoxesRunTime.boxToBoolean((boolean)this.cancelRequest$1.withSavePoint()), this.cancelRequest$1.customSavePointPath(), BoxesRunTime.boxToBoolean((boolean)this.cancelRequest$1.withDrain()), this.cancelRequest$1.kubernetesNamespace(), this.cancelRequest$1.clusterId(), this.cancelRequest$1.jobId()})))).stripMargin();
            }
            {
                this.cancelRequest$1 = cancelRequest$1;
            }
        });
        Configuration flinkConf = new Configuration();
        return $this.doCancel(cancelRequest, flinkConf);
    }

    public static SubmitResponse trySubmit(FlinkSubmitTrait $this, SubmitRequest submitRequest, Configuration flinkConfig, File jarFile, Function3 restApiFunc, Function3 jobGraphFunc) {
        return (SubmitResponse)Try$.MODULE$.apply((Function0)new Serializable($this, submitRequest, flinkConfig, jarFile, restApiFunc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkSubmitTrait $outer;
            private final SubmitRequest submitRequest$3;
            private final Configuration flinkConfig$2;
            private final File jarFile$1;
            private final Function3 restApiFunc$1;

            public final SubmitResponse apply() {
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[flink-submit] Attempting to submit in Rest API Submit Plan."})).s((Seq)Nil$.MODULE$);
                    }
                });
                return (SubmitResponse)this.restApiFunc$1.apply((Object)this.submitRequest$3, (Object)this.flinkConfig$2, (Object)this.jarFile$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.submitRequest$3 = submitRequest$3;
                this.flinkConfig$2 = flinkConfig$2;
                this.jarFile$1 = jarFile$1;
                this.restApiFunc$1 = restApiFunc$1;
            }
        }).getOrElse((Function0)new Serializable($this, submitRequest, flinkConfig, jarFile, jobGraphFunc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkSubmitTrait $outer;
            public final SubmitRequest submitRequest$3;
            public final Configuration flinkConfig$2;
            public final File jarFile$1;
            public final Function3 jobGraphFunc$1;

            public final SubmitResponse apply() {
                this.$outer.logWarn((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[flink-submit] RestAPI Submit Plan failed,try JobGraph Submit Plan now."})).s((Seq)Nil$.MODULE$);
                    }
                });
                Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FlinkSubmitTrait$.anonfun.trySubmit.2 $outer;

                    public final SubmitResponse apply() {
                        return (SubmitResponse)this.$outer.jobGraphFunc$1.apply((Object)this.$outer.submitRequest$3, (Object)this.$outer.flinkConfig$2, (Object)this.$outer.jarFile$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (try_ instanceof Success) {
                    SubmitResponse r;
                    Success success = (Success)try_;
                    SubmitResponse submitResponse = r = (SubmitResponse)success.value();
                    return submitResponse;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.$outer.logError((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[flink-submit] Both Rest API Submit Plan and JobGraph Submit Plan failed."})).s((Seq)Nil$.MODULE$);
                        }
                    });
                    throw e;
                }
                throw new MatchError((Object)try_);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.submitRequest$3 = submitRequest$3;
                this.flinkConfig$2 = flinkConfig$2;
                this.jarFile$1 = jarFile$1;
                this.jobGraphFunc$1 = jobGraphFunc$1;
            }
        });
    }

    public static Tuple2 getJobGraph(FlinkSubmitTrait $this, Configuration flinkConfig, SubmitRequest submitRequest, File jarFile) {
        PackagedProgram packageProgram = PackagedProgram.newBuilder().setJarFile(jarFile).setEntryPointClassName((String)flinkConfig.getOptional(ApplicationConfiguration.APPLICATION_MAIN_CLASS).get()).setSavepointRestoreSettings(submitRequest.savepointRestoreSettings()).setArguments((String[])JavaConversions$.MODULE$.asScalaBuffer((List)flinkConfig.getOptional(ApplicationConfiguration.APPLICATION_ARGS).orElse(Lists.newArrayList())).toArray(ClassTag$.MODULE$.apply(String.class))).build();
        JobGraph jobGraph = PackagedProgramUtils.createJobGraph((PackagedProgram)packageProgram, (Configuration)flinkConfig, (int)Predef$.MODULE$.Integer2int($this.getParallelism(submitRequest)), null, (boolean)false);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)packageProgram), (Object)jobGraph);
    }

    public static JobID getJobID(FlinkSubmitTrait $this, String jobId) {
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable($this, jobId){
            public static final long serialVersionUID = 0L;
            private final String jobId$1;

            public final JobID apply() {
                return JobID.fromHexString((String)this.jobId$1);
            }
            {
                this.jobId$1 = jobId$1;
            }
        });
        if (try_ instanceof Success) {
            JobID id;
            Success success = (Success)try_;
            JobID jobID = id = (JobID)success.value();
            return jobID;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw new CliArgsException(e.getMessage());
        }
        throw new MatchError((Object)try_);
    }

    public static CustomCommandLine validateAndGetActiveCommandLine(FlinkSubmitTrait $this, List customCommandLines, CommandLine commandLine) {
        Object object = new Object();
        try {
            CommandLine line = (CommandLine)Preconditions.checkNotNull((Object)commandLine);
            $this.logInfo((Function0)new Serializable($this, customCommandLines){
                public static final long serialVersionUID = 0L;
                private final List customCommandLines$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Custom commandline: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.customCommandLines$1}));
                }
                {
                    this.customCommandLines$1 = customCommandLines$1;
                }
            });
            JavaConversions$.MODULE$.asScalaBuffer(customCommandLines).foreach((Function1)new Serializable($this, line, object){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FlinkSubmitTrait $outer;
                private final CommandLine line$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(CustomCommandLine cli) {
                    boolean isActive = cli.isActive(this.line$1);
                    this.$outer.logInfo((Function0)new Serializable(this, isActive, cli){
                        public static final long serialVersionUID = 0L;
                        private final boolean isActive$1;
                        private final CustomCommandLine cli$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking custom commandline ", ", isActive: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cli$1, BoxesRunTime.boxToBoolean((boolean)this.isActive$1)}));
                        }
                        {
                            this.isActive$1 = isActive$1;
                            this.cli$1 = cli$1;
                        }
                    });
                    if (isActive) {
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)cli);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.line$1 = line$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            throw new IllegalStateException("No valid command-line found.");
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return (CustomCommandLine)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    public static Configuration getFlinkDefaultConfiguration(FlinkSubmitTrait $this, String flinkHome) {
        return (Configuration)Try$.MODULE$.apply((Function0)new Serializable($this, flinkHome){
            public static final long serialVersionUID = 0L;
            private final String flinkHome$1;

            public final Configuration apply() {
                return GlobalConfiguration.loadConfiguration((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.flinkHome$1})));
            }
            {
                this.flinkHome$1 = flinkHome$1;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Configuration apply() {
                return new Configuration();
            }
        });
    }

    public static Object getOptionFromDefaultFlinkConfig(FlinkSubmitTrait $this, String flinkHome, ConfigOption option) {
        return $this.getFlinkDefaultConfiguration(flinkHome).get(option);
    }

    public static List org$apache$streampark$flink$client$trait$FlinkSubmitTrait$$getCustomCommandLines(FlinkSubmitTrait $this, String flinkHome) {
        Configuration flinkDefaultConfiguration = $this.getFlinkDefaultConfiguration(flinkHome);
        String configurationDirectory = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{flinkHome}));
        List customCommandLines = CliFrontend.loadCustomCommandLines((Configuration)flinkDefaultConfiguration, (String)configurationDirectory);
        new CliFrontend(flinkDefaultConfiguration, customCommandLines);
        return customCommandLines;
    }

    public static Integer getParallelism(FlinkSubmitTrait $this, SubmitRequest submitRequest) {
        return submitRequest.properties().containsKey(ConfigConst$.MODULE$.KEY_FLINK_PARALLELISM(ConfigConst$.MODULE$.KEY_FLINK_PARALLELISM$default$1())) ? Integer.valueOf(submitRequest.properties().get(ConfigConst$.MODULE$.KEY_FLINK_PARALLELISM(ConfigConst$.MODULE$.KEY_FLINK_PARALLELISM$default$1())).toString()) : Predef$.MODULE$.int2Integer($this.getFlinkDefaultConfiguration(submitRequest.flinkVersion().flinkHome()).getInteger(CoreOptions.DEFAULT_PARALLELISM, Predef$.MODULE$.Integer2int((Integer)CoreOptions.DEFAULT_PARALLELISM.defaultValue())));
    }

    public static Tuple2 org$apache$streampark$flink$client$trait$FlinkSubmitTrait$$getCommandLineAndFlinkConfig(FlinkSubmitTrait $this, SubmitRequest submitRequest) {
        Options commandLineOptions = $this.getCommandLineOptions(submitRequest.flinkVersion().flinkHome());
        HashMap optionMap = new HashMap();
        ((IterableLike)submitRequest.appOption().filter((Function1)new Serializable($this, commandLineOptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkSubmitTrait $outer;
            private final Options commandLineOptions$1;

            /*
             * WARNING - void declaration
             */
            public final boolean apply(Tuple2<String, String> x) {
                void var2_2;
                boolean verify = this.commandLineOptions$1.hasOption((String)x._1());
                if (!verify) {
                    this.$outer.logWarn((Function0)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final Tuple2 x$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"param:", " is error,skip it."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x$3._1()}));
                        }
                        {
                            this.x$3 = x$3;
                        }
                    });
                }
                return (boolean)var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commandLineOptions$1 = commandLineOptions$1;
            }
        })).foreach((Function1)new Serializable($this, commandLineOptions, optionMap){
            public static final long serialVersionUID = 0L;
            private final Options commandLineOptions$1;
            private final HashMap optionMap$1;

            public final Object apply(Tuple2<String, String> x) {
                String opt = this.commandLineOptions$1.getOption(((String)x._1()).trim()).getOpt();
                Object object = Try$.MODULE$.apply((Function0)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 x$4;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return new StringOps(Predef$.MODULE$.augmentString((String)this.x$4._2())).toBoolean();
                    }
                    {
                        this.x$4 = x$4;
                    }
                }).getOrElse((Function0)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 x$4;

                    public final String apply() {
                        return (String)this.x$4._2();
                    }
                    {
                        this.x$4 = x$4;
                    }
                });
                Object object2 = object instanceof Boolean ? (BoxesRunTime.unboxToBoolean((Object)object) ? this.optionMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opt}))), (Object)BoxesRunTime.boxToBoolean((boolean)true))) : BoxedUnit.UNIT) : this.optionMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opt}))), object));
                return object2;
            }
            {
                this.commandLineOptions$1 = commandLineOptions$1;
                this.optionMap$1 = optionMap$1;
            }
        });
        Object object = submitRequest.savePoint() == null ? BoxedUnit.UNIT : optionMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FlinkRunOption$.MODULE$.SAVEPOINT_PATH_OPTION().getOpt()}))), (Object)submitRequest.savePoint()));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-e", "--executor", "-t", "--target"}))).foreach((Function1)new Serializable($this, optionMap){
            public static final long serialVersionUID = 0L;
            private final HashMap optionMap$1;

            public final Option<Object> apply(String key) {
                return this.optionMap$1.remove((Object)key);
            }
            {
                this.optionMap$1 = optionMap$1;
            }
        });
        Object object2 = submitRequest.executionMode() == null ? BoxedUnit.UNIT : optionMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-t"), (Object)submitRequest.executionMode().getName()));
        ArrayBuffer array = new ArrayBuffer();
        optionMap.foreach((Function1)new Serializable($this, array){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer array$1;

            public final Object apply(Tuple2<String, Object> x) {
                BoxedUnit boxedUnit;
                this.array$1.$plus$eq(x._1());
                Object object = x._2();
                if (object instanceof String) {
                    String string = (String)object;
                    boxedUnit = this.array$1.$plus$eq((Object)string);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.array$1 = array$1;
            }
        });
        if (MapUtils.isNotEmpty((Map)submitRequest.properties())) {
            JavaConversions$.MODULE$.mapAsScalaMap(submitRequest.properties()).foreach((Function1)new Serializable($this, array){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer array$1;

                public final Object apply(Tuple2<String, Object> x) {
                    return ((String)x._1()).startsWith(CoreOptions.FLINK_JVM_OPTIONS.key()) ? BoxedUnit.UNIT : this.array$1.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x._1(), x._2()})));
                }
                {
                    this.array$1 = array$1;
                }
            });
        }
        String[] cliArgs = (String[])array.toArray(ClassTag$.MODULE$.apply(String.class));
        $this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cliArgs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])cliArgs).mkString(" ")})));
        FlinkRunOption$.MODULE$.parse(commandLineOptions, cliArgs, Predef$.MODULE$.boolean2Boolean(true));
        CommandLine commandLine = FlinkRunOption$.MODULE$.parse(commandLineOptions, cliArgs, Predef$.MODULE$.boolean2Boolean(true));
        CustomCommandLine activeCommandLine = $this.validateAndGetActiveCommandLine(FlinkSubmitTrait$class.org$apache$streampark$flink$client$trait$FlinkSubmitTrait$$getCustomCommandLines($this, submitRequest.flinkVersion().flinkHome()), commandLine);
        Configuration configuration = FlinkSubmitTrait$class.org$apache$streampark$flink$client$trait$FlinkSubmitTrait$$applyConfiguration($this, submitRequest.flinkVersion().flinkHome(), activeCommandLine, commandLine);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)commandLine), (Object)configuration);
    }

    public static Options getCommandLineOptions(FlinkSubmitTrait $this, String flinkHome) {
        List customCommandLines = FlinkSubmitTrait$class.org$apache$streampark$flink$client$trait$FlinkSubmitTrait$$getCustomCommandLines($this, flinkHome);
        Options customCommandLineOptions = new Options();
        JavaConversions$.MODULE$.asScalaBuffer(customCommandLines).foreach((Function1)new Serializable($this, customCommandLineOptions){
            public static final long serialVersionUID = 0L;
            private final Options customCommandLineOptions$1;

            public final void apply(CustomCommandLine customCommandLine) {
                customCommandLine.addGeneralOptions(this.customCommandLineOptions$1);
                customCommandLine.addRunOptions(this.customCommandLineOptions$1);
            }
            {
                this.customCommandLineOptions$1 = customCommandLineOptions$1;
            }
        });
        return FlinkRunOption$.MODULE$.mergeOptions(CliFrontendParser.getRunCommandOptions(), customCommandLineOptions);
    }

    public static Configuration extractConfiguration(FlinkSubmitTrait $this, String flinkHome, Map properties) {
        Options commandLineOptions = $this.getCommandLineOptions(flinkHome);
        ArrayBuffer array = new ArrayBuffer();
        if (MapUtils.isNotEmpty((Map)properties)) {
            JavaConversions$.MODULE$.mapAsScalaMap(properties).foreach((Function1)new Serializable($this, array){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer array$2;

                public final ArrayBuffer<String> apply(Tuple2<String, Object> x) {
                    return this.array$2.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x._1(), x._2().toString().trim()})));
                }
                {
                    this.array$2 = array$2;
                }
            });
        }
        String[] cliArgs = (String[])array.toArray(ClassTag$.MODULE$.apply(String.class));
        CommandLine commandLine = FlinkRunOption$.MODULE$.parse(commandLineOptions, cliArgs, Predef$.MODULE$.boolean2Boolean(true));
        CustomCommandLine activeCommandLine = $this.validateAndGetActiveCommandLine(FlinkSubmitTrait$class.org$apache$streampark$flink$client$trait$FlinkSubmitTrait$$getCustomCommandLines($this, flinkHome), commandLine);
        Configuration flinkConfig = FlinkSubmitTrait$class.org$apache$streampark$flink$client$trait$FlinkSubmitTrait$$applyConfiguration($this, flinkHome, activeCommandLine, commandLine);
        return flinkConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List org$apache$streampark$flink$client$trait$FlinkSubmitTrait$$extractProgramArgs(FlinkSubmitTrait $this, SubmitRequest submitRequest) {
        BoxedUnit boxedUnit;
        ArrayBuffer programArgs = new ArrayBuffer();
        if (StringUtils.isNotEmpty((CharSequence)submitRequest.args())) {
            String multiLineChar = "\"\"\"";
            String[] array = submitRequest.args().split("\\s+");
            if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])array).filter((Function1)new Serializable($this, multiLineChar){
                public static final long serialVersionUID = 0L;
                private final String multiLineChar$1;

                public final boolean apply(String x$2) {
                    return x$2.startsWith(this.multiLineChar$1);
                }
                {
                    this.multiLineChar$1 = multiLineChar$1;
                }
            })).isEmpty()) {
                Predef$.MODULE$.refArrayOps((Object[])array).foreach((Function1)new Serializable($this, programArgs){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer programArgs$1;

                    public final ArrayBuffer<String> apply(String elem) {
                        return this.programArgs$1.$plus$eq((Object)elem);
                    }
                    {
                        this.programArgs$1 = programArgs$1;
                    }
                });
            } else {
                ArrayBuffer argsArray = new ArrayBuffer();
                ArrayBuffer tempBuffer = new ArrayBuffer();
                FlinkSubmitTrait$class.processElement$1($this, 0, false, multiLineChar, array, argsArray, tempBuffer);
                argsArray.foreach((Function1)new Serializable($this, programArgs){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer programArgs$1;

                    public final ArrayBuffer<String> apply(String x) {
                        return this.programArgs$1.$plus$eq((Object)x.trim());
                    }
                    {
                        this.programArgs$1 = programArgs$1;
                    }
                });
            }
        }
        ApplicationType applicationType = submitRequest.applicationType();
        ApplicationType applicationType2 = ApplicationType.STREAMPARK_FLINK;
        if (!(applicationType != null ? !applicationType.equals(applicationType2) : applicationType2 != null)) {
            BoxedUnit boxedUnit2;
            programArgs.$plus$eq((Object)$this.PARAM_KEY_FLINK_CONF());
            programArgs.$plus$eq((Object)submitRequest.flinkYaml());
            programArgs.$plus$eq((Object)$this.PARAM_KEY_APP_NAME());
            programArgs.$plus$eq((Object)DeflaterUtils$.MODULE$.zipString(submitRequest.effectiveAppName()));
            programArgs.$plus$eq((Object)$this.PARAM_KEY_FLINK_PARALLELISM());
            programArgs.$plus$eq((Object)$this.getParallelism(submitRequest).toString());
            DevelopmentMode developmentMode = submitRequest.developmentMode();
            if (DevelopmentMode.FLINKSQL.equals(developmentMode)) {
                BoxedUnit boxedUnit3;
                programArgs.$plus$eq((Object)$this.PARAM_KEY_FLINK_SQL());
                programArgs.$plus$eq((Object)submitRequest.flinkSQL());
                if (submitRequest.appConf() == null) {
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    programArgs.$plus$eq((Object)$this.PARAM_KEY_APP_CONF());
                    boxedUnit3 = programArgs.$plus$eq((Object)submitRequest.appConf());
                }
                boxedUnit2 = boxedUnit3;
            } else {
                if (!BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable($this, submitRequest){
                    public static final long serialVersionUID = 0L;
                    private final SubmitRequest submitRequest$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return !this.submitRequest$1.appConf().startsWith("json:");
                    }
                    {
                        this.submitRequest$1 = submitRequest$1;
                    }
                }).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                }))) throw new MatchError((Object)developmentMode);
                programArgs.$plus$eq((Object)$this.PARAM_KEY_APP_CONF());
                boxedUnit2 = programArgs.$plus$eq((Object)submitRequest.appConf());
            }
            boxedUnit = boxedUnit2;
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)programArgs.toList()).asJava();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)programArgs.toList()).asJava();
    }

    public static Configuration org$apache$streampark$flink$client$trait$FlinkSubmitTrait$$applyConfiguration(FlinkSubmitTrait $this, String flinkHome, CustomCommandLine activeCustomCommandLine, CommandLine commandLine) {
        Predef$.MODULE$.require(activeCustomCommandLine != null, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "activeCustomCommandLine must not be null.";
            }
        });
        Configuration executorConfig = activeCustomCommandLine.toConfiguration(commandLine);
        Configuration customConfiguration = new Configuration(executorConfig);
        Configuration configuration = new Configuration();
        Configuration flinkDefaultConfiguration = $this.getFlinkDefaultConfiguration(flinkHome);
        JavaConversions$.MODULE$.asScalaSet(flinkDefaultConfiguration.keySet()).foreach((Function1)new Serializable($this, configuration, flinkDefaultConfiguration){
            public static final long serialVersionUID = 0L;
            private final Configuration configuration$1;
            private final Configuration flinkDefaultConfiguration$1;

            public final void apply(String x) {
                String string = this.flinkDefaultConfiguration$1.getString(x, null);
                if (string == null) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.configuration$1.setString(x, string);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.configuration$1 = configuration$1;
                this.flinkDefaultConfiguration$1 = flinkDefaultConfiguration$1;
            }
        });
        configuration.addAll(customConfiguration);
        return configuration;
    }

    public static FlinkSubmitTrait.EnhanceFlinkConfiguration EnhanceFlinkConfiguration(FlinkSubmitTrait $this, Configuration flinkConfig) {
        return new FlinkSubmitTrait.EnhanceFlinkConfiguration($this, flinkConfig);
    }

    public static String cancelJob(FlinkSubmitTrait $this, CancelRequest cancelRequest, JobID jobID, ClusterClient client) {
        Tuple2.mcZZ.sp sp2;
        block11: {
            String string;
            block9: {
                FlinkClusterClient clientWrapper;
                Duration clientTimeout;
                String savePointDir;
                block10: {
                    block8: {
                        String string2;
                        if (cancelRequest.withSavePoint()) {
                            if (StringUtils.isNotEmpty((CharSequence)cancelRequest.customSavePointPath())) {
                                string2 = cancelRequest.customSavePointPath();
                            } else {
                                ExecutionMode executionMode = cancelRequest.executionMode();
                                ExecutionMode executionMode2 = ExecutionMode.YARN_APPLICATION;
                                String configDir = (String)$this.getOptionFromDefaultFlinkConfig(cancelRequest.flinkVersion().flinkHome(), ConfigOptions.key((String)CheckpointingOptions.SAVEPOINT_DIRECTORY.key()).stringType().defaultValue(!(executionMode != null ? !executionMode.equals(executionMode2) : executionMode2 != null) ? Workspace$.MODULE$.remote().APP_SAVEPOINTS() : null));
                                if (StringUtils.isEmpty((CharSequence)configDir)) {
                                    throw new FlinkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] executionMode: ", ", savePoint path is null or invalid."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cancelRequest.executionMode().getName()})));
                                }
                                string2 = configDir;
                            }
                        } else {
                            string2 = null;
                        }
                        savePointDir = string2;
                        clientTimeout = (Duration)$this.getOptionFromDefaultFlinkConfig(cancelRequest.flinkVersion().flinkHome(), ClientOptions.CLIENT_TIMEOUT);
                        clientWrapper = new FlinkClusterClient(client);
                        sp2 = new Tuple2.mcZZ.sp(BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable($this, cancelRequest){
                            public static final long serialVersionUID = 0L;
                            private final CancelRequest cancelRequest$2;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return this.cancelRequest$2.withSavePoint();
                            }
                            {
                                this.cancelRequest$2 = cancelRequest$2;
                            }
                        }).getOrElse((Function0)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return false;
                            }
                        })), BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable($this, cancelRequest){
                            public static final long serialVersionUID = 0L;
                            private final CancelRequest cancelRequest$2;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return this.cancelRequest$2.withDrain();
                            }
                            {
                                this.cancelRequest$2 = cancelRequest$2;
                            }
                        }).getOrElse((Function0)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return false;
                            }
                        })));
                        if (sp2 == null) break block8;
                        boolean bl = sp2._1$mcZ$sp();
                        boolean bl2 = sp2._2$mcZ$sp();
                        if (bl || bl2) break block8;
                        client.cancel(jobID).get();
                        string = null;
                        break block9;
                    }
                    if (sp2 == null) break block10;
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl3 = sp2._2$mcZ$sp();
                    if (!bl || bl3) break block10;
                    string = (String)clientWrapper.cancelWithSavepoint(jobID, savePointDir).get(clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
                    break block9;
                }
                if (sp2 == null) break block11;
                string = (String)clientWrapper.stopWithSavepoint(jobID, cancelRequest.withDrain(), savePointDir).get(clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            return string;
        }
        throw new MatchError((Object)sp2);
    }

    private static final void processElement$1(FlinkSubmitTrait $this, int index, boolean multiLine, String multiLineChar$1, String[] array$3, ArrayBuffer argsArray$1, ArrayBuffer tempBuffer$1) {
        while (true) {
            if (index == array$3.length) {
                Object object = tempBuffer$1.nonEmpty() ? argsArray$1.$plus$eq((Object)tempBuffer$1.mkString(" ")) : BoxedUnit.UNIT;
                return;
            }
            int next = index + 1;
            String elem = array$3[index];
            if (new StringOps(Predef$.MODULE$.augmentString(elem.trim())).nonEmpty()) {
                if (multiLine) {
                    if (elem.endsWith(multiLineChar$1)) {
                        tempBuffer$1.$plus$eq(new StringOps(Predef$.MODULE$.augmentString(elem)).dropRight(3));
                        argsArray$1.$plus$eq((Object)tempBuffer$1.mkString(" "));
                        tempBuffer$1.clear();
                        multiLine = false;
                        index = next;
                        continue;
                    }
                    tempBuffer$1.$plus$eq((Object)elem);
                    index = next;
                    continue;
                }
                if (elem.startsWith(multiLineChar$1)) {
                    tempBuffer$1.$plus$eq(new StringOps(Predef$.MODULE$.augmentString(elem)).drop(3));
                    multiLine = true;
                    index = next;
                    continue;
                }
                argsArray$1.$plus$eq((Object)elem);
                multiLine = false;
                index = next;
                continue;
            }
            tempBuffer$1.$plus$eq((Object)elem);
            multiLine = false;
            index = next;
        }
    }

    public static void $init$(FlinkSubmitTrait $this) {
    }
}

