/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.system.entity.Member;
import org.apache.streampark.console.system.entity.Team;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.mapper.MemberMapper;
import org.apache.streampark.console.system.service.MemberService;
import org.apache.streampark.console.system.service.RoleService;
import org.apache.streampark.console.system.service.TeamService;
import org.apache.streampark.console.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class MemberServiceImpl
extends ServiceImpl<MemberMapper, Member>
implements MemberService {
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private TeamService teamService;

    @Override
    @Transactional
    public void deleteByRoleIds(String[] roleIds) {
        Arrays.stream(roleIds).forEach(id -> ((MemberMapper)this.baseMapper).deleteByRoleId(Long.valueOf(id)));
    }

    @Override
    @Transactional
    public void deleteByUserId(Long userId) {
        ((MemberMapper)this.baseMapper).deleteByUserId(userId);
    }

    @Override
    public void deleteByTeamId(Long teamId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Member::getTeamId, (Object)teamId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public IPage<Member> findUsers(Member member, RestRequest request) {
        Utils.required((member.getTeamId() != null ? 1 : 0) != 0, (Object)"The team id is required.");
        Page page = new Page();
        page.setCurrent((long)request.getPageNum());
        page.setSize((long)request.getPageSize());
        return ((MemberMapper)this.baseMapper).findUsers((Page<Member>)page, member);
    }

    @Override
    public List<User> findCandidateUsers(Long teamId) {
        return ((MemberMapper)this.baseMapper).findUsersNotInTeam(teamId);
    }

    @Override
    public List<Team> findUserTeams(Long userId) {
        return this.teamService.findUserTeams(userId);
    }

    @Override
    public Member findByUserName(Long teamId, String userName) {
        User user = this.userService.findByName(userName);
        if (user == null) {
            return null;
        }
        return this.findByUserId(teamId, user.getUserId());
    }

    private Member findByUserId(Long teamId, Long userId) {
        Utils.required((teamId != null ? 1 : 0) != 0, (Object)"The team id is required.");
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Member::getTeamId, (Object)teamId)).eq(Member::getUserId, (Object)userId);
        return (Member)((MemberMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    @Override
    public List<Long> findUserIdsByRoleId(Long roleId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Member::getRoleId, (Object)roleId);
        List list = ((MemberMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return list.stream().map(Member::getUserId).collect(Collectors.toList());
    }

    @Override
    public void createMember(Member member) {
        User user = Optional.ofNullable(this.userService.findByName(member.getUserName())).orElseThrow(() -> new ApiAlertException(String.format("The username [%s] not found", member.getUserName())));
        Optional.ofNullable(this.roleService.getById(member.getRoleId())).orElseThrow(() -> new ApiAlertException(String.format("The roleId [%s] not found", member.getRoleId())));
        Team team = (Team)Optional.ofNullable(this.teamService.getById(member.getTeamId())).orElseThrow(() -> new ApiAlertException(String.format("The teamId [%s] not found", member.getTeamId())));
        Utils.required((this.findByUserId(member.getTeamId(), user.getUserId()) == null ? 1 : 0) != 0, (Object)String.format("The user [%s] has been added the team [%s], please don't add it again.", member.getUserName(), team.getTeamName()));
        member.setId(null);
        member.setUserId(user.getUserId());
        member.setCreateTime(new Date());
        member.setModifyTime(team.getCreateTime());
        this.save(member);
    }

    @Override
    public void deleteMember(Member memberArg) {
        Member member = (Member)Optional.ofNullable(this.getById(memberArg.getId())).orElseThrow(() -> new ApiAlertException(String.format("The member [id=%s] not found", memberArg.getId())));
        this.removeById(member);
        this.userService.clearLastTeam(member.getUserId(), member.getTeamId());
    }

    @Override
    public void updateMember(Member member) {
        Member oldMember = (Member)Optional.ofNullable(this.getById(member.getId())).orElseThrow(() -> new ApiAlertException(String.format("The member [id=%s] not found", member.getId())));
        Utils.required((boolean)oldMember.getTeamId().equals(member.getTeamId()), (Object)"Team id cannot be changed.");
        Utils.required((boolean)oldMember.getUserId().equals(member.getUserId()), (Object)"User id cannot be changed.");
        Optional.ofNullable(this.roleService.getById(member.getRoleId())).orElseThrow(() -> new ApiAlertException(String.format("The roleId [%s] not found", member.getRoleId())));
        oldMember.setRoleId(member.getRoleId());
        this.updateById(oldMember);
    }
}

