/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.util.JacksonUtils;
import org.apache.streampark.flink.packer.pipeline.BuildPipeline;
import org.apache.streampark.flink.packer.pipeline.BuildResult;
import org.apache.streampark.flink.packer.pipeline.PipeError;
import org.apache.streampark.flink.packer.pipeline.PipeSnapshot;
import org.apache.streampark.flink.packer.pipeline.PipelineStatus;
import org.apache.streampark.flink.packer.pipeline.PipelineStepStatus;
import org.apache.streampark.flink.packer.pipeline.PipelineType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TableName(value="t_app_build_pipe")
public class AppBuildPipeline {
    private static final Logger log = LoggerFactory.getLogger(AppBuildPipeline.class);
    @TableId(type=IdType.INPUT)
    private Long appId;
    @TableField(value="pipe_type")
    private Integer pipeTypeCode;
    @TableField(value="pipe_status")
    private Integer pipeStatusCode;
    private Integer curStep;
    private Integer totalStep;
    @TableField(value="steps_status")
    private String stepStatusJson;
    @TableField(value="steps_status_ts")
    private String stepStatusTimestampJson;
    @TableField(value="error")
    private String errorJson;
    @TableField(value="build_result")
    private String buildResultJson;
    private Date modifyTime;

    @Nonnull
    @JsonIgnore
    public PipelineType getPipeType() {
        return PipelineType.of((Integer)this.pipeTypeCode);
    }

    @JsonIgnore
    public AppBuildPipeline setPipeType(@Nonnull PipelineType pipeType) {
        this.pipeTypeCode = pipeType.getCode();
        return this;
    }

    @Nonnull
    @JsonIgnore
    public PipelineStatus getPipelineStatus() {
        return PipelineStatus.of((Integer)this.pipeStatusCode);
    }

    @JsonIgnore
    public AppBuildPipeline setPipeStatus(@Nonnull PipelineStatus pipeStatus) {
        this.pipeStatusCode = pipeStatus.getCode();
        return this;
    }

    @Nonnull
    @JsonIgnore
    public Map<Integer, PipelineStepStatus> getStepStatus() {
        if (StringUtils.isBlank((CharSequence)this.stepStatusJson)) {
            return Collections.emptyMap();
        }
        try {
            return JacksonUtils.read(this.stepStatusJson, new TypeReference<HashMap<Integer, PipelineStepStatus>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, stepStatusJson={}", (Object)this.stepStatusJson, (Object)e);
            return Collections.emptyMap();
        }
    }

    @JsonIgnore
    public AppBuildPipeline setStepStatus(@Nonnull Map<Integer, PipelineStepStatus> stepStatus) {
        try {
            this.stepStatusJson = JacksonUtils.write(stepStatus);
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, stepStatusMap=({})", (Object)stepStatus.entrySet().stream().map(et -> et.getKey() + "->" + et.getValue()).collect(Collectors.joining(",")), (Object)e);
        }
        return this;
    }

    @Nonnull
    @JsonIgnore
    public Map<Integer, Long> getStepStatusTimestamp() {
        if (StringUtils.isBlank((CharSequence)this.stepStatusTimestampJson)) {
            return Collections.emptyMap();
        }
        try {
            return JacksonUtils.read(this.stepStatusTimestampJson, new TypeReference<HashMap<Integer, Long>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, stepStatusJson={}", (Object)this.stepStatusTimestampJson, (Object)e);
            return Collections.emptyMap();
        }
    }

    @JsonIgnore
    public AppBuildPipeline setStepStatusTimestamp(@Nonnull Map<Integer, Long> stepStatusSt) {
        try {
            this.stepStatusTimestampJson = JacksonUtils.write(stepStatusSt);
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, stepStatusSt=({})", (Object)stepStatusSt.entrySet().stream().map(et -> et.getKey() + "->" + et.getValue()).collect(Collectors.joining(",")), (Object)e);
        }
        return this;
    }

    @Nonnull
    @JsonIgnore
    public PipeError getError() {
        if (StringUtils.isBlank((CharSequence)this.errorJson)) {
            return PipeError.empty();
        }
        try {
            return JacksonUtils.read(this.errorJson, PipeError.class);
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, errorJson={}", (Object)this.errorJson, (Object)e);
            return PipeError.empty();
        }
    }

    @JsonIgnore
    public AppBuildPipeline setError(@Nonnull PipeError error) {
        try {
            this.errorJson = JacksonUtils.write(error);
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, error={}", (Object)error, (Object)e);
        }
        return this;
    }

    @JsonIgnore
    public <R extends BuildResult> AppBuildPipeline setBuildResult(@Nonnull R result) {
        try {
            this.buildResultJson = JacksonUtils.write(result);
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, buildResult={}", result, (Object)e);
        }
        return this;
    }

    public long calCostSecond() {
        Map<Integer, Long> st = this.getStepStatusTimestamp();
        if (st.isEmpty()) {
            return 0L;
        }
        long max = st.values().stream().max(Long::compareTo).orElse(0L);
        long min = st.values().stream().min(Long::compareTo).orElse(0L);
        return (max - min) / 1000L;
    }

    @Nullable
    @JsonIgnore
    public <R extends BuildResult> R getBuildResult() {
        PipelineType pipeType = this.getPipeType();
        if (pipeType.isUnknown() || this.buildResultJson == null) {
            return null;
        }
        try {
            return (R)((BuildResult)JacksonUtils.read(this.buildResultJson, pipeType.getResultType()));
        }
        catch (JsonProcessingException e) {
            log.error("json parse error on ApplicationBuildPipeline, buildResultJson={}", (Object)this.buildResultJson, (Object)e);
            return null;
        }
    }

    public static AppBuildPipeline initFromPipeline(@Nonnull BuildPipeline pipeline) {
        return AppBuildPipeline.fromPipeSnapshot(pipeline.snapshot());
    }

    public static AppBuildPipeline fromPipeSnapshot(@Nonnull PipeSnapshot snapshot) {
        return new AppBuildPipeline().setPipeType(snapshot.pipeType()).setPipeStatus(snapshot.pipeStatus()).setTotalStep(snapshot.allSteps()).setCurStep(snapshot.curStep()).setStepStatus(snapshot.pureStepStatusAsJava()).setStepStatusTimestamp(snapshot.stepStatusTimestampAsJava()).setError(snapshot.error()).setModifyTime(new Date(snapshot.emitTime()));
    }

    public View toView() {
        return View.of(this);
    }

    public Long getAppId() {
        return this.appId;
    }

    public Integer getPipeTypeCode() {
        return this.pipeTypeCode;
    }

    public Integer getPipeStatusCode() {
        return this.pipeStatusCode;
    }

    public Integer getCurStep() {
        return this.curStep;
    }

    public Integer getTotalStep() {
        return this.totalStep;
    }

    public String getStepStatusJson() {
        return this.stepStatusJson;
    }

    public String getStepStatusTimestampJson() {
        return this.stepStatusTimestampJson;
    }

    public String getErrorJson() {
        return this.errorJson;
    }

    public String getBuildResultJson() {
        return this.buildResultJson;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public AppBuildPipeline setAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    public AppBuildPipeline setPipeTypeCode(Integer pipeTypeCode) {
        this.pipeTypeCode = pipeTypeCode;
        return this;
    }

    public AppBuildPipeline setPipeStatusCode(Integer pipeStatusCode) {
        this.pipeStatusCode = pipeStatusCode;
        return this;
    }

    public AppBuildPipeline setCurStep(Integer curStep) {
        this.curStep = curStep;
        return this;
    }

    public AppBuildPipeline setTotalStep(Integer totalStep) {
        this.totalStep = totalStep;
        return this;
    }

    public AppBuildPipeline setStepStatusJson(String stepStatusJson) {
        this.stepStatusJson = stepStatusJson;
        return this;
    }

    public AppBuildPipeline setStepStatusTimestampJson(String stepStatusTimestampJson) {
        this.stepStatusTimestampJson = stepStatusTimestampJson;
        return this;
    }

    public AppBuildPipeline setErrorJson(String errorJson) {
        this.errorJson = errorJson;
        return this;
    }

    public AppBuildPipeline setBuildResultJson(String buildResultJson) {
        this.buildResultJson = buildResultJson;
        return this;
    }

    public AppBuildPipeline setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppBuildPipeline)) {
            return false;
        }
        AppBuildPipeline other = (AppBuildPipeline)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$appId = this.getAppId();
        Long other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        Integer this$pipeTypeCode = this.getPipeTypeCode();
        Integer other$pipeTypeCode = other.getPipeTypeCode();
        if (this$pipeTypeCode == null ? other$pipeTypeCode != null : !((Object)this$pipeTypeCode).equals(other$pipeTypeCode)) {
            return false;
        }
        Integer this$pipeStatusCode = this.getPipeStatusCode();
        Integer other$pipeStatusCode = other.getPipeStatusCode();
        if (this$pipeStatusCode == null ? other$pipeStatusCode != null : !((Object)this$pipeStatusCode).equals(other$pipeStatusCode)) {
            return false;
        }
        Integer this$curStep = this.getCurStep();
        Integer other$curStep = other.getCurStep();
        if (this$curStep == null ? other$curStep != null : !((Object)this$curStep).equals(other$curStep)) {
            return false;
        }
        Integer this$totalStep = this.getTotalStep();
        Integer other$totalStep = other.getTotalStep();
        if (this$totalStep == null ? other$totalStep != null : !((Object)this$totalStep).equals(other$totalStep)) {
            return false;
        }
        String this$stepStatusJson = this.getStepStatusJson();
        String other$stepStatusJson = other.getStepStatusJson();
        if (this$stepStatusJson == null ? other$stepStatusJson != null : !this$stepStatusJson.equals(other$stepStatusJson)) {
            return false;
        }
        String this$stepStatusTimestampJson = this.getStepStatusTimestampJson();
        String other$stepStatusTimestampJson = other.getStepStatusTimestampJson();
        if (this$stepStatusTimestampJson == null ? other$stepStatusTimestampJson != null : !this$stepStatusTimestampJson.equals(other$stepStatusTimestampJson)) {
            return false;
        }
        String this$errorJson = this.getErrorJson();
        String other$errorJson = other.getErrorJson();
        if (this$errorJson == null ? other$errorJson != null : !this$errorJson.equals(other$errorJson)) {
            return false;
        }
        String this$buildResultJson = this.getBuildResultJson();
        String other$buildResultJson = other.getBuildResultJson();
        if (this$buildResultJson == null ? other$buildResultJson != null : !this$buildResultJson.equals(other$buildResultJson)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        return !(this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppBuildPipeline;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        Integer $pipeTypeCode = this.getPipeTypeCode();
        result = result * 59 + ($pipeTypeCode == null ? 43 : ((Object)$pipeTypeCode).hashCode());
        Integer $pipeStatusCode = this.getPipeStatusCode();
        result = result * 59 + ($pipeStatusCode == null ? 43 : ((Object)$pipeStatusCode).hashCode());
        Integer $curStep = this.getCurStep();
        result = result * 59 + ($curStep == null ? 43 : ((Object)$curStep).hashCode());
        Integer $totalStep = this.getTotalStep();
        result = result * 59 + ($totalStep == null ? 43 : ((Object)$totalStep).hashCode());
        String $stepStatusJson = this.getStepStatusJson();
        result = result * 59 + ($stepStatusJson == null ? 43 : $stepStatusJson.hashCode());
        String $stepStatusTimestampJson = this.getStepStatusTimestampJson();
        result = result * 59 + ($stepStatusTimestampJson == null ? 43 : $stepStatusTimestampJson.hashCode());
        String $errorJson = this.getErrorJson();
        result = result * 59 + ($errorJson == null ? 43 : $errorJson.hashCode());
        String $buildResultJson = this.getBuildResultJson();
        result = result * 59 + ($buildResultJson == null ? 43 : $buildResultJson.hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        return result;
    }

    public String toString() {
        return "AppBuildPipeline(appId=" + this.getAppId() + ", pipeTypeCode=" + this.getPipeTypeCode() + ", pipeStatusCode=" + this.getPipeStatusCode() + ", curStep=" + this.getCurStep() + ", totalStep=" + this.getTotalStep() + ", stepStatusJson=" + this.getStepStatusJson() + ", stepStatusTimestampJson=" + this.getStepStatusTimestampJson() + ", errorJson=" + this.getErrorJson() + ", buildResultJson=" + this.getBuildResultJson() + ", modifyTime=" + this.getModifyTime() + ")";
    }

    public AppBuildPipeline() {
    }

    public AppBuildPipeline(Long appId, Integer pipeTypeCode, Integer pipeStatusCode, Integer curStep, Integer totalStep, String stepStatusJson, String stepStatusTimestampJson, String errorJson, String buildResultJson, Date modifyTime) {
        this.appId = appId;
        this.pipeTypeCode = pipeTypeCode;
        this.pipeStatusCode = pipeStatusCode;
        this.curStep = curStep;
        this.totalStep = totalStep;
        this.stepStatusJson = stepStatusJson;
        this.stepStatusTimestampJson = stepStatusTimestampJson;
        this.errorJson = errorJson;
        this.buildResultJson = buildResultJson;
        this.modifyTime = modifyTime;
    }

    public static class Step {
        private Integer seq;
        private String desc;
        private Integer status;
        private Date ts;

        public Integer getSeq() {
            return this.seq;
        }

        public String getDesc() {
            return this.desc;
        }

        public Integer getStatus() {
            return this.status;
        }

        public Date getTs() {
            return this.ts;
        }

        public Step setSeq(Integer seq) {
            this.seq = seq;
            return this;
        }

        public Step setDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public Step setStatus(Integer status) {
            this.status = status;
            return this;
        }

        public Step setTs(Date ts) {
            this.ts = ts;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step)) {
                return false;
            }
            Step other = (Step)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$seq = this.getSeq();
            Integer other$seq = other.getSeq();
            if (this$seq == null ? other$seq != null : !((Object)this$seq).equals(other$seq)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            String this$desc = this.getDesc();
            String other$desc = other.getDesc();
            if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
                return false;
            }
            Date this$ts = this.getTs();
            Date other$ts = other.getTs();
            return !(this$ts == null ? other$ts != null : !((Object)this$ts).equals(other$ts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Step;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $seq = this.getSeq();
            result = result * 59 + ($seq == null ? 43 : ((Object)$seq).hashCode());
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            String $desc = this.getDesc();
            result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
            Date $ts = this.getTs();
            result = result * 59 + ($ts == null ? 43 : ((Object)$ts).hashCode());
            return result;
        }

        public String toString() {
            return "AppBuildPipeline.Step(seq=" + this.getSeq() + ", desc=" + this.getDesc() + ", status=" + this.getStatus() + ", ts=" + this.getTs() + ")";
        }
    }

    public static class View {
        private Long appId;
        private Integer pipeType;
        private Integer pipeStatus;
        private Integer curStep;
        private Integer totalStep;
        private Double percent;
        private Long costSec;
        private List<Step> steps;
        private Boolean hasError;
        private String errorSummary;
        private String errorStack;
        private Date updateTime;

        public static View of(@Nonnull AppBuildPipeline pipe) {
            Map stepDesc = pipe.getPipeType().getSteps();
            Map<Integer, PipelineStepStatus> stepStatus = pipe.getStepStatus();
            Map<Integer, Long> stepTs = pipe.getStepStatusTimestamp();
            ArrayList<Step> steps = new ArrayList<Step>(stepDesc.size());
            for (int i = 1; i <= pipe.getPipeType().getSteps().size(); ++i) {
                Step step = new Step().setSeq(i).setDesc(stepDesc.getOrDefault(i, "unknown step")).setStatus(stepStatus.getOrDefault(i, PipelineStepStatus.unknown).getCode());
                Long st = stepTs.get(i);
                if (st != null) {
                    step.setTs(new Date(st));
                }
                steps.add(step);
            }
            return new View().setAppId(pipe.getAppId()).setPipeType(pipe.getPipeTypeCode()).setPipeStatus(pipe.getPipeStatusCode()).setCurStep(pipe.getCurStep()).setTotalStep(pipe.getTotalStep()).setPercent(Utils.calPercent((long)(pipe.getBuildResult() == null ? (long)(pipe.getCurStep() - 1) : (long)pipe.getCurStep().intValue()), (long)pipe.getTotalStep().intValue())).setCostSec(pipe.calCostSecond()).setSteps(steps).setHasError(pipe.getError().nonEmpty()).setErrorSummary(pipe.getError().summary()).setErrorStack(pipe.getError().exceptionStack()).setUpdateTime(pipe.getModifyTime());
        }

        public Long getAppId() {
            return this.appId;
        }

        public Integer getPipeType() {
            return this.pipeType;
        }

        public Integer getPipeStatus() {
            return this.pipeStatus;
        }

        public Integer getCurStep() {
            return this.curStep;
        }

        public Integer getTotalStep() {
            return this.totalStep;
        }

        public Double getPercent() {
            return this.percent;
        }

        public Long getCostSec() {
            return this.costSec;
        }

        public List<Step> getSteps() {
            return this.steps;
        }

        public Boolean getHasError() {
            return this.hasError;
        }

        public String getErrorSummary() {
            return this.errorSummary;
        }

        public String getErrorStack() {
            return this.errorStack;
        }

        public Date getUpdateTime() {
            return this.updateTime;
        }

        public View setAppId(Long appId) {
            this.appId = appId;
            return this;
        }

        public View setPipeType(Integer pipeType) {
            this.pipeType = pipeType;
            return this;
        }

        public View setPipeStatus(Integer pipeStatus) {
            this.pipeStatus = pipeStatus;
            return this;
        }

        public View setCurStep(Integer curStep) {
            this.curStep = curStep;
            return this;
        }

        public View setTotalStep(Integer totalStep) {
            this.totalStep = totalStep;
            return this;
        }

        public View setPercent(Double percent) {
            this.percent = percent;
            return this;
        }

        public View setCostSec(Long costSec) {
            this.costSec = costSec;
            return this;
        }

        public View setSteps(List<Step> steps) {
            this.steps = steps;
            return this;
        }

        public View setHasError(Boolean hasError) {
            this.hasError = hasError;
            return this;
        }

        public View setErrorSummary(String errorSummary) {
            this.errorSummary = errorSummary;
            return this;
        }

        public View setErrorStack(String errorStack) {
            this.errorStack = errorStack;
            return this;
        }

        public View setUpdateTime(Date updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof View)) {
                return false;
            }
            View other = (View)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$appId = this.getAppId();
            Long other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
                return false;
            }
            Integer this$pipeType = this.getPipeType();
            Integer other$pipeType = other.getPipeType();
            if (this$pipeType == null ? other$pipeType != null : !((Object)this$pipeType).equals(other$pipeType)) {
                return false;
            }
            Integer this$pipeStatus = this.getPipeStatus();
            Integer other$pipeStatus = other.getPipeStatus();
            if (this$pipeStatus == null ? other$pipeStatus != null : !((Object)this$pipeStatus).equals(other$pipeStatus)) {
                return false;
            }
            Integer this$curStep = this.getCurStep();
            Integer other$curStep = other.getCurStep();
            if (this$curStep == null ? other$curStep != null : !((Object)this$curStep).equals(other$curStep)) {
                return false;
            }
            Integer this$totalStep = this.getTotalStep();
            Integer other$totalStep = other.getTotalStep();
            if (this$totalStep == null ? other$totalStep != null : !((Object)this$totalStep).equals(other$totalStep)) {
                return false;
            }
            Double this$percent = this.getPercent();
            Double other$percent = other.getPercent();
            if (this$percent == null ? other$percent != null : !((Object)this$percent).equals(other$percent)) {
                return false;
            }
            Long this$costSec = this.getCostSec();
            Long other$costSec = other.getCostSec();
            if (this$costSec == null ? other$costSec != null : !((Object)this$costSec).equals(other$costSec)) {
                return false;
            }
            Boolean this$hasError = this.getHasError();
            Boolean other$hasError = other.getHasError();
            if (this$hasError == null ? other$hasError != null : !((Object)this$hasError).equals(other$hasError)) {
                return false;
            }
            List<Step> this$steps = this.getSteps();
            List<Step> other$steps = other.getSteps();
            if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
                return false;
            }
            String this$errorSummary = this.getErrorSummary();
            String other$errorSummary = other.getErrorSummary();
            if (this$errorSummary == null ? other$errorSummary != null : !this$errorSummary.equals(other$errorSummary)) {
                return false;
            }
            String this$errorStack = this.getErrorStack();
            String other$errorStack = other.getErrorStack();
            if (this$errorStack == null ? other$errorStack != null : !this$errorStack.equals(other$errorStack)) {
                return false;
            }
            Date this$updateTime = this.getUpdateTime();
            Date other$updateTime = other.getUpdateTime();
            return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof View;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
            Integer $pipeType = this.getPipeType();
            result = result * 59 + ($pipeType == null ? 43 : ((Object)$pipeType).hashCode());
            Integer $pipeStatus = this.getPipeStatus();
            result = result * 59 + ($pipeStatus == null ? 43 : ((Object)$pipeStatus).hashCode());
            Integer $curStep = this.getCurStep();
            result = result * 59 + ($curStep == null ? 43 : ((Object)$curStep).hashCode());
            Integer $totalStep = this.getTotalStep();
            result = result * 59 + ($totalStep == null ? 43 : ((Object)$totalStep).hashCode());
            Double $percent = this.getPercent();
            result = result * 59 + ($percent == null ? 43 : ((Object)$percent).hashCode());
            Long $costSec = this.getCostSec();
            result = result * 59 + ($costSec == null ? 43 : ((Object)$costSec).hashCode());
            Boolean $hasError = this.getHasError();
            result = result * 59 + ($hasError == null ? 43 : ((Object)$hasError).hashCode());
            List<Step> $steps = this.getSteps();
            result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
            String $errorSummary = this.getErrorSummary();
            result = result * 59 + ($errorSummary == null ? 43 : $errorSummary.hashCode());
            String $errorStack = this.getErrorStack();
            result = result * 59 + ($errorStack == null ? 43 : $errorStack.hashCode());
            Date $updateTime = this.getUpdateTime();
            result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
            return result;
        }

        public String toString() {
            return "AppBuildPipeline.View(appId=" + this.getAppId() + ", pipeType=" + this.getPipeType() + ", pipeStatus=" + this.getPipeStatus() + ", curStep=" + this.getCurStep() + ", totalStep=" + this.getTotalStep() + ", percent=" + this.getPercent() + ", costSec=" + this.getCostSec() + ", steps=" + this.getSteps() + ", hasError=" + this.getHasError() + ", errorSummary=" + this.getErrorSummary() + ", errorStack=" + this.getErrorStack() + ", updateTime=" + this.getUpdateTime() + ")";
        }
    }
}

