/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.common.util.HadoopUtils;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.entity.Setting;
import org.apache.streampark.console.core.service.SettingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"flink/setting"})
public class SettingController {
    private static final Logger log = LoggerFactory.getLogger(SettingController.class);
    @Autowired
    private SettingService settingService;

    @PostMapping(value={"all"})
    @RequiresPermissions(value={"setting:view"})
    public RestResponse all() {
        LambdaQueryWrapper query = (LambdaQueryWrapper)new LambdaQueryWrapper().orderByAsc(Setting::getOrderNum);
        List setting = this.settingService.list((Wrapper)query);
        return RestResponse.success(setting);
    }

    @PostMapping(value={"get"})
    public RestResponse get(String key) {
        Setting setting = this.settingService.get(key);
        return RestResponse.success(setting);
    }

    @PostMapping(value={"weburl"})
    public RestResponse webUrl() {
        String url = this.settingService.getStreamParkAddress();
        return RestResponse.success(url == null ? null : url.trim());
    }

    @PostMapping(value={"update"})
    @RequiresPermissions(value={"setting:update"})
    public RestResponse update(Setting setting) {
        boolean updated = this.settingService.update(setting);
        return RestResponse.success(updated);
    }

    @PostMapping(value={"checkHadoop"})
    public RestResponse checkHadoop() {
        try {
            HadoopUtils.hdfs().getStatus();
            return RestResponse.success(true);
        }
        catch (Exception e) {
            return RestResponse.success(false).message(e.getMessage());
        }
    }
}

