/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.SavePoint;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.SavePointService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"flink/savepoint"})
public class SavePointController {
    private static final Logger log = LoggerFactory.getLogger(SavePointController.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private SavePointService savePointService;

    @PostMapping(value={"latest"})
    public RestResponse latest(Long appId) {
        SavePoint savePoint = this.savePointService.getLatest(appId);
        return RestResponse.success(savePoint);
    }

    @PostMapping(value={"history"})
    public RestResponse history(SavePoint savePoint, RestRequest request) {
        IPage<SavePoint> page = this.savePointService.page(savePoint, request);
        return RestResponse.success(page);
    }

    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"savepoint:delete"})
    public RestResponse delete(Long id) throws InternalException {
        SavePoint savePoint = (SavePoint)this.savePointService.getById(id);
        Application application = (Application)this.applicationService.getById(savePoint.getAppId());
        Boolean deleted = this.savePointService.delete(id, application);
        return RestResponse.success(deleted);
    }
}

