/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.UserScanQueryMatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class NormalUserScanQueryMatcher
extends UserScanQueryMatcher {
    private final DeleteTracker deletes;
    private final boolean get;
    protected final boolean seePastDeleteMarkers;

    protected NormalUserScanQueryMatcher(Scan scan, ScanInfo scanInfo, ColumnTracker columns, boolean hasNullColumn, DeleteTracker deletes, long oldestUnexpiredTS, long now) {
        super(scan, scanInfo, columns, hasNullColumn, oldestUnexpiredTS, now);
        this.deletes = deletes;
        this.get = scan.isGetScan();
        this.seePastDeleteMarkers = scanInfo.getKeepDeletedCells() != KeepDeletedCells.FALSE;
    }

    @Override
    public void beforeShipped() throws IOException {
        super.beforeShipped();
        this.deletes.beforeShipped();
    }

    @Override
    public ScanQueryMatcher.MatchCode match(Cell cell) throws IOException {
        if (this.filter != null && this.filter.filterAllRemaining()) {
            return ScanQueryMatcher.MatchCode.DONE_SCAN;
        }
        ScanQueryMatcher.MatchCode returnCode = this.preCheck(cell);
        if (returnCode != null) {
            return returnCode;
        }
        long timestamp = cell.getTimestamp();
        byte typeByte = cell.getTypeByte();
        if (PrivateCellUtil.isDelete((byte)typeByte)) {
            boolean includeDeleteMarker;
            boolean bl = includeDeleteMarker = this.seePastDeleteMarkers ? this.tr.withinTimeRange(timestamp) : this.tr.withinOrAfterTimeRange(timestamp);
            if (includeDeleteMarker) {
                this.deletes.add(cell);
            }
            return ScanQueryMatcher.MatchCode.SKIP;
        }
        returnCode = this.checkDeleted(this.deletes, cell);
        if (returnCode != null) {
            return returnCode;
        }
        return this.matchColumn(cell, timestamp, typeByte);
    }

    @Override
    protected void reset() {
        this.deletes.reset();
    }

    @Override
    protected boolean isGet() {
        return this.get;
    }

    public static NormalUserScanQueryMatcher create(Scan scan, ScanInfo scanInfo, ColumnTracker columns, DeleteTracker deletes, boolean hasNullColumn, long oldestUnexpiredTS, long now) throws IOException {
        if (scan.isReversed()) {
            if (scan.includeStopRow()) {
                return new NormalUserScanQueryMatcher(scan, scanInfo, columns, hasNullColumn, deletes, oldestUnexpiredTS, now){

                    @Override
                    protected boolean moreRowsMayExistsAfter(int cmpToStopRow) {
                        return cmpToStopRow >= 0;
                    }
                };
            }
            return new NormalUserScanQueryMatcher(scan, scanInfo, columns, hasNullColumn, deletes, oldestUnexpiredTS, now){

                @Override
                protected boolean moreRowsMayExistsAfter(int cmpToStopRow) {
                    return cmpToStopRow > 0;
                }
            };
        }
        if (scan.includeStopRow()) {
            return new NormalUserScanQueryMatcher(scan, scanInfo, columns, hasNullColumn, deletes, oldestUnexpiredTS, now){

                @Override
                protected boolean moreRowsMayExistsAfter(int cmpToStopRow) {
                    return cmpToStopRow <= 0;
                }
            };
        }
        return new NormalUserScanQueryMatcher(scan, scanInfo, columns, hasNullColumn, deletes, oldestUnexpiredTS, now){

            @Override
            protected boolean moreRowsMayExistsAfter(int cmpToStopRow) {
                return cmpToStopRow < 0;
            }
        };
    }
}

