/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.Collection;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class SameNeighborTraverser
extends HugeTraverser {
    public SameNeighborTraverser(HugeGraph graph) {
        super(graph);
    }

    public Set<Id> sameNeighbors(Id vertex, Id other, Directions direction, String label, long degree, int limit) {
        E.checkNotNull((Object)vertex, (String)"vertex id");
        E.checkNotNull((Object)other, (String)"the other vertex id");
        this.checkVertexExist(vertex, "vertex");
        this.checkVertexExist(other, "other vertex");
        E.checkNotNull((Object)direction, (String)"direction");
        SameNeighborTraverser.checkDegree(degree);
        SameNeighborTraverser.checkLimit(limit);
        Id labelId = this.getEdgeLabelId(label);
        Set sourceNeighbors = IteratorUtils.set(this.adjacentVertices(vertex, direction, labelId, degree));
        Set targetNeighbors = IteratorUtils.set(this.adjacentVertices(other, direction, labelId, degree));
        Set sameNeighbors = (Set)CollectionUtil.intersect((Collection)sourceNeighbors, (Collection)targetNeighbors);
        if ((long)limit != -1L) {
            int end = Math.min(sameNeighbors.size(), limit);
            sameNeighbors = CollectionUtil.subSet((Set)sameNeighbors, (int)0, (int)end);
        }
        return sameNeighbors;
    }
}

