/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.Iterator;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.records.PathsRecords;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class PathsTraverser
extends HugeTraverser {
    public PathsTraverser(HugeGraph graph) {
        super(graph);
    }

    @PerfUtil.Watched
    public HugeTraverser.PathSet paths(Id sourceV, Directions sourceDir, Id targetV, Directions targetDir, String label, int depth, long degree, long capacity, long limit) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        E.checkNotNull((Object)targetV, (String)"target vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        this.checkVertexExist(targetV, "target vertex");
        E.checkNotNull((Object)sourceDir, (String)"source direction");
        E.checkNotNull((Object)targetDir, (String)"target direction");
        E.checkArgument((sourceDir == targetDir || sourceDir == targetDir.opposite() ? 1 : 0) != 0, (String)"Source direction must equal to target direction or opposite to target direction", (Object[])new Object[0]);
        E.checkArgument((depth > 0 && depth <= 5000 ? 1 : 0) != 0, (String)"The depth must be in (0, %s], but got: %s", (Object[])new Object[]{5000, depth});
        PathsTraverser.checkDegree(degree);
        PathsTraverser.checkCapacity(capacity);
        PathsTraverser.checkLimit(limit);
        if (sourceV.equals(targetV)) {
            return HugeTraverser.PathSet.EMPTY;
        }
        Id labelId = this.getEdgeLabelId(label);
        Traverser traverser = new Traverser(sourceV, targetV, labelId, degree, capacity, limit);
        while (--depth >= 0 && !traverser.reachLimit()) {
            traverser.forward(targetV, sourceDir);
            if (--depth < 0 || traverser.reachLimit()) break;
            traverser.backward(sourceV, targetDir);
        }
        return traverser.paths();
    }

    private class Traverser {
        private final PathsRecords record;
        private final Id label;
        private final long degree;
        private final long capacity;
        private final long limit;
        private final HugeTraverser.PathSet paths;

        public Traverser(Id sourceV, Id targetV, Id label, long degree, long capacity, long limit) {
            this.record = new PathsRecords(false, sourceV, targetV);
            this.label = label;
            this.degree = degree;
            this.capacity = capacity;
            this.limit = limit;
            this.paths = new HugeTraverser.PathSet();
        }

        @PerfUtil.Watched
        public void forward(Id targetV, Directions direction) {
            this.record.startOneLayer(true);
            while (this.record.hasNextKey()) {
                Id vid = this.record.nextKey();
                if (vid.equals(targetV)) continue;
                Iterator<Edge> edges = PathsTraverser.this.edgesOfVertex(vid, direction, this.label, this.degree);
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    HugeTraverser.PathSet results = this.record.findPath(target, null, true, false);
                    for (HugeTraverser.Path path : results) {
                        this.paths.add(path);
                        if (!this.reachLimit()) continue;
                        return;
                    }
                }
            }
            this.record.finishOneLayer();
        }

        @PerfUtil.Watched
        public void backward(Id sourceV, Directions direction) {
            this.record.startOneLayer(false);
            while (this.record.hasNextKey()) {
                Id vid = this.record.nextKey();
                if (vid.equals(sourceV)) continue;
                Iterator<Edge> edges = PathsTraverser.this.edgesOfVertex(vid, direction, this.label, this.degree);
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    HugeTraverser.PathSet results = this.record.findPath(target, null, true, false);
                    for (HugeTraverser.Path path : results) {
                        this.paths.add(path);
                        if (!this.reachLimit()) continue;
                        return;
                    }
                }
            }
            this.record.finishOneLayer();
        }

        public HugeTraverser.PathSet paths() {
            return this.paths;
        }

        private boolean reachLimit() {
            HugeTraverser.checkCapacity(this.capacity, this.record.accessed(), "paths");
            return this.limit != -1L && (long)this.paths.size() >= this.limit;
        }
    }
}

