/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.traversal.algorithm.OltpTraverser;
import org.apache.hugegraph.traversal.algorithm.records.KneighborRecords;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class KneighborTraverser
extends OltpTraverser {
    public KneighborTraverser(HugeGraph graph) {
        super(graph);
    }

    public Set<Id> kneighbor(Id sourceV, Directions dir, String label, int depth, long degree, long limit) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        KneighborTraverser.checkPositive(depth, "k-neighbor max_depth");
        KneighborTraverser.checkDegree(degree);
        KneighborTraverser.checkLimit(limit);
        Id labelId = this.getEdgeLabelId(label);
        Set<Id> latest = KneighborTraverser.newSet();
        Set<Id> all = KneighborTraverser.newSet();
        latest.add(sourceV);
        while (depth-- > 0) {
            long remaining = limit == -1L ? -1L : limit - (long)all.size();
            latest = this.adjacentVertices(sourceV, latest, dir, labelId, all, degree, remaining);
            all.addAll(latest);
            if (!this.reachLimit(limit, all.size())) continue;
            break;
        }
        return all;
    }

    public KneighborRecords customizedKneighbor(Id source, EdgeStep step, int maxDepth, long limit) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        KneighborTraverser.checkPositive(maxDepth, "k-neighbor max_depth");
        KneighborTraverser.checkLimit(limit);
        boolean concurrent = maxDepth >= this.concurrentDepth();
        KneighborRecords records = new KneighborRecords(concurrent, source, true);
        Consumer<Id> consumer = v -> {
            if (this.reachLimit(limit, records.size())) {
                return;
            }
            Iterator<Edge> edges = this.edgesOfVertex((Id)v, step);
            while (!this.reachLimit(limit, records.size()) && edges.hasNext()) {
                Id target = ((HugeEdge)edges.next()).id().otherVertexId();
                records.addPath((Id)v, target);
            }
        };
        while (maxDepth-- > 0) {
            records.startOneLayer(true);
            this.traverseIds(records.keys(), consumer, concurrent);
            records.finishOneLayer();
        }
        return records;
    }

    private boolean reachLimit(long limit, int size) {
        return limit != -1L && (long)size >= limit;
    }
}

