/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.raft;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.store.raft.RaftAddPeerJob;
import org.apache.hugegraph.backend.store.raft.RaftGroupManager;
import org.apache.hugegraph.backend.store.raft.RaftRemovePeerJob;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.job.Job;
import org.apache.hugegraph.job.JobBuilder;
import org.apache.hugegraph.util.DateUtil;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/raft")
@Singleton
@Tag(name="RaftAPI")
public class RaftAPI
extends API {
    private static final Logger LOG = Log.logger(RaftAPI.class);

    @GET
    @Timed
    @Path(value="list_peers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public Map<String, List<String>> listPeers(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="group") @DefaultValue(value="default") String group) {
        LOG.debug("Graph [{}] prepare to get leader", (Object)graph);
        HugeGraph g = RaftAPI.graph(manager, graph);
        RaftGroupManager raftManager = RaftAPI.raftGroupManager(g, group, "list_peers");
        List peers = raftManager.listPeers();
        return ImmutableMap.of((Object)raftManager.group(), (Object)peers);
    }

    @GET
    @Timed
    @Path(value="get_leader")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public Map<String, String> getLeader(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="group") @DefaultValue(value="default") String group) {
        LOG.debug("Graph [{}] prepare to get leader", (Object)graph);
        HugeGraph g = RaftAPI.graph(manager, graph);
        RaftGroupManager raftManager = RaftAPI.raftGroupManager(g, group, "get_leader");
        String leaderId = raftManager.getLeader();
        return ImmutableMap.of((Object)raftManager.group(), (Object)leaderId);
    }

    @POST
    @Timed
    @StatusFilter.Status(value=200)
    @Path(value="transfer_leader")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public Map<String, String> transferLeader(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="group") @DefaultValue(value="default") String group, @QueryParam(value="endpoint") String endpoint) {
        LOG.debug("Graph [{}] prepare to transfer leader to: {}", (Object)graph, (Object)endpoint);
        HugeGraph g = RaftAPI.graph(manager, graph);
        RaftGroupManager raftManager = RaftAPI.raftGroupManager(g, group, "transfer_leader");
        String leaderId = raftManager.transferLeaderTo(endpoint);
        return ImmutableMap.of((Object)raftManager.group(), (Object)leaderId);
    }

    @POST
    @Timed
    @StatusFilter.Status(value=200)
    @Path(value="set_leader")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public Map<String, String> setLeader(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="group") @DefaultValue(value="default") String group, @QueryParam(value="endpoint") String endpoint) {
        LOG.debug("Graph [{}] prepare to set leader to: {}", (Object)graph, (Object)endpoint);
        HugeGraph g = RaftAPI.graph(manager, graph);
        RaftGroupManager raftManager = RaftAPI.raftGroupManager(g, group, "set_leader");
        String leaderId = raftManager.setLeader(endpoint);
        return ImmutableMap.of((Object)raftManager.group(), (Object)leaderId);
    }

    @POST
    @Timed
    @StatusFilter.Status(value=200)
    @Path(value="add_peer")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public Map<String, Id> addPeer(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="group") @DefaultValue(value="default") String group, @QueryParam(value="endpoint") String endpoint) {
        LOG.debug("Graph [{}] prepare to add peer: {}", (Object)graph, (Object)endpoint);
        HugeGraph g = RaftAPI.graph(manager, graph);
        RaftGroupManager raftManager = RaftAPI.raftGroupManager(g, group, "add_peer");
        JobBuilder builder = JobBuilder.of((HugeGraph)g);
        String name = String.format("raft-group-[%s]-add-peer-[%s]-at-[%s]", raftManager.group(), endpoint, DateUtil.now());
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("endpoint", endpoint);
        builder.name(name).input(JsonUtil.toJson(inputs)).job((Job)new RaftAddPeerJob());
        return ImmutableMap.of((Object)"task_id", (Object)builder.schedule().id());
    }

    @POST
    @Timed
    @StatusFilter.Status(value=200)
    @Path(value="remove_peer")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    public Map<String, Id> removePeer(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="group") @DefaultValue(value="default") String group, @QueryParam(value="endpoint") String endpoint) {
        LOG.debug("Graph [{}] prepare to remove peer: {}", (Object)graph, (Object)endpoint);
        HugeGraph g = RaftAPI.graph(manager, graph);
        RaftGroupManager raftManager = RaftAPI.raftGroupManager(g, group, "remove_peer");
        JobBuilder builder = JobBuilder.of((HugeGraph)g);
        String name = String.format("raft-group-[%s]-remove-peer-[%s]-at-[%s]", raftManager.group(), endpoint, DateUtil.now());
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("endpoint", endpoint);
        builder.name(name).input(JsonUtil.toJson(inputs)).job((Job)new RaftRemovePeerJob());
        return ImmutableMap.of((Object)"task_id", (Object)builder.schedule().id());
    }

    private static RaftGroupManager raftGroupManager(HugeGraph graph, String group, String operation) {
        RaftGroupManager raftManager = graph.raftGroupManager();
        if (raftManager == null) {
            throw new HugeException("Allowed %s operation only when working on raft mode", new Object[]{operation});
        }
        return raftManager;
    }
}

