/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;

public final class ExceptionUtils {
    public static SofaRpcRuntimeException buildRuntime(String configKey, String configValue) {
        String msg = "The value of config " + configKey + " [" + configValue + "] is illegal, please check it";
        return new SofaRpcRuntimeException(msg);
    }

    public static SofaRpcRuntimeException buildRuntime(String configKey, String configValue, String message) {
        String msg = "The value of config " + configKey + " [" + configValue + "] is illegal, " + message;
        return new SofaRpcRuntimeException(msg);
    }

    public static boolean isServerException(SofaRpcException exception) {
        int errorType = exception.getErrorType();
        return errorType >= 100 && errorType < 200;
    }

    public static boolean isClientException(SofaRpcException exception) {
        int errorType = exception.getErrorType();
        return errorType >= 200 && errorType < 300;
    }

    public static String toString(Throwable e) {
        StackTraceElement[] traces = e.getStackTrace();
        StringBuilder sb = new StringBuilder(1024);
        sb.append(e.toString()).append("\n");
        if (traces != null) {
            for (StackTraceElement trace : traces) {
                sb.append("\tat ").append(trace).append("\n");
            }
        }
        return sb.toString();
    }

    public static String toShortString(Throwable e, int stackLevel) {
        StackTraceElement[] traces = e.getStackTrace();
        StringBuilder sb = new StringBuilder(1024);
        sb.append(e.toString()).append("\t");
        if (traces != null) {
            for (int i = 0; i < traces.length && i < stackLevel; ++i) {
                sb.append("\tat ").append(traces[i]).append("\t");
            }
        }
        return sb.toString();
    }
}

