/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.iterator.TapIterator;
import org.eclipse.collections.impl.utility.Iterate;

public class TapIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;
    private final Procedure<? super T> procedure;

    public TapIterable(Iterable<T> newAdapted, Procedure<? super T> procedure) {
        this.adapted = newAdapted;
        this.procedure = procedure;
    }

    public void each(Procedure<? super T> procedure) {
        Iterate.forEach(this.adapted, (Procedure & Serializable)each -> {
            this.procedure.value(each);
            procedure.value(each);
        });
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        Iterate.forEachWithIndex(this.adapted, (ObjectIntProcedure & Serializable)(each, index) -> {
            this.procedure.value(each);
            objectIntProcedure.value(each, index);
        });
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, (Procedure2 & Serializable)(each, aParameter) -> {
            this.procedure.value(each);
            procedure.value(each, aParameter);
        }, parameter);
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return Iterate.anySatisfy(this.adapted, (Predicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return Iterate.allSatisfy(this.adapted, (Predicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return Iterate.noneSatisfy(this.adapted, (Predicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public T getFirst() {
        return Iterate.detect(this.adapted, (Predicate & Serializable)each -> {
            this.procedure.value(each);
            return true;
        });
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return Iterate.detect(this.adapted, (Predicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        return Iterate.detectOptional(this.adapted, (Predicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    public Iterator<T> iterator() {
        return new TapIterator<T>(this.adapted, this.procedure);
    }
}

