/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.lang.reflect.Field;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.utils.NativeLibrary;

public class SyncUtil {
    public static boolean SKIP_SYNC = Boolean.getBoolean("cassandra.skip_sync");
    private static final Field mbbFDField;
    private static final Field fdClosedField;
    private static final Field fdUseCountField;

    public static MappedByteBuffer force(MappedByteBuffer buf) {
        Preconditions.checkNotNull((Object)buf);
        if (SKIP_SYNC) {
            Object fd = null;
            try {
                if (mbbFDField != null) {
                    fd = mbbFDField.get(buf);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (mbbFDField != null && fd == null) {
                throw new UnsupportedOperationException();
            }
            return buf;
        }
        return buf.force();
    }

    public static void sync(FileDescriptor fd) throws SyncFailedException {
        Preconditions.checkNotNull((Object)fd);
        if (SKIP_SYNC) {
            boolean closed = false;
            try {
                if (fdClosedField != null) {
                    closed = fdClosedField.getBoolean(fd);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            int useCount = 1;
            try {
                if (fdUseCountField != null) {
                    useCount = ((AtomicInteger)fdUseCountField.get(fd)).get();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (closed || !fd.valid() || useCount < 0) {
                throw new SyncFailedException("Closed " + closed + " valid " + fd.valid() + " useCount " + useCount);
            }
        } else {
            fd.sync();
        }
    }

    public static void force(FileChannel fc, boolean metaData) throws IOException {
        Preconditions.checkNotNull((Object)fc);
        if (SKIP_SYNC) {
            if (!fc.isOpen()) {
                throw new ClosedChannelException();
            }
        } else {
            fc.force(metaData);
        }
    }

    public static void sync(RandomAccessFile ras) throws IOException {
        Preconditions.checkNotNull((Object)ras);
        SyncUtil.sync(ras.getFD());
    }

    public static void sync(FileOutputStream fos) throws IOException {
        Preconditions.checkNotNull((Object)fos);
        SyncUtil.sync(fos.getFD());
    }

    public static void trySync(int fd) {
        if (SKIP_SYNC) {
            return;
        }
        NativeLibrary.trySync(fd);
    }

    public static void trySyncDir(File dir) {
        if (SKIP_SYNC) {
            return;
        }
        int directoryFD = NativeLibrary.tryOpenDirectory(dir.getPath());
        try {
            SyncUtil.trySync(directoryFD);
        }
        finally {
            NativeLibrary.tryCloseFD(directoryFD);
        }
    }

    static {
        Field mbbFDFieldTemp = null;
        try {
            mbbFDFieldTemp = MappedByteBuffer.class.getDeclaredField("fd");
            mbbFDFieldTemp.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        mbbFDField = mbbFDFieldTemp;
        Field fdClosedFieldTemp = null;
        try {
            fdClosedFieldTemp = FileDescriptor.class.getDeclaredField("closed");
            fdClosedFieldTemp.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        fdClosedField = fdClosedFieldTemp;
        Field fdUseCountTemp = null;
        try {
            fdUseCountTemp = FileDescriptor.class.getDeclaredField("useCount");
            fdUseCountTemp.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        fdUseCountField = fdUseCountTemp;
    }
}

