/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.db.AbstractClusteringPrefix;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.MemoryUtil;
import org.apache.cassandra.utils.memory.NativeAllocator;

public class NativeClustering
extends AbstractClusteringPrefix
implements Clustering {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new NativeClustering());
    private final long peer;

    private NativeClustering() {
        this.peer = 0L;
    }

    public NativeClustering(NativeAllocator allocator, OpOrder.Group writeOp, Clustering clustering) {
        int count = clustering.size();
        int metadataSize = count * 2 + 4;
        int dataSize = clustering.dataSize();
        int bitmapSize = count + 7 >>> 3;
        assert (count < 65536);
        assert (dataSize < 65536);
        this.peer = allocator.allocate(metadataSize + dataSize + bitmapSize, writeOp);
        long bitmapStart = this.peer + (long)metadataSize;
        MemoryUtil.setShort(this.peer, (short)count);
        MemoryUtil.setShort(this.peer + (long)(metadataSize - 2), (short)dataSize);
        MemoryUtil.setByte(bitmapStart, bitmapSize, (byte)0);
        long dataStart = this.peer + (long)metadataSize + (long)bitmapSize;
        int dataOffset = 0;
        for (int i = 0; i < count; ++i) {
            MemoryUtil.setShort(this.peer + 2L + (long)(i * 2), (short)dataOffset);
            ByteBuffer value = clustering.get(i);
            if (value == null) {
                long boffset = bitmapStart + (long)(i >>> 3);
                int b = MemoryUtil.getByte(boffset);
                MemoryUtil.setByte(boffset, (byte)(b |= 1 << (i & 7)));
                continue;
            }
            assert (value.order() == ByteOrder.BIG_ENDIAN);
            int size = value.remaining();
            MemoryUtil.setBytes(dataStart + (long)dataOffset, value);
            dataOffset += size;
        }
    }

    @Override
    public ClusteringPrefix.Kind kind() {
        return ClusteringPrefix.Kind.CLUSTERING;
    }

    @Override
    public int size() {
        return MemoryUtil.getShort(this.peer);
    }

    @Override
    public ByteBuffer get(int i) {
        int size = this.size();
        if (i >= size) {
            throw new IndexOutOfBoundsException();
        }
        int metadataSize = size * 2 + 4;
        int bitmapSize = size + 7 >>> 3;
        long bitmapStart = this.peer + (long)metadataSize;
        byte b = MemoryUtil.getByte(bitmapStart + (long)(i >>> 3));
        if ((b & 1 << (i & 7)) != 0) {
            return null;
        }
        int startOffset = MemoryUtil.getShort(this.peer + 2L + (long)(i * 2));
        int endOffset = MemoryUtil.getShort(this.peer + 4L + (long)(i * 2));
        return MemoryUtil.getByteBuffer(bitmapStart + (long)bitmapSize + (long)startOffset, endOffset - startOffset, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public ByteBuffer[] getRawValues() {
        ByteBuffer[] values = new ByteBuffer[this.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.get(i);
        }
        return values;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE;
    }

    @Override
    public ClusteringPrefix minimize() {
        return this;
    }
}

