/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.time.LocalDate;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class LocalDateSerializer
extends SimpleTypeSerializer<LocalDate> {
    public LocalDateSerializer() {
        super(DataType.LOCALDATE);
    }

    @Override
    protected LocalDate readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        return LocalDate.of(buffer.readInt(), buffer.readByte(), (int)buffer.readByte());
    }

    @Override
    protected void writeValue(LocalDate value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeInt(value.getYear()).writeByte(value.getMonthValue()).writeByte(value.getDayOfMonth());
    }
}

