/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.isolated;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.internal.ClusterMetricsSnapshot;
import org.apache.ignite.internal.managers.discovery.IgniteClusterNode;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;

public class IsolatedNode
implements IgniteClusterNode {
    private final UUID id;
    private final IgniteProductVersion ver;
    private Object consistentId;
    private Map<String, Object> attrs;
    private volatile ClusterMetrics metrics = new ClusterMetricsSnapshot();
    private volatile Map<Integer, CacheMetrics> cacheMetrics = Collections.emptyMap();

    public IsolatedNode(UUID id, Map<String, Object> attrs, IgniteProductVersion ver) {
        this.id = id;
        this.attrs = U.sealMap(attrs);
        this.ver = ver;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Object consistentId() {
        return this.consistentId;
    }

    @Override
    public <T> T attribute(String name) {
        return (T)this.attrs.get(name);
    }

    @Override
    public ClusterMetrics metrics() {
        return this.metrics;
    }

    @Override
    public Map<String, Object> attributes() {
        return this.attrs;
    }

    @Override
    public Collection<String> addresses() {
        return Collections.singleton("127.0.0.1");
    }

    @Override
    public Collection<String> hostNames() {
        return Collections.singleton("localhost");
    }

    @Override
    public long order() {
        return 1L;
    }

    @Override
    public IgniteProductVersion version() {
        return this.ver;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void setConsistentId(Serializable consistentId) {
        this.consistentId = consistentId;
        HashMap<String, Object> map = new HashMap<String, Object>(this.attrs);
        map.put("org.apache.ignite.consistent.id", consistentId);
        this.attrs = Collections.unmodifiableMap(map);
    }

    @Override
    public void setMetrics(ClusterMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public Map<Integer, CacheMetrics> cacheMetrics() {
        return this.cacheMetrics;
    }

    @Override
    public void setCacheMetrics(Map<Integer, CacheMetrics> cacheMetrics) {
        this.cacheMetrics = cacheMetrics != null ? cacheMetrics : Collections.emptyMap();
    }
}

