/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal.shmem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.tcp.internal.ClusterStateProvider;
import org.apache.ignite.spi.communication.tcp.internal.CommunicationTcpUtils;
import org.apache.ignite.spi.communication.tcp.messages.NodeIdMessage;

public class SHMemHandshakeClosure
extends IgniteInClosure2X<InputStream, OutputStream> {
    private static final long serialVersionUID = 0L;
    private final IgniteLogger log;
    private final UUID rmtNodeId;
    private final ClusterStateProvider stateProvider;
    private final Supplier<ClusterNode> locNodeSupplier;

    public SHMemHandshakeClosure(IgniteLogger log, UUID rmtNodeId, ClusterStateProvider stateProvider, Supplier<ClusterNode> locNodeSupplier) {
        this.log = log;
        this.rmtNodeId = rmtNodeId;
        this.stateProvider = stateProvider;
        this.locNodeSupplier = locNodeSupplier;
    }

    @Override
    public void applyx(InputStream in, OutputStream out) throws IgniteCheckedException {
        try {
            int cnt;
            byte[] b = new byte[18];
            for (int n = 0; n < 18; n += cnt) {
                cnt = in.read(b, n, 18 - n);
                if (cnt >= 0) continue;
                throw new IgniteCheckedException("Failed to get remote node ID (end of stream reached)");
            }
            UUID id = U.bytesToUuid(b, 2);
            if (!this.rmtNodeId.equals(id)) {
                throw new IgniteCheckedException("Remote node ID is not as expected [expected=" + this.rmtNodeId + ", rcvd=" + id + ']');
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received remote node ID: " + id);
            }
        }
        catch (SocketTimeoutException e) {
            throw new IgniteCheckedException("Failed to perform handshake due to timeout (consider increasing 'connectionTimeout' configuration property).", e);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to perform handshake.", e);
        }
        try {
            ClusterNode locNode = this.locNodeSupplier.get();
            if (locNode == null) {
                throw new IgniteSpiException("Local node has not been started or fully initialized [isStopping=" + this.stateProvider.isStopping() + ']');
            }
            UUID id = locNode.id();
            NodeIdMessage msg = new NodeIdMessage(id);
            out.write(U.IGNITE_HEADER);
            CommunicationTcpUtils.writeMessageType(out, (short)-1);
            out.write(msg.nodeIdBytes());
            out.flush();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sent local node ID [locNodeId=" + id + ", rmtNodeId=" + this.rmtNodeId + ']');
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to perform handshake.", e);
        }
    }
}

