/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.GridStripedLock;
import org.apache.ignite.internal.util.lang.IgniteThrowableRunner;

public class InitializationProtector {
    private static final int DEFAULT_CONCURRENCY_LEVEL = Runtime.getRuntime().availableProcessors();
    private GridStripedLock stripedLock = new GridStripedLock(DEFAULT_CONCURRENCY_LEVEL);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T protect(Object protectedKey, Supplier<T> initializedVal, IgniteThrowableRunner initializationCode) throws IgniteCheckedException {
        T value = initializedVal.get();
        if (value != null) {
            return value;
        }
        Lock lock = this.stripedLock.getLock(protectedKey.hashCode() % this.stripedLock.concurrencyLevel());
        lock.lock();
        try {
            value = initializedVal.get();
            if (value != null) {
                T t = value;
                return t;
            }
            initializationCode.run();
            T t = initializedVal.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public void protect(Object protectedKey, IgniteThrowableRunner initializationCode) throws IgniteCheckedException {
        this.protect(protectedKey, () -> null, initializationCode);
    }
}

