/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.configuration.distributed;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.PropertyUpdateClosure;
import org.apache.ignite.internal.processors.configuration.distributed.SimpleDistributedProperty;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteClosure;
import org.jetbrains.annotations.NotNull;

public class DistributedEnumProperty<T extends Enum>
implements DistributedChangeableProperty<T> {
    private final SimpleDistributedProperty<Integer> internal;
    private final IgniteClosure<Integer, T> fromOrdinalFunc;
    private final IgniteClosure<T, Integer> toOrdinalFunc;
    private final Map<String, T> values;

    public DistributedEnumProperty(String name, IgniteClosure<Integer, T> fromOrdinalFunc, IgniteClosure<T, Integer> toOrdinalFunc, Class<T> enumCls) {
        this.internal = new SimpleDistributedProperty(name, null);
        this.fromOrdinalFunc = fromOrdinalFunc;
        this.toOrdinalFunc = toOrdinalFunc;
        this.values = Arrays.stream(enumCls.getEnumConstants()).collect(Collectors.toMap(e -> e.name().toLowerCase(), e -> e));
    }

    @Override
    public void onAttached() {
        this.internal.onAttached();
    }

    @Override
    public void onReadyForUpdate(@NotNull PropertyUpdateClosure updater) {
        this.internal.onReadyForUpdate(updater);
    }

    @Override
    public void localUpdate(Serializable newVal) {
        if (newVal == null) {
            this.internal.localUpdate(null);
        } else if (newVal instanceof Enum) {
            this.internal.localUpdate(this.ordinalOrNull((Enum)((Object)newVal)));
        } else if (newVal instanceof Integer) {
            this.internal.localUpdate(newVal);
        }
    }

    @Override
    public boolean propagate(T newVal) throws IgniteCheckedException {
        return this.internal.propagate(this.ordinalOrNull(newVal));
    }

    @Override
    public GridFutureAdapter<?> propagateAsync(T newVal) throws IgniteCheckedException {
        return this.internal.propagateAsync(this.ordinalOrNull(newVal));
    }

    @Override
    public GridFutureAdapter<?> propagateAsync(T expectedVal, T newVal) throws IgniteCheckedException {
        return this.internal.propagateAsync(this.ordinalOrNull(expectedVal), this.ordinalOrNull(newVal));
    }

    @Override
    public T get() {
        return this.fromOrdinalOrNull(this.internal.get());
    }

    @Override
    public T getOrDefault(T dfltVal) {
        T val = this.get();
        return val == null ? dfltVal : val;
    }

    @Override
    public String getName() {
        return this.internal.getName();
    }

    @Override
    public void addListener(final DistributePropertyListener<? super T> listener) {
        this.internal.addListener(new DistributePropertyListener<Integer>(){

            @Override
            public void onUpdate(String name, Integer oldVal, Integer newVal) {
                listener.onUpdate(name, DistributedEnumProperty.this.fromOrdinalOrNull(oldVal), DistributedEnumProperty.this.fromOrdinalOrNull(newVal));
            }
        });
    }

    private Integer ordinalOrNull(T val) {
        return val == null ? null : this.toOrdinalFunc.apply(val);
    }

    private T fromOrdinalOrNull(Integer ord) {
        return (T)(ord != null && ord >= 0 ? (Enum)this.fromOrdinalFunc.apply(ord) : null);
    }

    @Override
    public T parse(String str) {
        Enum t = (Enum)this.values.get(str.toLowerCase());
        if (t == null) {
            throw new IllegalArgumentException("Unknown value for enum property [value=" + str + ", name=" + this.internal.getName());
        }
        return (T)t;
    }

    public String toString() {
        return S.toString(DistributedEnumProperty.class, this);
    }
}

