/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentObservable;
import org.jetbrains.annotations.Nullable;

class SegmentReservationStorage
extends SegmentObservable {
    private final NavigableMap<Long, Integer> reserved = new TreeMap<Long, Integer>();
    private long minReserveIdx = -1L;

    SegmentReservationStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reserve(long absIdx) {
        boolean res = false;
        Long minReservedIdx = null;
        SegmentReservationStorage segmentReservationStorage = this;
        synchronized (segmentReservationStorage) {
            if (absIdx > this.minReserveIdx) {
                minReservedIdx = this.trackingMinReservedIdx(reserved -> reserved.merge(absIdx, 1, Integer::sum));
                res = true;
            }
        }
        if (minReservedIdx != null) {
            this.notifyObservers(minReservedIdx);
        }
        return res;
    }

    synchronized boolean reserved(long absIdx) {
        return this.reserved.floorKey(absIdx) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(long absIdx) {
        Long minReservedIdx;
        SegmentReservationStorage segmentReservationStorage = this;
        synchronized (segmentReservationStorage) {
            minReservedIdx = this.trackingMinReservedIdx(reserved -> {
                Integer cur = (Integer)reserved.get(absIdx);
                assert (cur != null && cur >= 1) : "cur=" + cur + ", absIdx=" + absIdx;
                if (cur == 1) {
                    reserved.remove(absIdx);
                } else {
                    reserved.put(absIdx, cur - 1);
                }
            });
        }
        if (minReservedIdx != null) {
            this.notifyObservers(minReservedIdx);
        }
    }

    synchronized boolean minReserveIndex(long absIdx) {
        if (this.reserved(absIdx)) {
            return false;
        }
        this.minReserveIdx = Math.max(this.minReserveIdx, absIdx);
        return true;
    }

    @Nullable
    private synchronized Long trackingMinReservedIdx(Consumer<NavigableMap<Long, Integer>> updateFun) {
        Long newMin;
        Map.Entry<Long, Integer> oldMinE = this.reserved.firstEntry();
        updateFun.accept(this.reserved);
        Map.Entry<Long, Integer> newMinE = this.reserved.firstEntry();
        Long oldMin = oldMinE == null ? null : oldMinE.getKey();
        Long l = newMin = newMinE == null ? null : newMinE.getKey();
        return Objects.equals(oldMin, newMin) ? null : Long.valueOf(newMin == null ? -1L : newMin);
    }
}

