/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;

public class PageMetaIOV2
extends PageMetaIO {
    private static final int ENCRYPT_PAGE_IDX_OFF = 104;
    private static final int ENCRYPT_PAGE_MAX_OFF = 108;

    public PageMetaIOV2(int ver) {
        super(ver);
    }

    public int getEncryptedPageIndex(long pageAddr) {
        return PageUtils.getInt(pageAddr, 104);
    }

    public boolean setEncryptedPageIndex(long pageAddr, int pageIdx) {
        if (this.getEncryptedPageIndex(pageAddr) == pageIdx) {
            return false;
        }
        PageUtils.putLong(pageAddr, 104, pageIdx);
        return true;
    }

    public int getEncryptedPageCount(long pageAddr) {
        return PageUtils.getInt(pageAddr, 108);
    }

    public boolean setEncryptedPageCount(long pageAddr, int pagesCnt) {
        if (this.getEncryptedPageCount(pageAddr) == pagesCnt) {
            return false;
        }
        PageUtils.putInt(pageAddr, 108, pagesCnt);
        return true;
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        super.initNewPage(pageAddr, pageId, pageSize);
        this.setEncryptedPageCount(pageAddr, 0);
        this.setEncryptedPageIndex(pageAddr, 0);
    }

    public void upgradePage(long pageAddr) {
        assert (PageIO.getType(pageAddr) == this.getType());
        PageIO.setVersion(pageAddr, this.getVersion());
        this.setEncryptedPageIndex(pageAddr, 0);
        this.setEncryptedPageCount(pageAddr, 0);
    }
}

