/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class GridDhtPartitionFullMap
extends HashMap<UUID, GridDhtPartitionMap>
implements Comparable<GridDhtPartitionFullMap>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private UUID nodeId;
    private long nodeOrder;
    private long updateSeq;

    public GridDhtPartitionFullMap(UUID nodeId, long nodeOrder, long updateSeq) {
        assert (nodeId != null);
        assert (nodeOrder > 0L);
        assert (updateSeq > 0L);
        this.nodeId = nodeId;
        this.nodeOrder = nodeOrder;
        this.updateSeq = updateSeq;
    }

    public GridDhtPartitionFullMap(UUID nodeId, long nodeOrder, long updateSeq, Map<UUID, GridDhtPartitionMap> m, boolean onlyActive) {
        assert (nodeId != null);
        assert (updateSeq > 0L);
        assert (nodeOrder > 0L);
        this.nodeId = nodeId;
        this.nodeOrder = nodeOrder;
        this.updateSeq = updateSeq;
        for (Map.Entry<UUID, GridDhtPartitionMap> e : m.entrySet()) {
            GridDhtPartitionMap part = e.getValue();
            GridDhtPartitionMap cpy = new GridDhtPartitionMap(part.nodeId(), part.updateSequence(), part.topologyVersion(), part.map(), onlyActive);
            this.put(e.getKey(), cpy);
        }
    }

    public GridDhtPartitionFullMap(GridDhtPartitionFullMap m, long updateSeq) {
        super(m);
        this.nodeId = m.nodeId;
        this.nodeOrder = m.nodeOrder;
        this.updateSeq = updateSeq;
    }

    public GridDhtPartitionFullMap() {
    }

    public boolean valid() {
        return this.nodeId != null && this.nodeOrder > 0L;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public long nodeOrder() {
        return this.nodeOrder;
    }

    public long updateSequence() {
        return this.updateSeq;
    }

    public boolean partitionStateEquals(GridDhtPartitionFullMap fullMap) {
        if (this.size() != fullMap.size()) {
            return false;
        }
        for (Map.Entry e : this.entrySet()) {
            GridDhtPartitionMap m = (GridDhtPartitionMap)fullMap.get(e.getKey());
            if (m != null && m.map().equals(((GridDhtPartitionMap)e.getValue()).map())) continue;
            return false;
        }
        return true;
    }

    public void newUpdateSequence(long updateSeq) {
        this.updateSeq = updateSeq;
    }

    public long updateSequence(long updateSeq) {
        long old = this.updateSeq;
        assert (updateSeq >= old) : "Invalid update sequence [cur=" + old + ", new=" + updateSeq + ", partMap=" + this.toFullString() + ']';
        this.updateSeq = updateSeq;
        return old;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.nodeId);
        out.writeLong(this.nodeOrder);
        out.writeLong(this.updateSeq);
        U.writeMap(out, this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = U.readUuid(in);
        this.nodeOrder = in.readLong();
        this.updateSeq = in.readLong();
        this.putAll(U.readMap(in));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        GridDhtPartitionFullMap other = (GridDhtPartitionFullMap)o;
        return other.nodeId.equals(this.nodeId) && other.updateSeq == this.updateSeq;
    }

    @Override
    public int hashCode() {
        return 31 * this.nodeId.hashCode() + (int)(this.updateSeq ^ this.updateSeq >>> 32);
    }

    public String map2string() {
        Iterator it = this.entrySet().iterator();
        if (!it.hasNext()) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        while (true) {
            Map.Entry e = it.next();
            UUID nodeId = (UUID)e.getKey();
            GridDhtPartitionMap partMap = (GridDhtPartitionMap)e.getValue();
            buf.append(nodeId).append('=').append(partMap.toFullString());
            if (!it.hasNext()) {
                return buf.append('}').toString();
            }
            buf.append(", ");
        }
    }

    public String toFullString() {
        return S.toString(GridDhtPartitionFullMap.class, this, "size", (Object)this.size(), "map", (Object)this.map2string());
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionFullMap.class, this, "size", (Object)this.size());
    }

    @Override
    public int compareTo(@NotNull GridDhtPartitionFullMap o) {
        assert (this.nodeId.equals(o.nodeId));
        return Long.compare(this.updateSeq, o.updateSeq);
    }
}

