/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteDiagnosticAware;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.GridCacheFutureAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtGetSingleFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.near.CacheVersionedValue;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetResponse;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.Nullable;

public class GridPartitionedSingleGetFuture
extends GridCacheFutureAdapter<Object>
implements CacheGetFuture,
IgniteDiagnosticAware {
    protected static final int MAX_REMAP_CNT = IgniteSystemProperties.getInteger("IGNITE_NEAR_GET_MAX_REMAPS", 3);
    protected static final AtomicIntegerFieldUpdater<GridPartitionedSingleGetFuture> REMAP_CNT_UPD = AtomicIntegerFieldUpdater.newUpdater(GridPartitionedSingleGetFuture.class, "remapCnt");
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private AffinityTopologyVersion topVer;
    private final GridCacheContext cctx;
    private final KeyCacheObject key;
    private final boolean readThrough;
    private final boolean forcePrimary;
    private final IgniteUuid futId;
    private boolean trackable;
    private final UUID subjId;
    private final String taskName;
    private boolean deserializeBinary;
    private boolean skipVals;
    private IgniteCacheExpiryPolicy expiryPlc;
    private final boolean canRemap;
    private final boolean needVer;
    private final boolean keepCacheObjects;
    private boolean recovery;
    @GridToStringInclude
    private ClusterNode node;
    protected final MvccSnapshot mvccSnapshot;
    @GridToStringExclude
    protected final IgniteUuid deploymentLdrId;
    private volatile GridCacheUtils.BackupPostProcessingClosure postProcessingClos;
    private final String txLbl;
    private Set<ClusterNode> invalidNodes = Collections.emptySet();
    protected volatile int remapCnt;

    public GridPartitionedSingleGetFuture(GridCacheContext cctx, KeyCacheObject key, AffinityTopologyVersion topVer, boolean readThrough, boolean forcePrimary, @Nullable UUID subjId, String taskName, boolean deserializeBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, boolean recovery, String txLbl, @Nullable MvccSnapshot mvccSnapshot) {
        assert (key != null);
        assert (mvccSnapshot == null || cctx.mvccEnabled());
        AffinityTopologyVersion lockedTopVer = cctx.shared().lockedTopologyVersion(null);
        if (lockedTopVer != null) {
            topVer = lockedTopVer;
            this.canRemap = false;
        } else {
            this.canRemap = true;
        }
        this.cctx = cctx;
        this.key = key;
        this.readThrough = readThrough;
        this.forcePrimary = forcePrimary;
        this.subjId = subjId;
        this.taskName = taskName;
        this.deserializeBinary = deserializeBinary;
        this.expiryPlc = expiryPlc;
        this.skipVals = skipVals;
        this.needVer = needVer;
        this.keepCacheObjects = keepCacheObjects;
        this.recovery = recovery;
        this.topVer = topVer;
        this.mvccSnapshot = mvccSnapshot;
        this.deploymentLdrId = U.contextDeploymentClassLoaderId(cctx.kernalContext());
        this.txLbl = txLbl;
        this.futId = IgniteUuid.randomUuid();
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridPartitionedSingleGetFuture.class);
        }
    }

    public void init() {
        AffinityTopologyVersion mappingTopVer = this.topVer.topologyVersion() > 0L ? this.topVer : (this.canRemap ? this.cctx.affinity().affinityTopologyVersion() : this.cctx.shared().exchange().readyAffinityVersion());
        this.map(mappingTopVer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void map(final AffinityTopologyVersion topVer) {
        GridDhtPartitionsExchangeFuture fut = this.cctx.shared().exchange().lastTopologyFuture();
        if (!fut.isDone()) {
            if (fut.initialVersion().after(topVer) || fut.exchangeActions() != null && fut.exchangeActions().hasStop()) {
                fut = this.cctx.shared().exchange().lastFinishedFuture();
            } else {
                fut.listen(new IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                        if (fut.error() != null) {
                            GridPartitionedSingleGetFuture.this.onDone(fut.error());
                        } else {
                            GridPartitionedSingleGetFuture.this.cctx.closures().runLocalSafe((Runnable)new GridPlainRunnable(){

                                @Override
                                public void run() {
                                    GridPartitionedSingleGetFuture.this.map(topVer);
                                }
                            }, true);
                        }
                    }
                });
                return;
            }
        }
        if (!this.validate(fut)) {
            return;
        }
        ClusterNode node = this.mapKeyToNode(topVer);
        if (node == null) {
            assert (this.isDone()) : this;
            return;
        }
        if (this.isDone()) {
            return;
        }
        if (node.isLocal()) {
            GridDhtGetSingleFuture fut0 = this.cctx.dht().getDhtSingleAsync(node.id(), -1L, this.key, false, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc, this.skipVals, this.recovery, this.txLbl, this.mvccSnapshot);
            Collection<Integer> invalidParts = fut0.invalidPartitions();
            if (!F.isEmpty(invalidParts)) {
                this.addNodeAsInvalid(node);
                AffinityTopologyVersion updTopVer = this.cctx.shared().exchange().readyAffinityVersion();
                this.map(updTopVer);
            } else {
                fut0.listen(f -> {
                    try {
                        GridCacheEntryInfo info = (GridCacheEntryInfo)f.get();
                        this.setResult(info);
                    }
                    catch (Exception e) {
                        U.error(log, "Failed to get values from dht cache [fut=" + fut0 + "]", e);
                        this.onDone(e);
                    }
                });
            }
        } else {
            GridPartitionedSingleGetFuture fut0 = this;
            synchronized (fut0) {
                assert (this.node == null);
                this.topVer = topVer;
                this.node = node;
            }
            this.registrateFutureInMvccManager(this);
            boolean needVer = this.needVer;
            GridCacheUtils.BackupPostProcessingClosure postClos = CU.createBackupPostProcessingClosure(topVer, log, this.cctx, this.key, this.expiryPlc, this.readThrough && this.cctx.readThroughConfigured(), this.skipVals);
            if (postClos != null) {
                needVer = true;
                this.postProcessingClos = postClos;
            }
            GridNearSingleGetRequest req = new GridNearSingleGetRequest(this.cctx.cacheId(), this.futId.localId(), this.key, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc != null ? this.expiryPlc.forCreate() : -1L, this.expiryPlc != null ? this.expiryPlc.forAccess() : -1L, this.skipVals, false, needVer, this.cctx.deploymentEnabled(), this.recovery, this.txLbl, this.mvccSnapshot);
            try {
                this.cctx.io().send(node, (GridCacheMessage)req, this.cctx.ioPolicy());
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    this.onNodeLeft(node.id());
                }
                this.onDone(e);
            }
        }
    }

    @Nullable
    private ClusterNode mapKeyToNode(AffinityTopologyVersion topVer) {
        int part = this.cctx.affinity().partition(this.key);
        List<ClusterNode> affNodes = this.cctx.affinity().nodesByPartition(part, topVer);
        if (affNodes.isEmpty()) {
            this.onDone(this.serverNotFoundError(part, topVer));
            return null;
        }
        if (this.tryLocalGet(this.key, part, topVer, affNodes)) {
            return null;
        }
        ClusterNode affNode = this.cctx.selectAffinityNodeBalanced(affNodes, this.getInvalidNodes(), part, this.canRemap, this.forcePrimary);
        if (affNode == null) {
            this.onDone(this.serverNotFoundError(part, topVer));
            return null;
        }
        return affNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLocalGet(KeyCacheObject key, int part, AffinityTopologyVersion topVer, List<ClusterNode> affNodes) {
        boolean fastLocGet;
        boolean bl = fastLocGet = !this.cctx.mvccEnabled() && (!this.forcePrimary || affNodes.get(0).isLocal()) && this.cctx.reserveForFastLocalGet(part, topVer);
        if (fastLocGet) {
            try {
                if (this.localGet(topVer, key, part)) {
                    boolean bl2 = true;
                    return bl2;
                }
            }
            finally {
                this.cctx.releaseForFastLocalGet(part, topVer);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean localGet(AffinityTopologyVersion topVer, KeyCacheObject key, int part) {
        assert (this.cctx.affinityNode()) : this;
        GridDhtCacheAdapter colocated = this.cctx.dht();
        boolean readNoEntry = this.cctx.readNoEntry(this.expiryPlc, false);
        boolean evt = !this.skipVals;
        while (true) {
            this.cctx.shared().database().checkpointReadLock();
            try {
                boolean topStable;
                GridCacheEntryEx entry2222;
                CacheObject v = null;
                GridCacheVersion ver = null;
                boolean skipEntry = readNoEntry;
                if (readNoEntry) {
                    CacheDataRow row;
                    KeyCacheObject key0 = (KeyCacheObject)this.cctx.cacheObjects().prepareForCache(key, this.cctx);
                    CacheDataRow cacheDataRow = row = this.mvccSnapshot != null ? this.cctx.offheap().mvccRead(this.cctx, key0, this.mvccSnapshot) : this.cctx.offheap().read(this.cctx, key0);
                    if (row != null) {
                        long expireTime = row.expireTime();
                        if (expireTime == 0L || expireTime > U.currentTimeMillis()) {
                            v = row.value();
                            if (this.needVer) {
                                ver = row.version();
                            }
                            if (evt) {
                                this.cctx.events().readEvent(key, null, this.txLbl, row.value(), this.subjId, this.taskName, !this.deserializeBinary);
                            }
                        } else {
                            skipEntry = false;
                        }
                    }
                }
                if (!skipEntry && (entry2222 = colocated.entryEx(key)) != null) {
                    boolean isNew = entry2222.isNewLocked();
                    if (this.needVer) {
                        EntryGetResult res = entry2222.innerGetVersioned(null, null, false, evt, this.subjId, null, this.taskName, this.expiryPlc, true, null);
                        if (res != null) {
                            v = (CacheObject)res.value();
                            ver = res.version();
                        }
                    } else {
                        v = entry2222.innerGet(null, null, false, false, evt, this.subjId, null, this.taskName, this.expiryPlc, true);
                    }
                    entry2222.touch();
                    if (v == null && isNew && entry2222.markObsoleteIfEmpty(ver)) {
                        colocated.removeEntry(entry2222);
                    }
                }
                if (v != null) {
                    if (!this.skipVals && this.cctx.statisticsEnabled()) {
                        this.cctx.cache().metrics0().onRead(true);
                    }
                    if (!this.skipVals) {
                        this.setResult(v, ver);
                    } else {
                        this.setSkipValueResult(true, ver);
                    }
                    boolean entry2222 = true;
                    return entry2222;
                }
                boolean bl = topStable = this.cctx.isReplicated() || topVer.equals(this.cctx.topology().lastTopologyChangeVersion());
                if (!this.cctx.readThroughConfigured() && (topStable || this.partitionOwned(part))) {
                    if (!this.skipVals && this.cctx.statisticsEnabled()) {
                        colocated.metrics0().onRead(false);
                    }
                    if (this.skipVals) {
                        this.setSkipValueResult(false, null);
                    } else {
                        this.setResult(null, null);
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            catch (GridCacheEntryRemovedException v) {
                continue;
            }
            catch (GridDhtInvalidPartitionException ignored) {
                boolean bl = false;
                return bl;
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cctx.shared().database().checkpointReadUnlock();
                continue;
            }
            break;
        }
    }

    private void registrateFutureInMvccManager(GridCacheFuture<?> fut) {
        if (!this.trackable) {
            this.trackable = true;
            this.cctx.mvcc().addFuture(fut, this.futId);
        }
    }

    public void onResult(UUID nodeId, GridNearSingleGetResponse res) {
        if (!this.processResponse(nodeId)) {
            return;
        }
        if (!this.checkError(nodeId, res.invalidPartitions(), res.topologyVersion(), res.error())) {
            return;
        }
        Message res0 = res.result();
        if (this.needVer) {
            CacheVersionedValue verVal = (CacheVersionedValue)res0;
            if (verVal != null) {
                if (this.skipVals) {
                    this.setSkipValueResult(true, verVal.version());
                } else {
                    this.setResult(verVal.value(), verVal.version());
                }
            } else if (this.skipVals) {
                this.setSkipValueResult(false, null);
            } else {
                this.setResult(null, null);
            }
        } else if (this.skipVals) {
            this.setSkipValueResult(res.containsValue(), null);
        } else if (this.readThrough && res0 instanceof CacheVersionedValue) {
            CacheVersionedValue verVal = (CacheVersionedValue)res0;
            this.setResult(verVal.value(), verVal.version());
        } else {
            this.setResult((CacheObject)res0, null);
        }
    }

    @Override
    public void onResult(UUID nodeId, GridNearGetResponse res) {
        if (!this.processResponse(nodeId)) {
            return;
        }
        if (!this.checkError(nodeId, !F.isEmpty(res.invalidPartitions()), res.topologyVersion(), res.error())) {
            return;
        }
        Collection<GridCacheEntryInfo> infos = res.entries();
        assert (F.isEmpty(infos) || infos.size() == 1) : infos;
        this.setResult(F.first(infos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processResponse(UUID nodeId) {
        GridPartitionedSingleGetFuture gridPartitionedSingleGetFuture = this;
        synchronized (gridPartitionedSingleGetFuture) {
            if (this.node != null && this.node.id().equals(nodeId)) {
                this.node = null;
                return true;
            }
        }
        return false;
    }

    private boolean checkError(UUID nodeId, boolean invalidParts, AffinityTopologyVersion rmtTopVer, @Nullable IgniteCheckedException err) {
        if (err != null) {
            this.onDone(err);
            return false;
        }
        if (invalidParts) {
            this.addNodeAsInvalid(this.cctx.node(nodeId));
            if (this.canRemap) {
                this.awaitVersionAndRemap(rmtTopVer);
            } else {
                this.map(this.topVer);
            }
            return false;
        }
        return true;
    }

    private void setResult(@Nullable GridCacheEntryInfo info) {
        assert (info == null || this.skipVals == (info.value() == null));
        if (this.skipVals) {
            if (info != null) {
                this.setSkipValueResult(true, info.version());
            } else {
                this.setSkipValueResult(false, null);
            }
        } else if (info != null) {
            this.setResult(info.value(), info.version());
        } else {
            this.setResult(null, null);
        }
    }

    private void setSkipValueResult(boolean res, @Nullable GridCacheVersion ver) {
        assert (this.skipVals);
        if (this.needVer) {
            assert (ver != null || !res);
            this.onDone(new EntryGetResult(res, ver));
        } else {
            this.onDone(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(@Nullable CacheObject val, @Nullable GridCacheVersion ver) {
        this.cctx.shared().database().checkpointReadLock();
        try {
            assert (!this.skipVals);
            if (val != null) {
                if (this.postProcessingClos != null) {
                    this.postProcessingClos.apply(val, ver);
                }
                if (!this.keepCacheObjects) {
                    Object res = this.cctx.unwrapBinaryIfNeeded(val, !this.deserializeBinary, true, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                    this.onDone(this.needVer ? new EntryGetResult(res, ver) : res);
                } else {
                    this.onDone(this.needVer ? new EntryGetResult(val, ver) : val);
                }
            } else {
                this.onDone(null);
            }
        }
        catch (Exception e) {
            this.onDone(e);
        }
        finally {
            this.cctx.shared().database().checkpointReadUnlock();
        }
    }

    private boolean partitionOwned(int part) {
        return this.cctx.topology().partitionState(this.cctx.localNodeId(), part) == GridDhtPartitionState.OWNING;
    }

    private synchronized void addNodeAsInvalid(ClusterNode node) {
        if (this.invalidNodes == Collections.emptySet()) {
            this.invalidNodes = new HashSet<ClusterNode>();
        }
        this.invalidNodes.add(node);
    }

    protected synchronized Set<ClusterNode> getInvalidNodes() {
        return this.invalidNodes;
    }

    private boolean checkRetryPermits(AffinityTopologyVersion topVer) {
        if (topVer.equals(this.topVer)) {
            return true;
        }
        if (REMAP_CNT_UPD.incrementAndGet(this) > MAX_REMAP_CNT) {
            ClusterNode node0 = this.node;
            this.onDone(new ClusterTopologyCheckedException("Failed to remap key to a new node after " + MAX_REMAP_CNT + " attempts (key got remapped to the same node) [key=" + this.key + ", node=" + (node0 != null ? U.toShortString(node0) : node0) + ", invalidNodes=" + this.invalidNodes + ']'));
            return false;
        }
        return true;
    }

    private ClusterTopologyServerNotFoundException serverNotFoundError(int part, AffinityTopologyVersion topVer) {
        return new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid) [topVer=" + topVer + ", part=" + part + ", cache=" + this.cctx.name() + ']');
    }

    private boolean validate(GridDhtTopologyFuture topFut) {
        assert (topFut.isDone()) : topFut;
        if (!this.checkRetryPermits(topFut.topologyVersion())) {
            return false;
        }
        CacheInvalidStateException error = topFut.validateCache(this.cctx, this.recovery, true, this.key, null);
        if (error != null) {
            this.onDone(error);
            return false;
        }
        return true;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        if (!this.processResponse(nodeId)) {
            return false;
        }
        if (this.canRemap) {
            long maxTopVer = Math.max(this.topVer.topologyVersion() + 1L, this.cctx.discovery().topologyVersion());
            this.awaitVersionAndRemap(new AffinityTopologyVersion(maxTopVer));
        } else {
            this.remap(this.topVer);
        }
        return true;
    }

    private void awaitVersionAndRemap(AffinityTopologyVersion topVer) {
        IgniteInternalFuture<AffinityTopologyVersion> awaitTopologyVersionFuture = this.cctx.shared().exchange().affinityReadyFuture(topVer);
        awaitTopologyVersionFuture.listen(f -> {
            try {
                this.remap((AffinityTopologyVersion)f.get());
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
            }
        });
    }

    private void remap(final AffinityTopologyVersion topVer) {
        this.cctx.closures().runLocalSafe(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    GridPartitionedSingleGetFuture.this.invalidNodes = Collections.emptySet();
                }
                GridPartitionedSingleGetFuture.this.map(topVer);
            }
        });
    }

    @Override
    public boolean onDone(Object res, Throwable err) {
        if (super.onDone(res, err)) {
            if (this.trackable) {
                this.cctx.mvcc().removeFuture(this.futId);
            }
            if (!(err instanceof NodeStoppingException)) {
                this.cctx.dht().sendTtlUpdateRequest(this.expiryPlc);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiagnosticRequest(IgniteDiagnosticPrepareContext ctx) {
        if (!this.isDone()) {
            AffinityTopologyVersion topVer;
            UUID nodeId;
            GridPartitionedSingleGetFuture gridPartitionedSingleGetFuture = this;
            synchronized (gridPartitionedSingleGetFuture) {
                nodeId = this.node != null ? this.node.id() : null;
                topVer = this.topVer;
            }
            if (nodeId != null) {
                ctx.basicInfo(nodeId, "GridPartitionedSingleGetFuture waiting for response [node=" + nodeId + ", key=" + this.key + ", futId=" + this.futId + ", topVer=" + topVer + ']');
            }
        }
    }

    @Override
    public String toString() {
        return S.toString(GridPartitionedSingleGetFuture.class, this, "super", (Object)super.toString());
    }
}

