/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.util.UUID;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.binary.MetadataRemoveAcceptedMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public final class MetadataRemoveProposedMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private final IgniteUuid id = IgniteUuid.randomUuid();
    private final UUID origNodeId;
    private final int typeId;
    private ProposalStatus status = ProposalStatus.SUCCESSFUL;
    private boolean onCoordinator = true;
    private BinaryObjectException err;

    public MetadataRemoveProposedMessage(int typeId, UUID origNodeId) {
        assert (origNodeId != null);
        this.origNodeId = origNodeId;
        this.typeId = typeId;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return this.status == ProposalStatus.SUCCESSFUL ? new MetadataRemoveAcceptedMessage(this.typeId) : null;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    @Nullable
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        throw new UnsupportedOperationException();
    }

    void markRejected(BinaryObjectException err) {
        this.status = ProposalStatus.REJECTED;
        this.err = err;
    }

    boolean rejected() {
        return this.status == ProposalStatus.REJECTED;
    }

    BinaryObjectException rejectionError() {
        return this.err;
    }

    UUID origNodeId() {
        return this.origNodeId;
    }

    public int typeId() {
        return this.typeId;
    }

    public boolean isOnCoordinator() {
        return this.onCoordinator;
    }

    public void setOnCoordinator(boolean onCoordinator) {
        this.onCoordinator = onCoordinator;
    }

    public String toString() {
        return S.toString(MetadataRemoveProposedMessage.class, this);
    }

    private static enum ProposalStatus {
        SUCCESSFUL,
        REJECTED;

    }
}

