/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.UnregisteredBinaryTypeException;
import org.apache.ignite.internal.UnregisteredClassException;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class CacheInvokeResult<T>
implements EntryProcessorResult<T>,
Externalizable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude(sensitive=true)
    private T res;
    private Exception err;

    public static <T> CacheInvokeResult<T> fromResult(T res) {
        CacheInvokeResult<T> cacheRes = new CacheInvokeResult<T>();
        cacheRes.res = res;
        return cacheRes;
    }

    public T result() {
        return this.res;
    }

    public Exception error() {
        return this.err;
    }

    public static <T> CacheInvokeResult<T> fromError(Exception err) {
        assert (err != null);
        CacheInvokeResult<T> res = new CacheInvokeResult<T>();
        res.err = err;
        return res;
    }

    public T get() throws EntryProcessorException {
        if (this.err != null) {
            if (this.err instanceof UnregisteredClassException || this.err instanceof UnregisteredBinaryTypeException) {
                throw (IgniteException)this.err;
            }
            if (this.err instanceof EntryProcessorException) {
                throw (EntryProcessorException)this.err;
            }
            throw new EntryProcessorException((Throwable)this.err);
        }
        return this.res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.res);
        out.writeObject(this.err);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.res = in.readObject();
        this.err = (Exception)in.readObject();
    }

    public String toString() {
        return S.toString(CacheInvokeResult.class, this);
    }
}

