/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.managers.communication.AbstractTransmission;
import org.apache.ignite.internal.managers.communication.TransmissionMeta;
import org.apache.ignite.internal.managers.communication.TransmissionPolicy;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class FileSender
extends AbstractTransmission {
    @GridToStringExclude
    private FileIO fileIo;

    public FileSender(File file, long off, long cnt, Map<String, Serializable> params, TransmissionPolicy plc, BooleanSupplier stopChecker, IgniteLogger log, FileIOFactory factory, int chunkSize) throws IOException {
        super(new TransmissionMeta(file.getName(), off, cnt, params, plc, null), stopChecker, log, chunkSize);
        assert (file != null);
        this.fileIo = factory.create(file);
    }

    public void send(WritableByteChannel ch, ObjectOutput oo, @Nullable TransmissionMeta rcvMeta) throws IOException, InterruptedException {
        this.updateSenderState(rcvMeta);
        oo.writeBoolean(false);
        oo.writeObject(new TransmissionMeta(this.meta.name(), this.meta.offset() + this.transferred, this.meta.count() - this.transferred, this.meta.params(), this.meta.policy(), null));
        while (this.hasNextChunk()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Sender thread has been interruped");
            }
            if (this.stopped()) {
                throw new IgniteException("Sender has been cancelled due to the local node is stopping");
            }
            this.writeChunk(ch);
        }
        assert (this.transferred == this.meta.count()) : "File is not fully transferred [expect=" + this.meta.count() + ", actual=" + this.transferred + ']';
    }

    private void updateSenderState(TransmissionMeta rcvMeta) {
        if (rcvMeta == null || rcvMeta.offset() < 0L) {
            this.transferred = 0L;
            return;
        }
        long uploadedBytes = rcvMeta.offset() - this.meta.offset();
        IgniteUtils.assertParameter(this.meta.name().equals(rcvMeta.name()), "Attempt to transfer different file while previous is not completed [meta=" + this.meta + ", meta=" + rcvMeta + ']');
        IgniteUtils.assertParameter(uploadedBytes >= 0L, "Incorrect sync meta [offset=" + rcvMeta.offset() + ", meta=" + this.meta + ']');
        if (uploadedBytes == 0L) {
            return;
        }
        this.transferred = uploadedBytes;
        U.log(this.log, "The number of transferred bytes after reconnect has been updated: " + uploadedBytes);
    }

    private void writeChunk(WritableByteChannel ch) throws IOException {
        long batchSize = Math.min((long)this.chunkSize, this.meta.count() - this.transferred);
        long sent = this.fileIo.transferTo(this.meta.offset() + this.transferred, batchSize, ch);
        if (sent > 0L) {
            this.transferred += sent;
        }
    }

    @Override
    public void close() {
        U.closeQuiet(this.fileIo);
    }

    @Override
    public String toString() {
        return S.toString(FileSender.class, this, "super", (Object)super.toString());
    }
}

