/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.internal.client.thin.ClientCacheAffinityMapping;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.GridConcurrentHashSet;

public class ClientCacheAffinityContext {
    private final IgniteBinary binary;
    private final AtomicReference<TopologyNodes> lastTop = new AtomicReference();
    private volatile ClientCacheAffinityMapping affinityMapping;
    private final Set<Integer> pendingCacheIds = new GridConcurrentHashSet<Integer>();

    public ClientCacheAffinityContext(IgniteBinary binary) {
        this.binary = binary;
    }

    public boolean updateLastTopologyVersion(AffinityTopologyVersion topVer, UUID nodeId) {
        TopologyNodes lastTop;
        while ((lastTop = this.lastTop.get()) == null || topVer.compareTo(lastTop.topVer) > 0) {
            if (!this.lastTop.compareAndSet(lastTop, new TopologyNodes(topVer, nodeId))) continue;
            return true;
        }
        if (topVer.equals(lastTop.topVer)) {
            lastTop.nodes.add(nodeId);
            return false;
        }
        return false;
    }

    public boolean affinityUpdateRequired(int cacheId) {
        TopologyNodes top = this.lastTop.get();
        if (top == null) {
            this.pendingCacheIds.add(cacheId);
            return false;
        }
        ClientCacheAffinityMapping mapping = this.affinityMapping;
        if (mapping == null) {
            this.pendingCacheIds.add(cacheId);
            return true;
        }
        if (top.topVer.compareTo(mapping.topologyVersion()) > 0) {
            this.pendingCacheIds.add(cacheId);
            return true;
        }
        if (mapping.cacheIds().contains(cacheId)) {
            return false;
        }
        this.pendingCacheIds.add(cacheId);
        return true;
    }

    public void writePartitionsUpdateRequest(PayloadOutputChannel ch) {
        ClientCacheAffinityMapping.writeRequest(ch, this.pendingCacheIds);
    }

    public synchronized boolean readPartitionsUpdateResponse(PayloadInputChannel ch) {
        if (this.lastTop.get() == null) {
            return false;
        }
        ClientCacheAffinityMapping newMapping = ClientCacheAffinityMapping.readResponse(ch);
        ClientCacheAffinityMapping oldMapping = this.affinityMapping;
        if (oldMapping == null || newMapping.topologyVersion().compareTo(oldMapping.topologyVersion()) > 0) {
            this.affinityMapping = newMapping;
            if (oldMapping != null) {
                this.pendingCacheIds.addAll(oldMapping.cacheIds());
            }
            this.pendingCacheIds.removeAll(newMapping.cacheIds());
            return true;
        }
        if (newMapping.topologyVersion().equals(oldMapping.topologyVersion())) {
            this.affinityMapping = ClientCacheAffinityMapping.merge(oldMapping, newMapping);
            this.pendingCacheIds.removeAll(newMapping.cacheIds());
            return true;
        }
        return true;
    }

    public TopologyNodes lastTopology() {
        return this.lastTop.get();
    }

    public synchronized void reset(TopologyNodes top) {
        if (this.lastTop.compareAndSet(top, null)) {
            this.affinityMapping = null;
            this.pendingCacheIds.clear();
        }
    }

    public UUID affinityNode(int cacheId, Object key) {
        TopologyNodes top = this.lastTop.get();
        if (top == null) {
            return null;
        }
        ClientCacheAffinityMapping mapping = this.affinityMapping;
        if (mapping == null) {
            return null;
        }
        if (top.topVer.compareTo(mapping.topologyVersion()) > 0) {
            return null;
        }
        return mapping.affinityNode(this.binary, cacheId, key);
    }

    static class TopologyNodes {
        private final AffinityTopologyVersion topVer;
        private final Collection<UUID> nodes = new ConcurrentLinkedQueue<UUID>();

        private TopologyNodes(AffinityTopologyVersion topVer, UUID nodeId) {
            this.topVer = topVer;
            this.nodes.add(nodeId);
        }

        public Iterable<UUID> nodes() {
            return Collections.unmodifiableCollection(this.nodes);
        }
    }
}

