/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFuture;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.balancer.GridClientLoadBalancer;
import org.apache.ignite.internal.client.impl.GridClientAbstractProjection;
import org.apache.ignite.internal.client.impl.GridClientAndPredicate;
import org.apache.ignite.internal.client.impl.GridClientImpl;
import org.apache.ignite.internal.client.impl.connection.GridClientConnection;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.util.GridClientUtils;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.jetbrains.annotations.Nullable;

class GridClientComputeImpl
extends GridClientAbstractProjection<GridClientComputeImpl>
implements GridClientCompute {
    private static final ThreadLocal<Boolean> KEEP_BINARIES = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final GridClientPredicate<GridClientNode> NOT_DAEMON = n -> !n.isDaemon();
    private final GridClientComputeFactory prjFactory = new GridClientComputeFactory();

    GridClientComputeImpl(GridClientImpl client, Collection<GridClientNode> nodes, GridClientPredicate<? super GridClientNode> nodeFilter, GridClientLoadBalancer balancer) {
        super(client, nodes, nodeFilter, balancer);
    }

    @Override
    public GridClientCompute projection(GridClientNode node) throws GridClientException {
        A.notNull(node, "node");
        return this.createProjection(Collections.singletonList(node), null, null, this.prjFactory);
    }

    @Override
    public GridClientCompute projection(GridClientPredicate<? super GridClientNode> filter) throws GridClientException {
        return this.createProjection(null, filter, null, this.prjFactory);
    }

    @Override
    public GridClientCompute projection(Collection<GridClientNode> nodes) throws GridClientException {
        return this.createProjection(nodes, null, null, this.prjFactory);
    }

    @Override
    public GridClientCompute projection(GridClientPredicate<? super GridClientNode> filter, GridClientLoadBalancer balancer) throws GridClientException {
        return this.createProjection(null, filter, balancer, this.prjFactory);
    }

    @Override
    public GridClientCompute projection(Collection<GridClientNode> nodes, GridClientLoadBalancer balancer) throws GridClientException {
        return this.createProjection(nodes, null, balancer, this.prjFactory);
    }

    @Override
    public GridClientLoadBalancer balancer() {
        return this.balancer;
    }

    @Override
    public <R> R execute(String taskName, Object taskArg) throws GridClientException {
        return this.executeAsync(taskName, taskArg).get();
    }

    @Override
    public <R> GridClientFuture<R> executeAsync(final String taskName, final Object taskArg) {
        A.notNull(taskName, "taskName");
        final boolean keepBinaries = KEEP_BINARIES.get();
        KEEP_BINARIES.set(false);
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<R>(){

            @Override
            public GridClientFuture<R> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.execute(taskName, taskArg, destNodeId, keepBinaries);
            }
        });
    }

    @Override
    public <R> R affinityExecute(String taskName, String cacheName, Object affKey, Object taskArg) throws GridClientException {
        return this.affinityExecuteAsync(taskName, cacheName, affKey, taskArg).get();
    }

    @Override
    public <R> GridClientFuture<R> affinityExecuteAsync(final String taskName, String cacheName, Object affKey, final Object taskArg) {
        A.notNull(taskName, "taskName");
        final boolean keepBinaries = KEEP_BINARIES.get();
        KEEP_BINARIES.set(false);
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<R>(){

            @Override
            public GridClientFuture<R> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.execute(taskName, taskArg, destNodeId, keepBinaries);
            }
        }, cacheName, affKey);
    }

    @Override
    public GridClientNode node(UUID id) throws GridClientException {
        A.notNull(id, "id");
        return this.client.topology().node(id);
    }

    @Override
    public Collection<GridClientNode> nodes() throws GridClientException {
        return GridClientUtils.applyFilter(this.projectionNodes(), NOT_DAEMON);
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<UUID> ids) throws GridClientException {
        A.notNull(ids, "ids");
        return this.client.topology().nodes(ids);
    }

    @Override
    public Collection<GridClientNode> nodes(GridClientPredicate<GridClientNode> filter) throws GridClientException {
        A.notNull(filter, "filter");
        return GridClientUtils.applyFilter(this.projectionNodes(), new GridClientAndPredicate<GridClientNode>(filter, NOT_DAEMON));
    }

    @Override
    public Collection<GridClientNode> daemonNodes() throws GridClientException {
        return GridClientUtils.applyFilter(this.projectionNodes(), GridClientNode::isDaemon);
    }

    @Override
    public GridClientNode refreshNode(UUID id, boolean includeAttrs, boolean includeMetrics) throws GridClientException {
        return this.refreshNodeAsync(id, includeAttrs, includeMetrics).get();
    }

    @Override
    public GridClientFuture<GridClientNode> refreshNodeAsync(final UUID id, final boolean includeAttrs, final boolean includeMetrics) {
        A.notNull(id, "id");
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<GridClientNode>(){

            @Override
            public GridClientFuture<GridClientNode> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.node(id, includeAttrs, includeMetrics, destNodeId);
            }
        });
    }

    @Override
    @Nullable
    public GridClientNode refreshNode(String ip, boolean includeAttrs, boolean inclMetrics) throws GridClientException {
        return this.refreshNodeAsync(ip, includeAttrs, inclMetrics).get();
    }

    @Override
    public GridClientFuture<GridClientNode> refreshNodeAsync(final String ip, final boolean inclAttrs, final boolean includeMetrics) {
        A.notNull(ip, "ip");
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<GridClientNode>(){

            @Override
            public GridClientFuture<GridClientNode> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.node(ip, inclAttrs, includeMetrics, destNodeId);
            }
        });
    }

    @Override
    public List<GridClientNode> refreshTopology(boolean includeAttrs, boolean includeMetrics) throws GridClientException {
        return this.refreshTopologyAsync(includeAttrs, includeMetrics).get();
    }

    @Override
    public GridClientFuture<List<GridClientNode>> refreshTopologyAsync(final boolean inclAttrs, final boolean includeMetrics) {
        return this.withReconnectHandling(new GridClientAbstractProjection.ClientProjectionClosure<List<GridClientNode>>(){

            @Override
            public GridClientFuture<List<GridClientNode>> apply(GridClientConnection conn, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
                return conn.topology(inclAttrs, includeMetrics, destNodeId);
            }
        });
    }

    @Override
    public GridClientCompute withKeepBinaries() {
        KEEP_BINARIES.set(true);
        return this;
    }

    private class GridClientComputeFactory
    implements GridClientAbstractProjection.ProjectionFactory<GridClientComputeImpl> {
        private GridClientComputeFactory() {
        }

        @Override
        public GridClientComputeImpl create(Collection<GridClientNode> nodes, GridClientPredicate<? super GridClientNode> filter, GridClientLoadBalancer balancer) {
            return new GridClientComputeImpl(GridClientComputeImpl.this.client, nodes, filter, balancer);
        }
    }
}

