/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.streams;

import org.apache.ignite.internal.binary.streams.BinaryAbstractStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.util.GridUnsafe;

public abstract class BinaryAbstractOutputStream
extends BinaryAbstractStream
implements BinaryOutputStream {
    private static final int MIN_CAP = 256;
    protected static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    @Override
    public void writeByte(byte val) {
        this.ensureCapacity(this.pos + 1);
        this.writeByteAndShift(val);
    }

    @Override
    public void writeByteArray(byte[] val) {
        this.ensureCapacity(this.pos + val.length);
        this.copyAndShift(val, GridUnsafe.BYTE_ARR_OFF, val.length);
    }

    @Override
    public void writeBoolean(boolean val) {
        this.writeByte(val ? (byte)1 : 0);
    }

    @Override
    public void writeBooleanArray(boolean[] val) {
        this.ensureCapacity(this.pos + val.length);
        this.copyAndShift(val, GridUnsafe.BOOLEAN_ARR_OFF, val.length);
    }

    @Override
    public void writeShort(short val) {
        this.ensureCapacity(this.pos + 2);
        this.writeShortFast(val);
        this.shift(2);
    }

    @Override
    public void writeShortArray(short[] val) {
        int cnt = val.length << 1;
        this.ensureCapacity(this.pos + cnt);
        if (GridUnsafe.BIG_ENDIAN) {
            for (short item : val) {
                this.writeShortFast(item);
                this.shift(2);
            }
        } else {
            this.copyAndShift(val, GridUnsafe.SHORT_ARR_OFF, cnt);
        }
    }

    @Override
    public void writeChar(char val) {
        this.ensureCapacity(this.pos + 2);
        this.writeCharFast(val);
        this.shift(2);
    }

    @Override
    public void writeCharArray(char[] val) {
        int cnt = val.length << 1;
        this.ensureCapacity(this.pos + cnt);
        if (GridUnsafe.BIG_ENDIAN) {
            for (char item : val) {
                this.writeCharFast(item);
                this.shift(2);
            }
        } else {
            this.copyAndShift(val, GridUnsafe.CHAR_ARR_OFF, cnt);
        }
    }

    @Override
    public void writeInt(int val) {
        this.ensureCapacity(this.pos + 4);
        this.writeIntFast(val);
        this.shift(4);
    }

    @Override
    public void writeShort(int pos, short val) {
        this.ensureCapacity(pos + 2);
        this.unsafeWriteShort(pos, val);
    }

    @Override
    public void writeInt(int pos, int val) {
        this.ensureCapacity(pos + 4);
        this.unsafeWriteInt(pos, val);
    }

    @Override
    public void writeIntArray(int[] val) {
        int cnt = val.length << 2;
        this.ensureCapacity(this.pos + cnt);
        if (GridUnsafe.BIG_ENDIAN) {
            for (int item : val) {
                this.writeIntFast(item);
                this.shift(4);
            }
        } else {
            this.copyAndShift(val, GridUnsafe.INT_ARR_OFF, cnt);
        }
    }

    @Override
    public void writeFloat(float val) {
        this.writeInt(Float.floatToIntBits(val));
    }

    @Override
    public void writeFloatArray(float[] val) {
        int cnt = val.length << 2;
        this.ensureCapacity(this.pos + cnt);
        if (GridUnsafe.BIG_ENDIAN) {
            for (float item : val) {
                this.writeIntFast(Float.floatToIntBits(item));
                this.shift(4);
            }
        } else {
            this.copyAndShift(val, GridUnsafe.FLOAT_ARR_OFF, cnt);
        }
    }

    @Override
    public void writeLong(long val) {
        this.ensureCapacity(this.pos + 8);
        this.writeLongFast(val);
        this.shift(8);
    }

    @Override
    public void writeLongArray(long[] val) {
        int cnt = val.length << 3;
        this.ensureCapacity(this.pos + cnt);
        if (GridUnsafe.BIG_ENDIAN) {
            for (long item : val) {
                this.writeLongFast(item);
                this.shift(8);
            }
        } else {
            this.copyAndShift(val, GridUnsafe.LONG_ARR_OFF, cnt);
        }
    }

    @Override
    public void writeDouble(double val) {
        this.writeLong(Double.doubleToLongBits(val));
    }

    @Override
    public void writeDoubleArray(double[] val) {
        int cnt = val.length << 3;
        this.ensureCapacity(this.pos + cnt);
        if (GridUnsafe.BIG_ENDIAN) {
            for (double item : val) {
                this.writeLongFast(Double.doubleToLongBits(item));
                this.shift(8);
            }
        } else {
            this.copyAndShift(val, GridUnsafe.DOUBLE_ARR_OFF, cnt);
        }
    }

    @Override
    public void write(byte[] arr, int off, int len) {
        this.ensureCapacity(this.pos + len);
        this.copyAndShift(arr, GridUnsafe.BYTE_ARR_OFF + (long)off, len);
    }

    @Override
    public void write(long addr, int cnt) {
        this.ensureCapacity(this.pos + cnt);
        this.copyAndShift(null, addr, cnt);
    }

    @Override
    public void position(int pos) {
        this.ensureCapacity(pos);
        this.unsafePosition(pos);
    }

    @Override
    public long offheapPointer() {
        return 0L;
    }

    @Override
    public long rawOffheapPointer() {
        return 0L;
    }

    @Override
    public void unsafeEnsure(int cap) {
        this.ensureCapacity(this.pos + cap);
    }

    @Override
    public void unsafePosition(int pos) {
        this.pos = pos;
    }

    @Override
    public void unsafeWriteBoolean(boolean val) {
        this.unsafeWriteByte(val ? (byte)1 : 0);
    }

    @Override
    public void unsafeWriteFloat(float val) {
        this.unsafeWriteInt(Float.floatToIntBits(val));
    }

    @Override
    public void unsafeWriteDouble(double val) {
        this.unsafeWriteLong(Double.doubleToLongBits(val));
    }

    protected static int capacity(int curCap, int reqCap) {
        int newCap;
        if (reqCap < 256) {
            newCap = 256;
        } else {
            if (reqCap > 0x7FFFFFF7) {
                throw new IllegalArgumentException("Required capacity exceeds allowed. Required:" + reqCap);
            }
            newCap = Math.max(curCap, 256);
            while (newCap < reqCap) {
                if ((newCap <<= 1) >= 0) continue;
                newCap = 0x7FFFFFF7;
            }
        }
        return newCap;
    }

    protected abstract void writeByteAndShift(byte var1);

    protected abstract void copyAndShift(Object var1, long var2, int var4);

    protected abstract void writeShortFast(short var1);

    protected abstract void writeCharFast(char var1);

    protected abstract void writeIntFast(int var1);

    protected abstract void writeLongFast(long var1);

    protected abstract void ensureCapacity(int var1);
}

