/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.metrics.OutlierDetector;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.util.Daemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DataNodeDiskMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(DataNodeDiskMetrics.class);
    private DataNode dn;
    private final long MIN_OUTLIER_DETECTION_DISKS = 5L;
    private final long SLOW_DISK_LOW_THRESHOLD_MS = 20L;
    private final long detectionInterval;
    private volatile boolean shouldRun;
    private OutlierDetector slowDiskDetector;
    private Daemon slowDiskDetectionDaemon;
    private volatile Map<String, Map<SlowDiskReports.DiskOp, Double>> diskOutliersStats = Maps.newHashMap();
    private boolean overrideStatus = true;

    public DataNodeDiskMetrics(DataNode dn, long diskOutlierDetectionIntervalMs) {
        this.dn = dn;
        this.detectionInterval = diskOutlierDetectionIntervalMs;
        this.slowDiskDetector = new OutlierDetector(5L, 20L);
        this.shouldRun = true;
        this.startDiskOutlierDetectionThread();
    }

    private void startDiskOutlierDetectionThread() {
        this.slowDiskDetectionDaemon = new Daemon(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (DataNodeDiskMetrics.this.shouldRun) {
                    if (DataNodeDiskMetrics.this.dn.getFSDataset() != null) {
                        HashMap metadataOpStats = Maps.newHashMap();
                        HashMap readIoStats = Maps.newHashMap();
                        HashMap writeIoStats = Maps.newHashMap();
                        FsDatasetSpi.FsVolumeReferences fsVolumeReferences = null;
                        try {
                            fsVolumeReferences = DataNodeDiskMetrics.this.dn.getFSDataset().getFsVolumeReferences();
                            for (FsVolumeSpi volume : fsVolumeReferences) {
                                DataNodeVolumeMetrics metrics = volume.getMetrics();
                                String volumeName = volume.getBaseURI().getPath();
                                metadataOpStats.put(volumeName, metrics.getMetadataOperationMean());
                                readIoStats.put(volumeName, metrics.getReadIoMean());
                                writeIoStats.put(volumeName, metrics.getWriteIoMean());
                            }
                        }
                        finally {
                            if (fsVolumeReferences != null) {
                                try {
                                    fsVolumeReferences.close();
                                }
                                catch (IOException e) {
                                    LOG.error("Error in releasing FS Volume references", (Throwable)e);
                                }
                            }
                        }
                        if (metadataOpStats.isEmpty() && readIoStats.isEmpty() && writeIoStats.isEmpty()) {
                            LOG.debug("No disk stats available for detecting outliers.");
                            continue;
                        }
                        DataNodeDiskMetrics.this.detectAndUpdateDiskOutliers(metadataOpStats, readIoStats, writeIoStats);
                    }
                    try {
                        Thread.sleep(DataNodeDiskMetrics.this.detectionInterval);
                    }
                    catch (InterruptedException e) {
                        LOG.error("Disk Outlier Detection thread interrupted", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        this.slowDiskDetectionDaemon.start();
    }

    private void detectAndUpdateDiskOutliers(Map<String, Double> metadataOpStats, Map<String, Double> readIoStats, Map<String, Double> writeIoStats) {
        HashMap diskStats = Maps.newHashMap();
        Map<String, Double> metadataOpOutliers = this.slowDiskDetector.getOutliers(metadataOpStats);
        for (Map.Entry<String, Double> entry : metadataOpOutliers.entrySet()) {
            this.addDiskStat(diskStats, entry.getKey(), SlowDiskReports.DiskOp.METADATA, entry.getValue());
        }
        Map<String, Double> readIoOutliers = this.slowDiskDetector.getOutliers(readIoStats);
        for (Map.Entry<String, Double> entry : readIoOutliers.entrySet()) {
            this.addDiskStat(diskStats, entry.getKey(), SlowDiskReports.DiskOp.READ, entry.getValue());
        }
        Map<String, Double> map = this.slowDiskDetector.getOutliers(writeIoStats);
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            this.addDiskStat(diskStats, entry.getKey(), SlowDiskReports.DiskOp.WRITE, entry.getValue());
        }
        if (this.overrideStatus) {
            this.diskOutliersStats = diskStats;
            LOG.debug("Updated disk outliers.");
        }
    }

    private void addDiskStat(Map<String, Map<SlowDiskReports.DiskOp, Double>> diskStats, String disk, SlowDiskReports.DiskOp diskOp, double latency) {
        if (!diskStats.containsKey(disk)) {
            diskStats.put(disk, new HashMap());
        }
        diskStats.get(disk).put(diskOp, latency);
    }

    public Map<String, Map<SlowDiskReports.DiskOp, Double>> getDiskOutliersStats() {
        return this.diskOutliersStats;
    }

    public void shutdownAndWait() {
        this.shouldRun = false;
        this.slowDiskDetectionDaemon.interrupt();
        try {
            this.slowDiskDetectionDaemon.join();
        }
        catch (InterruptedException e) {
            LOG.error("Disk Outlier Detection daemon did not shutdown", (Throwable)e);
        }
    }

    @VisibleForTesting
    public void addSlowDiskForTesting(String slowDiskPath, Map<SlowDiskReports.DiskOp, Double> latencies) {
        this.overrideStatus = false;
        if (latencies == null) {
            this.diskOutliersStats.put(slowDiskPath, (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of());
        } else {
            this.diskOutliersStats.put(slowDiskPath, latencies);
        }
    }
}

