/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.DistributedHBaseCluster;
import org.apache.hadoop.hbase.HBaseClusterInterface;
import org.apache.hadoop.hbase.HBaseClusterManager;
import org.apache.hadoop.hbase.chaos.actions.Action;

public abstract class SudoCommandAction
extends Action {
    protected long timeout;
    protected HBaseClusterManager clusterManager;

    public SudoCommandAction(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        ClusterManager manager;
        super.init(context);
        HBaseClusterInterface cluster = context.getHBaseCluster();
        if (cluster instanceof DistributedHBaseCluster && (manager = ((DistributedHBaseCluster)cluster).getClusterManager()) instanceof HBaseClusterManager) {
            this.clusterManager = (HBaseClusterManager)manager;
        }
    }

    @Override
    public void perform() throws Exception {
        if (this.clusterManager == null) {
            this.getLogger().info("Couldn't perform command action, it requires a distributed cluster.");
            return;
        }
        if (this.context.isStopping()) {
            return;
        }
        this.localPerform();
    }

    protected abstract void localPerform() throws IOException;
}

