/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mob.FaultyMobStoreCompactor;
import org.apache.hadoop.hbase.mob.MobFileCleanerChore;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestMobCompaction
extends IntegrationTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(IntegrationTestMobCompaction.class);
    protected static final String REGIONSERVER_COUNT_KEY = "servers";
    protected static final String ROWS_COUNT_KEY = "rows";
    protected static final String FAILURE_PROB_KEY = "failprob";
    protected static final int DEFAULT_REGIONSERVER_COUNT = 3;
    protected static final int DEFAULT_ROWS_COUNT = 5000000;
    protected static final double DEFAULT_FAILURE_PROB = 0.1;
    protected static int regionServerCount = 3;
    protected static long rowsToLoad = 5000000L;
    protected static double failureProb = 0.1;
    protected static String famStr = "f1";
    protected static byte[] fam = Bytes.toBytes((String)famStr);
    protected static byte[] qualifier = Bytes.toBytes((String)"q1");
    protected static long mobLen = 10L;
    protected static byte[] mobVal = Bytes.toBytes((String)"01234567890123456789012345678901234567890123456789012345678901234567890123456789");
    private static Configuration conf;
    private static TableDescriptor tableDescriptor;
    private static ColumnFamilyDescriptor familyDescriptor;
    private static Admin admin;
    private static Table table;
    private static MobFileCleanerChore chore;
    private static volatile boolean run;

    @Override
    @Before
    public void setUp() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        conf = this.util.getConfiguration();
        IntegrationTestMobCompaction.initConf(conf);
        regionServerCount = conf.getInt(REGIONSERVER_COUNT_KEY, 3);
        LOG.info("Initializing cluster with {} region servers.", (Object)regionServerCount);
        this.util.initializeCluster(regionServerCount);
        admin = this.util.getAdmin();
        this.createTestTable();
        LOG.info("Cluster initialized and ready");
    }

    private void createTestTable() throws IOException {
        familyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])fam).setMobEnabled(true).setMobThreshold(mobLen).setMaxVersions(1).build();
        tableDescriptor = this.util.createModifyableTableDescriptor("testMobCompactTable").setColumnFamily(familyDescriptor).build();
        table = this.util.createTable(tableDescriptor, null);
    }

    @After
    public void tearDown() throws IOException {
        LOG.info("Cleaning up after test.");
        if (this.util.isDistributedCluster()) {
            this.deleteTablesIfAny();
        }
        LOG.info("Restoring cluster.");
        this.util.restoreCluster();
        LOG.info("Cluster restored.");
    }

    @Override
    public void setUpMonkey() throws Exception {
        String msg = "Chaos monkey is not supported";
        LOG.warn(msg);
        throw new IOException(msg);
    }

    private void deleteTablesIfAny() throws IOException {
        if (table != null) {
            this.util.deleteTableIfAny(table.getName());
        }
    }

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        LOG.debug("Initializing/checking cluster has {} servers", (Object)regionServerCount);
        this.util.initializeCluster(regionServerCount);
        LOG.debug("Done initializing/checking cluster");
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        this.testMobCompaction();
        return 0;
    }

    @Override
    public TableName getTablename() {
        return null;
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return null;
    }

    @Override
    protected void addOptions() {
        this.addOptWithArg(REGIONSERVER_COUNT_KEY, "Total number of region servers. Default: '3'");
        this.addOptWithArg(ROWS_COUNT_KEY, "Total number of data rows to load. Default: '5000000'");
        this.addOptWithArg(FAILURE_PROB_KEY, "Probability of a failure of a region MOB compaction request. Default: '0.1'");
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        super.processOptions(cmd);
        regionServerCount = Integer.parseInt(cmd.getOptionValue(REGIONSERVER_COUNT_KEY, Integer.toString(3)));
        rowsToLoad = Long.parseLong(cmd.getOptionValue(ROWS_COUNT_KEY, Long.toString(5000000L)));
        failureProb = Double.parseDouble(cmd.getOptionValue(FAILURE_PROB_KEY, Double.toString(0.1)));
        LOG.info(MoreObjects.toStringHelper((String)"Parsed Options").add(REGIONSERVER_COUNT_KEY, regionServerCount).add(ROWS_COUNT_KEY, rowsToLoad).add(FAILURE_PROB_KEY, failureProb).toString());
    }

    private static void initConf(Configuration conf) {
        conf.setInt("hfile.format.version", 3);
        conf.setLong("hbase.master.hfilecleaner.ttl", 0L);
        conf.setInt("hbase.client.retries.number", 100);
        conf.setInt("hbase.hregion.max.filesize", 200000000);
        conf.setInt("hbase.hregion.memstore.flush.size", 800000);
        conf.setInt("hbase.hstore.blockingStoreFiles", 150);
        conf.setInt("hbase.hstore.compaction.throughput.lower.bound", 0x3200000);
        conf.setInt("hbase.hstore.compaction.throughput.higher.bound", 0x6400000);
        conf.setDouble("hbase.mob.compaction.fault.probability", failureProb);
        conf.set("hbase.hstore.mobengine.compactor.class", FaultyMobStoreCompactor.class.getName());
        conf.setBoolean("hbase.table.sanity.checks", false);
        conf.setLong("hbase.mob.min.age.archive", 20000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMobCompaction() throws InterruptedException, IOException {
        try {
            Thread writeData = new Thread(new WriteData(rowsToLoad));
            writeData.start();
            Thread majorcompact = new Thread(new MajorCompaction());
            majorcompact.start();
            Thread cleaner = new Thread(new CleanMobAndArchive());
            cleaner.start();
            while (run) {
                Thread.sleep(1000L);
            }
            this.getNumberOfMobFiles(conf, table.getName(), new String(fam, StandardCharsets.UTF_8));
            LOG.info("Waiting for write thread to finish ...");
            writeData.join();
            chore.cleanupObsoleteMobFiles(conf, table.getName());
            if (this.util != null) {
                LOG.info("Archive cleaner started ...");
                this.util.getMiniHBaseCluster().getMaster().getHFileCleaner().choreForTesting();
                LOG.info("Archive cleaner finished");
            }
            this.scanTable();
        }
        finally {
            admin.disableTable(tableDescriptor.getTableName());
            admin.deleteTable(tableDescriptor.getTableName());
        }
        LOG.info("MOB Stress Test finished OK");
        this.printStats(rowsToLoad);
    }

    private long getNumberOfMobFiles(Configuration conf, TableName tableName, String family) throws IOException {
        FileStatus[] stat;
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path dir = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)tableName, (String)family);
        for (FileStatus st : stat = fs.listStatus(dir)) {
            LOG.debug("MOB Directory content: {}", (Object)st.getPath());
        }
        LOG.debug("MOB Directory content total files: {}", (Object)stat.length);
        return stat.length;
    }

    public void printStats(long loaded) {
        LOG.info("MOB Stress Test: loaded=" + loaded + " compactions=" + FaultyMobStoreCompactor.totalCompactions.get() + " major=" + FaultyMobStoreCompactor.totalMajorCompactions.get() + " mob=" + FaultyMobStoreCompactor.mobCounter.get() + " injected failures=" + FaultyMobStoreCompactor.totalFailures.get());
    }

    private void scanTable() {
        try {
            Result result;
            ResultScanner scanner = table.getScanner(fam);
            int counter = 0;
            while ((result = scanner.next()) != null) {
                Assert.assertTrue((boolean)Arrays.equals(result.getValue(fam, qualifier), mobVal));
                if (counter % 10000 == 0) {
                    LOG.info("GET=" + counter);
                }
                ++counter;
            }
            Assert.assertEquals((long)rowsToLoad, (long)counter);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("MOB Stress Test FAILED");
            if (this.util != null) {
                Assert.assertTrue((boolean)false);
            }
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestMobCompaction.initConf(conf);
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int status = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestMobCompaction(), (String[])args);
        System.exit(status);
    }

    static {
        table = null;
        run = true;
    }

    class WriteData
    implements Runnable {
        private long rows = -1L;

        public WriteData(long rows) {
            this.rows = rows;
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while ((long)i < this.rows) {
                    Put p = new Put(Bytes.toBytes((int)i));
                    p.addColumn(fam, qualifier, mobVal);
                    table.put(p);
                    if (i % 10000 == 0) {
                        LOG.info("LOADED=" + i);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ee) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (i % 100000 == 0) {
                        IntegrationTestMobCompaction.this.printStats(i);
                    }
                    ++i;
                }
                admin.flush(table.getName());
                run = false;
            }
            catch (Exception e) {
                LOG.error("MOB Stress Test FAILED", (Throwable)e);
                System.exit(-1);
            }
        }
    }

    static class CleanMobAndArchive
    implements Runnable {
        CleanMobAndArchive() {
        }

        @Override
        public void run() {
            while (run) {
                try {
                    LOG.info("MOB cleanup chore started ...");
                    if (chore == null) {
                        chore = new MobFileCleanerChore();
                    }
                    chore.cleanupObsoleteMobFiles(conf, table.getName());
                    LOG.info("MOB cleanup chore finished");
                    Thread.sleep(130000L);
                }
                catch (Exception e) {
                    LOG.warn("Exception in CleanMobAndArchive", (Throwable)e);
                }
            }
        }
    }

    static class MajorCompaction
    implements Runnable {
        MajorCompaction() {
        }

        @Override
        public void run() {
            while (run) {
                try {
                    admin.majorCompact(tableDescriptor.getTableName(), fam);
                    Thread.sleep(120000L);
                }
                catch (Exception e) {
                    LOG.error("MOB Stress Test FAILED", (Throwable)e);
                    System.exit(-1);
                }
            }
        }
    }
}

