/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.IntegrationTestIngest;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.StripeStoreEngine;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestIngestStripeCompactions
extends IntegrationTestIngest {
    @Override
    protected void initTable() throws IOException {
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)this.getTablename()).setValue("hbase.hstore.engine.class", StripeStoreEngine.class.getName()).setValue("hbase.hstore.blockingStoreFiles", "100").build();
        ColumnFamilyDescriptor familyDescriptor = ColumnFamilyDescriptorBuilder.of((byte[])HFileTestUtil.DEFAULT_COLUMN_FAMILY);
        HBaseTestingUtil.createPreSplitLoadTestTable((Configuration)this.util.getConfiguration(), (TableDescriptor)tableDescriptor, (ColumnFamilyDescriptor)familyDescriptor);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestIngestStripeCompactions(), (String[])args);
        System.exit(ret);
    }
}

