/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import java.util.Arrays;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.RawBytes;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MiscTests.class, SmallTests.class})
public class TestRawBytes {
    private static final byte[][] VALUES = new byte[][]{Bytes.toBytes((String)""), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"22"), Bytes.toBytes((String)"333"), Bytes.toBytes((String)"4444"), Bytes.toBytes((String)"55555"), Bytes.toBytes((String)"666666"), Bytes.toBytes((String)"7777777"), Bytes.toBytes((String)"88888888"), Bytes.toBytes((String)"999999999")};
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRawBytes.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testIsOrderPreservingIsTrue() {
        RawBytes type = new RawBytes(Order.ASCENDING);
        Assert.assertTrue((boolean)type.isOrderPreserving());
    }

    @Test
    public void testGetOrderCorrectOrder() {
        RawBytes type = new RawBytes(Order.ASCENDING);
        Assert.assertEquals((Object)Order.ASCENDING, (Object)type.getOrder());
    }

    @Test
    public void testIsNullableIsFalse() {
        RawBytes type = new RawBytes(Order.ASCENDING);
        Assert.assertFalse((boolean)type.isNullable());
    }

    @Test
    public void testIsSkippableIsFalse() {
        RawBytes type = new RawBytes(Order.ASCENDING);
        Assert.assertFalse((boolean)type.isSkippable());
    }

    @Test
    public void testEncodedClassIsByteArray() {
        RawBytes type = new RawBytes(Order.ASCENDING);
        Assert.assertEquals(byte[].class, (Object)type.encodedClass());
    }

    @Test
    public void testEncodedLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (RawBytes type : new RawBytes[]{new RawBytes(Order.ASCENDING), new RawBytes(Order.DESCENDING)}) {
            for (byte[] val : VALUES) {
                buffer.setPosition(0);
                type.encode((PositionedByteRange)buffer, (Object)val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + Arrays.toString(val)), (long)buffer.getPosition(), (long)type.encodedLength((Object)val));
            }
        }
    }
}

