/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.OrderedString;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestOrderedString {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOrderedString.class);
    private static final String[] VALUES = new String[]{null, "", "1", "22", "333", "4444", "55555", "666666", "7777777", "88888888", "999999999"};

    @Test
    public void testEncodedLength() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(20);
        for (OrderedString type : new OrderedString[]{new OrderedString(Order.ASCENDING), new OrderedString(Order.DESCENDING)}) {
            for (String val : VALUES) {
                buff.setPosition(0);
                type.encode((PositionedByteRange)buff, (Object)val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buff.getPosition(), (long)type.encodedLength((Object)val));
            }
        }
    }

    @Test
    public void testEncodedClassIsFloat() {
        OrderedString type = new OrderedString(Order.ASCENDING);
        Assert.assertEquals(String.class, (Object)type.encodedClass());
    }
}

