/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.OrderedNumeric;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MiscTests.class, SmallTests.class})
public class TestOrderedNumeric {
    private static final Long[] LONG_VALUES = new Long[]{1L, 22L, 333L, 4444L, 55555L, 666666L, 7777777L, 88888888L, 999999999L};
    private static final Double[] DOUBLE_VALUES = new Double[]{Double.NaN, 1.1, 22.2, 333.3, 4444.4, 55555.5, 666666.6, 7777777.7, 8.88888888E7, 9.999999999E8};
    private static final BigDecimal[] BIG_DECIMAL_VALUES = new BigDecimal[]{new BigDecimal(1), new BigDecimal(22), new BigDecimal(333), new BigDecimal(4444), new BigDecimal(55555), new BigDecimal(666666), new BigDecimal(7777777), new BigDecimal(88888888), new BigDecimal(999999999)};
    private static final BigInteger[] BIG_INTEGER_VALUES = new BigInteger[]{new BigInteger("1"), new BigInteger("22"), new BigInteger("333"), new BigInteger("4444"), new BigInteger("55555"), new BigInteger("666666"), new BigInteger("7777777"), new BigInteger("88888888"), new BigInteger("999999999")};
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOrderedNumeric.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testEncodedClassIsNumber() {
        OrderedNumeric type = new OrderedNumeric(Order.ASCENDING);
        Assert.assertEquals(Number.class, (Object)type.encodedClass());
    }

    @Test
    public void testEncodedLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedNumeric type : new OrderedNumeric[]{new OrderedNumeric(Order.ASCENDING), new OrderedNumeric(Order.DESCENDING)}) {
            for (Double val : DOUBLE_VALUES) {
                buffer.setPosition(0);
                type.encode((PositionedByteRange)buffer, (Object)val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength((Object)val));
            }
        }
    }

    @Test
    public void testEncodedBigDecimalLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedNumeric type : new OrderedNumeric[]{new OrderedNumeric(Order.ASCENDING), new OrderedNumeric(Order.DESCENDING)}) {
            for (BigDecimal val : BIG_DECIMAL_VALUES) {
                buffer.setPosition(0);
                type.encode((PositionedByteRange)buffer, (Object)val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength((Object)val));
            }
        }
    }

    @Test
    public void testEncodedBigIntegerLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedNumeric type : new OrderedNumeric[]{new OrderedNumeric(Order.ASCENDING), new OrderedNumeric(Order.DESCENDING)}) {
            for (BigInteger val : BIG_INTEGER_VALUES) {
                buffer.setPosition(0);
                type.encode((PositionedByteRange)buffer, (Object)val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength((Object)val));
            }
        }
    }

    @Test
    public void testEncodedNullLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        OrderedNumeric type = new OrderedNumeric(Order.ASCENDING);
        buffer.setPosition(0);
        type.encode((PositionedByteRange)buffer, null);
        type.encode((PositionedByteRange)new SimplePositionedMutableByteRange(20), null);
        Assert.assertEquals((String)("encodedLength does not match actual, " + null), (long)buffer.getPosition(), (long)type.encodedLength(null));
    }

    @Test
    public void testEncodedLongLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedNumeric type : new OrderedNumeric[]{new OrderedNumeric(Order.ASCENDING), new OrderedNumeric(Order.DESCENDING)}) {
            for (Long val : LONG_VALUES) {
                buffer.setPosition(0);
                type.encodeLong((PositionedByteRange)buffer, val.longValue());
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength((Number)val));
            }
        }
    }

    @Test
    public void testEncodedDoubleLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedNumeric type : new OrderedNumeric[]{new OrderedNumeric(Order.ASCENDING), new OrderedNumeric(Order.DESCENDING)}) {
            for (Double val : DOUBLE_VALUES) {
                buffer.setPosition(0);
                type.encodeDouble((PositionedByteRange)buffer, val.doubleValue());
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength((Number)val));
            }
        }
    }
}

