/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.exceptions.KeyManagerException;
import org.apache.hadoop.hbase.exceptions.SSLContextException;
import org.apache.hadoop.hbase.exceptions.TrustManagerException;
import org.apache.hadoop.hbase.io.crypto.tls.AbstractTestX509Parameterized;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hadoop.hbase.io.crypto.tls.X509Util;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, SmallTests.class})
public class TestX509Util
extends AbstractTestX509Parameterized {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestX509Util.class);
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];

    @Test
    public void testCreateSSLContextWithClientAuthDefault() throws Exception {
        SslContext sslContext = X509Util.createSslContextForServer((Configuration)conf);
        ByteBufAllocator byteBufAllocatorMock = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        Assert.assertTrue((boolean)sslContext.newEngine(byteBufAllocatorMock).getNeedClientAuth());
    }

    @Test
    public void testCreateSSLContextWithClientAuthNEED() throws Exception {
        conf.set("hbase.server.netty.tls.client.auth.mode", X509Util.ClientAuth.NEED.name());
        SslContext sslContext = X509Util.createSslContextForServer((Configuration)conf);
        ByteBufAllocator byteBufAllocatorMock = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        Assert.assertTrue((boolean)sslContext.newEngine(byteBufAllocatorMock).getNeedClientAuth());
    }

    @Test
    public void testCreateSSLContextWithClientAuthWANT() throws Exception {
        conf.set("hbase.server.netty.tls.client.auth.mode", X509Util.ClientAuth.WANT.name());
        SslContext sslContext = X509Util.createSslContextForServer((Configuration)conf);
        ByteBufAllocator byteBufAllocatorMock = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        Assert.assertTrue((boolean)sslContext.newEngine(byteBufAllocatorMock).getWantClientAuth());
    }

    @Test
    public void testCreateSSLContextWithClientAuthNONE() throws Exception {
        conf.set("hbase.server.netty.tls.client.auth.mode", X509Util.ClientAuth.NONE.name());
        SslContext sslContext = X509Util.createSslContextForServer((Configuration)conf);
        ByteBufAllocator byteBufAllocatorMock = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        Assert.assertFalse((boolean)sslContext.newEngine(byteBufAllocatorMock).getNeedClientAuth());
        Assert.assertFalse((boolean)sslContext.newEngine(byteBufAllocatorMock).getWantClientAuth());
    }

    @Test
    public void testCreateSSLContextWithoutCustomProtocol() throws Exception {
        SslContext sslContext = X509Util.createSslContextForClient((Configuration)conf);
        ByteBufAllocator byteBufAllocatorMock = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        Assert.assertArrayEquals((Object[])new String[]{"TLSv1.2"}, (Object[])sslContext.newEngine(byteBufAllocatorMock).getEnabledProtocols());
    }

    @Test
    public void testCreateSSLContextWithCustomProtocol() throws Exception {
        String protocol = "TLSv1.1";
        conf.set("hbase.rpc.tls.protocol", "TLSv1.1");
        ByteBufAllocator byteBufAllocatorMock = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        SslContext sslContext = X509Util.createSslContextForServer((Configuration)conf);
        Assert.assertEquals(Collections.singletonList("TLSv1.1"), Arrays.asList(sslContext.newEngine(byteBufAllocatorMock).getEnabledProtocols()));
    }

    @Test(expected=SSLContextException.class)
    public void testCreateSSLContextWithoutKeyStoreLocationServer() throws Exception {
        conf.unset("hbase.rpc.tls.keystore.location");
        X509Util.createSslContextForServer((Configuration)conf);
    }

    @Test
    public void testCreateSSLContextWithoutKeyStoreLocationClient() throws Exception {
        conf.unset("hbase.rpc.tls.keystore.location");
        X509Util.createSslContextForClient((Configuration)conf);
    }

    @Test
    public void testCreateSSLContextWithoutTrustStoreLocationClient() throws Exception {
        conf.unset("hbase.rpc.tls.truststore.location");
        X509Util.createSslContextForClient((Configuration)conf);
    }

    @Test
    public void testCreateSSLContextWithoutTrustStoreLocationServer() throws Exception {
        conf.unset("hbase.rpc.tls.truststore.location");
        X509Util.createSslContextForServer((Configuration)conf);
    }

    @Test
    public void testCRLEnabled() throws Exception {
        conf.setBoolean("hbase.rpc.tls.clr", true);
        X509Util.createSslContextForServer((Configuration)conf);
        Assert.assertTrue((boolean)Boolean.valueOf(System.getProperty("com.sun.net.ssl.checkRevocation")));
        Assert.assertTrue((boolean)Boolean.valueOf(System.getProperty("com.sun.security.enableCRLDP")));
        Assert.assertFalse((boolean)Boolean.valueOf(Security.getProperty("ocsp.enable")));
    }

    @Test
    public void testCRLDisabled() throws Exception {
        X509Util.createSslContextForServer((Configuration)conf);
        Assert.assertFalse((boolean)Boolean.valueOf(System.getProperty("com.sun.net.ssl.checkRevocation")));
        Assert.assertFalse((boolean)Boolean.valueOf(System.getProperty("com.sun.security.enableCRLDP")));
        Assert.assertFalse((boolean)Boolean.valueOf(Security.getProperty("ocsp.enable")));
    }

    @Test
    public void testLoadPEMKeyStore() throws Exception {
        X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), (char[])this.x509TestContext.getKeyStorePassword(), (String)KeyStoreFileType.PEM.getPropertyValue());
    }

    @Test
    public void testLoadPEMKeyStoreNullPassword() throws Exception {
        Assume.assumeThat((Object)this.x509TestContext.getKeyStorePassword(), (Matcher)Matchers.equalTo((Object)EMPTY_CHAR_ARRAY));
        X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), null, (String)KeyStoreFileType.PEM.getPropertyValue());
    }

    @Test
    public void testLoadPEMKeyStoreAutodetectStoreFileType() throws Exception {
        X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), (char[])this.x509TestContext.getKeyStorePassword(), null);
    }

    @Test(expected=KeyManagerException.class)
    public void testLoadPEMKeyStoreWithWrongPassword() throws Exception {
        X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), (char[])"wrong password".toCharArray(), (String)KeyStoreFileType.PEM.getPropertyValue());
    }

    @Test
    public void testLoadPEMTrustStore() throws Exception {
        X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), (char[])this.x509TestContext.getTrustStorePassword(), (String)KeyStoreFileType.PEM.getPropertyValue(), (boolean)false, (boolean)false, (boolean)true, (boolean)true);
    }

    @Test
    public void testLoadPEMTrustStoreNullPassword() throws Exception {
        Assume.assumeThat((Object)this.x509TestContext.getTrustStorePassword(), (Matcher)Matchers.equalTo((Object)EMPTY_CHAR_ARRAY));
        X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), null, (String)KeyStoreFileType.PEM.getPropertyValue(), (boolean)false, (boolean)false, (boolean)true, (boolean)true);
    }

    @Test
    public void testLoadPEMTrustStoreAutodetectStoreFileType() throws Exception {
        X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), (char[])this.x509TestContext.getTrustStorePassword(), null, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
    }

    @Test
    public void testLoadJKSKeyStore() throws Exception {
        X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (char[])this.x509TestContext.getKeyStorePassword(), (String)KeyStoreFileType.JKS.getPropertyValue());
    }

    @Test
    public void testLoadJKSKeyStoreNullPassword() throws Exception {
        Assume.assumeThat((Object)this.x509TestContext.getKeyStorePassword(), (Matcher)Matchers.equalTo((Object)EMPTY_CHAR_ARRAY));
        X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), null, (String)KeyStoreFileType.JKS.getPropertyValue());
    }

    @Test
    public void testLoadJKSKeyStoreAutodetectStoreFileType() throws Exception {
        X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (char[])this.x509TestContext.getKeyStorePassword(), null);
    }

    @Test
    public void testLoadJKSKeyStoreWithWrongPassword() {
        Assert.assertThrows(KeyManagerException.class, () -> X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (char[])"wrong password".toCharArray(), (String)KeyStoreFileType.JKS.getPropertyValue()));
    }

    @Test
    public void testLoadJKSTrustStore() throws Exception {
        X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (char[])this.x509TestContext.getTrustStorePassword(), (String)KeyStoreFileType.JKS.getPropertyValue(), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    @Test
    public void testLoadJKSTrustStoreNullPassword() throws Exception {
        Assume.assumeThat((Object)this.x509TestContext.getTrustStorePassword(), (Matcher)Matchers.equalTo((Object)EMPTY_CHAR_ARRAY));
        X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), null, (String)KeyStoreFileType.JKS.getPropertyValue(), (boolean)false, (boolean)false, (boolean)true, (boolean)true);
    }

    @Test
    public void testLoadJKSTrustStoreAutodetectStoreFileType() throws Exception {
        X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (char[])this.x509TestContext.getTrustStorePassword(), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    @Test
    public void testLoadJKSTrustStoreWithWrongPassword() {
        Assert.assertThrows(TrustManagerException.class, () -> X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (char[])"wrong password".toCharArray(), (String)KeyStoreFileType.JKS.getPropertyValue(), (boolean)true, (boolean)true, (boolean)true, (boolean)true));
    }

    @Test
    public void testLoadPKCS12KeyStore() throws Exception {
        X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (char[])this.x509TestContext.getKeyStorePassword(), (String)KeyStoreFileType.PKCS12.getPropertyValue());
    }

    @Test
    public void testLoadPKCS12KeyStoreNullPassword() throws Exception {
        Assume.assumeThat((Object)this.x509TestContext.getKeyStorePassword(), (Matcher)Matchers.equalTo((Object)EMPTY_CHAR_ARRAY));
        X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), null, (String)KeyStoreFileType.PKCS12.getPropertyValue());
    }

    @Test
    public void testLoadPKCS12KeyStoreAutodetectStoreFileType() throws Exception {
        X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (char[])this.x509TestContext.getKeyStorePassword(), null);
    }

    @Test
    public void testLoadPKCS12KeyStoreWithWrongPassword() {
        Assert.assertThrows(KeyManagerException.class, () -> X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (char[])"wrong password".toCharArray(), (String)KeyStoreFileType.PKCS12.getPropertyValue()));
    }

    @Test
    public void testLoadPKCS12TrustStore() throws Exception {
        X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (char[])this.x509TestContext.getTrustStorePassword(), (String)KeyStoreFileType.PKCS12.getPropertyValue(), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    @Test
    public void testLoadPKCS12TrustStoreNullPassword() throws Exception {
        Assume.assumeThat((Object)this.x509TestContext.getTrustStorePassword(), (Matcher)Matchers.equalTo((Object)EMPTY_CHAR_ARRAY));
        X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), null, (String)KeyStoreFileType.PKCS12.getPropertyValue(), (boolean)false, (boolean)false, (boolean)true, (boolean)true);
    }

    @Test
    public void testLoadPKCS12TrustStoreAutodetectStoreFileType() throws Exception {
        X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (char[])this.x509TestContext.getTrustStorePassword(), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    @Test
    public void testLoadPKCS12TrustStoreWithWrongPassword() {
        Assert.assertThrows(TrustManagerException.class, () -> X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (char[])"wrong password".toCharArray(), (String)KeyStoreFileType.PKCS12.getPropertyValue(), (boolean)true, (boolean)true, (boolean)true, (boolean)true));
    }

    @Test
    public void testGetDefaultCipherSuitesJava8() {
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion((String)"1.8");
        MatcherAssert.assertThat((Object)cipherSuites[0], (Matcher)Matchers.containsString((String)"CBC"));
    }

    @Test
    public void testGetDefaultCipherSuitesJava9() {
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion((String)"9");
        MatcherAssert.assertThat((Object)cipherSuites[0], (Matcher)Matchers.containsString((String)"GCM"));
    }

    @Test
    public void testGetDefaultCipherSuitesJava10() {
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion((String)"10");
        MatcherAssert.assertThat((Object)cipherSuites[0], (Matcher)Matchers.containsString((String)"GCM"));
    }

    @Test
    public void testGetDefaultCipherSuitesJava11() {
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion((String)"11");
        MatcherAssert.assertThat((Object)cipherSuites[0], (Matcher)Matchers.containsString((String)"GCM"));
    }

    @Test
    public void testGetDefaultCipherSuitesUnknownVersion() {
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion((String)"notaversion");
        MatcherAssert.assertThat((Object)cipherSuites[0], (Matcher)Matchers.containsString((String)"CBC"));
    }

    @Test
    public void testGetDefaultCipherSuitesNullVersion() {
        Assert.assertThrows(NullPointerException.class, () -> X509Util.getDefaultCipherSuitesForJavaVersion(null));
    }
}

