/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hadoop.hbase.io.crypto.tls.TestX509Util;
import org.apache.hadoop.hbase.io.crypto.tls.X509KeyType;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContext;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContextProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runners.Parameterized;

public abstract class AbstractTestX509Parameterized {
    private static final HBaseCommonTestingUtil UTIL = new HBaseCommonTestingUtil();
    private static X509TestContextProvider PROVIDER;
    @Parameterized.Parameter
    public X509KeyType caKeyType;
    @Parameterized.Parameter(value=1)
    public X509KeyType certKeyType;
    @Parameterized.Parameter(value=2)
    public char[] keyPassword;
    @Parameterized.Parameter(value=3)
    public Integer paramIndex;
    protected static Configuration conf;
    protected X509TestContext x509TestContext;

    @Parameterized.Parameters(name="{index}: caKeyType={0}, certKeyType={1}, keyPassword={2}, paramIndex={3}")
    public static Collection<Object[]> defaultParams() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int paramIndex = 0;
        for (X509KeyType caKeyType : X509KeyType.values()) {
            for (X509KeyType certKeyType : X509KeyType.values()) {
                for (char[] keyPassword : new char[][]{"".toCharArray(), "pa$$w0rd".toCharArray()}) {
                    result.add(new Object[]{caKeyType, certKeyType, keyPassword, paramIndex++});
                }
            }
        }
        return result;
    }

    @BeforeClass
    public static void setUpBaseClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        File dir = new File(UTIL.getDataTestDir(TestX509Util.class.getSimpleName()).toString()).getCanonicalFile();
        FileUtils.forceMkdir((File)dir);
        PROVIDER = new X509TestContextProvider(UTIL.getConfiguration(), dir);
    }

    @AfterClass
    public static void cleanUpBaseClass() {
        Security.removeProvider("BC");
        UTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws IOException {
        this.x509TestContext = PROVIDER.get(this.caKeyType, this.certKeyType, this.keyPassword);
        this.x509TestContext.setConfigurations(KeyStoreFileType.JKS, KeyStoreFileType.JKS);
        conf = new Configuration(UTIL.getConfiguration());
    }

    @After
    public void cleanUp() {
        this.x509TestContext.clearConfigurations();
        this.x509TestContext.getConf().unset("hbase.rpc.tls.ocsp");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.clr");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.protocol");
        System.clearProperty("com.sun.net.ssl.checkRevocation");
        System.clearProperty("com.sun.security.enableCRLDP");
        Security.setProperty("ocsp.enable", Boolean.FALSE.toString());
        Security.setProperty("com.sun.security.enableCRLDP", Boolean.FALSE.toString());
    }
}

