/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.DNS;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHDFSBlocksDistribution {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHDFSBlocksDistribution.class);

    @Test
    public void testAddHostsAndBlockWeight() throws Exception {
        HDFSBlocksDistribution distribution = new HDFSBlocksDistribution();
        distribution.addHostsAndBlockWeight(null, 100L);
        Assert.assertEquals((String)"Expecting no hosts weights", (long)0L, (long)distribution.getHostAndWeights().size());
        distribution.addHostsAndBlockWeight(new String[0], 100L);
        Assert.assertEquals((String)"Expecting no hosts weights", (long)0L, (long)distribution.getHostAndWeights().size());
        distribution.addHostsAndBlockWeight(new String[]{"test"}, 101L);
        Assert.assertEquals((String)"Should be one host", (long)1L, (long)distribution.getHostAndWeights().size());
        distribution.addHostsAndBlockWeight(new String[]{"test"}, 202L);
        Assert.assertEquals((String)"Should be one host", (long)1L, (long)distribution.getHostAndWeights().size());
        Assert.assertEquals((String)"test host should have weight 303", (long)303L, (long)((HDFSBlocksDistribution.HostAndWeight)distribution.getHostAndWeights().get("test")).getWeight());
        distribution.addHostsAndBlockWeight(new String[]{"testTwo"}, 222L);
        Assert.assertEquals((String)"Should be two hosts", (long)2L, (long)distribution.getHostAndWeights().size());
        Assert.assertEquals((String)"Total weight should be 525", (long)525L, (long)distribution.getUniqueBlocksTotalWeight());
        distribution.addHostsAndBlockWeight(new String[]{"test"}, 100L, new StorageType[]{StorageType.SSD});
        Assert.assertEquals((String)"test host should have weight 403", (long)403L, (long)((HDFSBlocksDistribution.HostAndWeight)distribution.getHostAndWeights().get("test")).getWeight());
        Assert.assertEquals((String)"test host should have weight for ssd 100", (long)100L, (long)((HDFSBlocksDistribution.HostAndWeight)distribution.getHostAndWeights().get("test")).getWeightForSsd());
    }

    @Test
    public void testAdd() throws Exception {
        HDFSBlocksDistribution distribution = new HDFSBlocksDistribution();
        distribution.add((HDFSBlocksDistribution)new MockHDFSBlocksDistribution());
        Assert.assertEquals((String)"Expecting no hosts weights", (long)0L, (long)distribution.getHostAndWeights().size());
        distribution.addHostsAndBlockWeight(new String[]{"test"}, 10L);
        Assert.assertEquals((String)"Should be one host", (long)1L, (long)distribution.getHostAndWeights().size());
        distribution.add((HDFSBlocksDistribution)new MockHDFSBlocksDistribution());
        Assert.assertEquals((String)"Should be one host", (long)1L, (long)distribution.getHostAndWeights().size());
        Assert.assertEquals((String)"Total weight should be 10", (long)10L, (long)distribution.getUniqueBlocksTotalWeight());
    }

    @Test
    public void testLocalHostCompatibility() throws Exception {
        String currentHost = DNS.getDefaultHost((String)"default", (String)"default");
        HDFSBlocksDistribution distribution = new HDFSBlocksDistribution();
        Assert.assertEquals((String)"Locality should be 0.0", (double)0.0, (double)distribution.getBlockLocalityIndex(currentHost), (double)0.01);
        distribution.addHostsAndBlockWeight(new String[]{"localhost"}, 10L);
        Assert.assertEquals((String)"Should be one host", (long)1L, (long)distribution.getHostAndWeights().size());
        Assert.assertEquals((String)"Locality should be 0.0", (double)0.0, (double)distribution.getBlockLocalityIndex("test"), (double)0.01);
        Assert.assertNotEquals((String)"Locality should be 0.0", (double)0.0, (double)distribution.getBlockLocalityIndex(currentHost), (double)0.01);
    }

    private static final class MockHDFSBlocksDistribution
    extends HDFSBlocksDistribution {
        private MockHDFSBlocksDistribution() {
        }

        public Map<String, HDFSBlocksDistribution.HostAndWeight> getHostAndWeights() {
            HashMap<String, HDFSBlocksDistribution.HostAndWeight> map = new HashMap<String, HDFSBlocksDistribution.HostAndWeight>();
            map.put("test", new HDFSBlocksDistribution.HostAndWeight(null, 100L, 0L));
            return map;
        }
    }
}

