/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.thrift.generated.TPermissionScope;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TAccessControlEntity
implements TBase<TAccessControlEntity, _Fields>,
Serializable,
Cloneable,
Comparable<TAccessControlEntity> {
    private static final TStruct STRUCT_DESC = new TStruct("TAccessControlEntity");
    private static final TField USERNAME_FIELD_DESC = new TField("username", 11, 1);
    private static final TField SCOPE_FIELD_DESC = new TField("scope", 8, 2);
    private static final TField ACTIONS_FIELD_DESC = new TField("actions", 11, 4);
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 5);
    private static final TField NS_NAME_FIELD_DESC = new TField("nsName", 11, 6);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TAccessControlEntityStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TAccessControlEntityTupleSchemeFactory();
    @Nullable
    public String username;
    @Nullable
    public TPermissionScope scope;
    @Nullable
    public String actions;
    @Nullable
    public ByteBuffer tableName;
    @Nullable
    public String nsName;
    private static final _Fields[] optionals = new _Fields[]{_Fields.TABLE_NAME, _Fields.NS_NAME};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TAccessControlEntity() {
    }

    public TAccessControlEntity(String username, TPermissionScope scope, String actions) {
        this();
        this.username = username;
        this.scope = scope;
        this.actions = actions;
    }

    public TAccessControlEntity(TAccessControlEntity other) {
        if (other.isSetUsername()) {
            this.username = other.username;
        }
        if (other.isSetScope()) {
            this.scope = other.scope;
        }
        if (other.isSetActions()) {
            this.actions = other.actions;
        }
        if (other.isSetTableName()) {
            this.tableName = TBaseHelper.copyBinary((ByteBuffer)other.tableName);
        }
        if (other.isSetNsName()) {
            this.nsName = other.nsName;
        }
    }

    public TAccessControlEntity deepCopy() {
        return new TAccessControlEntity(this);
    }

    public void clear() {
        this.username = null;
        this.scope = null;
        this.actions = null;
        this.tableName = null;
        this.nsName = null;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public TAccessControlEntity setUsername(@Nullable String username) {
        this.username = username;
        return this;
    }

    public void unsetUsername() {
        this.username = null;
    }

    public boolean isSetUsername() {
        return this.username != null;
    }

    public void setUsernameIsSet(boolean value) {
        if (!value) {
            this.username = null;
        }
    }

    @Nullable
    public TPermissionScope getScope() {
        return this.scope;
    }

    public TAccessControlEntity setScope(@Nullable TPermissionScope scope) {
        this.scope = scope;
        return this;
    }

    public void unsetScope() {
        this.scope = null;
    }

    public boolean isSetScope() {
        return this.scope != null;
    }

    public void setScopeIsSet(boolean value) {
        if (!value) {
            this.scope = null;
        }
    }

    @Nullable
    public String getActions() {
        return this.actions;
    }

    public TAccessControlEntity setActions(@Nullable String actions) {
        this.actions = actions;
        return this;
    }

    public void unsetActions() {
        this.actions = null;
    }

    public boolean isSetActions() {
        return this.actions != null;
    }

    public void setActionsIsSet(boolean value) {
        if (!value) {
            this.actions = null;
        }
    }

    public byte[] getTableName() {
        this.setTableName(TBaseHelper.rightSize((ByteBuffer)this.tableName));
        return this.tableName == null ? null : this.tableName.array();
    }

    public ByteBuffer bufferForTableName() {
        return TBaseHelper.copyBinary((ByteBuffer)this.tableName);
    }

    public TAccessControlEntity setTableName(byte[] tableName) {
        this.tableName = tableName == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])tableName.clone());
        return this;
    }

    public TAccessControlEntity setTableName(@Nullable ByteBuffer tableName) {
        this.tableName = TBaseHelper.copyBinary((ByteBuffer)tableName);
        return this;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    @Nullable
    public String getNsName() {
        return this.nsName;
    }

    public TAccessControlEntity setNsName(@Nullable String nsName) {
        this.nsName = nsName;
        return this;
    }

    public void unsetNsName() {
        this.nsName = null;
    }

    public boolean isSetNsName() {
        return this.nsName != null;
    }

    public void setNsNameIsSet(boolean value) {
        if (!value) {
            this.nsName = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case USERNAME: {
                if (value == null) {
                    this.unsetUsername();
                    break;
                }
                this.setUsername((String)value);
                break;
            }
            case SCOPE: {
                if (value == null) {
                    this.unsetScope();
                    break;
                }
                this.setScope((TPermissionScope)((Object)value));
                break;
            }
            case ACTIONS: {
                if (value == null) {
                    this.unsetActions();
                    break;
                }
                this.setActions((String)value);
                break;
            }
            case TABLE_NAME: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setTableName((byte[])value);
                    break;
                }
                this.setTableName((ByteBuffer)value);
                break;
            }
            case NS_NAME: {
                if (value == null) {
                    this.unsetNsName();
                    break;
                }
                this.setNsName((String)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case USERNAME: {
                return this.getUsername();
            }
            case SCOPE: {
                return this.getScope();
            }
            case ACTIONS: {
                return this.getActions();
            }
            case TABLE_NAME: {
                return this.getTableName();
            }
            case NS_NAME: {
                return this.getNsName();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case USERNAME: {
                return this.isSetUsername();
            }
            case SCOPE: {
                return this.isSetScope();
            }
            case ACTIONS: {
                return this.isSetActions();
            }
            case TABLE_NAME: {
                return this.isSetTableName();
            }
            case NS_NAME: {
                return this.isSetNsName();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TAccessControlEntity) {
            return this.equals((TAccessControlEntity)that);
        }
        return false;
    }

    public boolean equals(TAccessControlEntity that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_username = this.isSetUsername();
        boolean that_present_username = that.isSetUsername();
        if (this_present_username || that_present_username) {
            if (!this_present_username || !that_present_username) {
                return false;
            }
            if (!this.username.equals(that.username)) {
                return false;
            }
        }
        boolean this_present_scope = this.isSetScope();
        boolean that_present_scope = that.isSetScope();
        if (this_present_scope || that_present_scope) {
            if (!this_present_scope || !that_present_scope) {
                return false;
            }
            if (!this.scope.equals((Object)that.scope)) {
                return false;
            }
        }
        boolean this_present_actions = this.isSetActions();
        boolean that_present_actions = that.isSetActions();
        if (this_present_actions || that_present_actions) {
            if (!this_present_actions || !that_present_actions) {
                return false;
            }
            if (!this.actions.equals(that.actions)) {
                return false;
            }
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_nsName = this.isSetNsName();
        boolean that_present_nsName = that.isSetNsName();
        if (this_present_nsName || that_present_nsName) {
            if (!this_present_nsName || !that_present_nsName) {
                return false;
            }
            if (!this.nsName.equals(that.nsName)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetUsername() ? 131071 : 524287);
        if (this.isSetUsername()) {
            hashCode = hashCode * 8191 + this.username.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetScope() ? 131071 : 524287);
        if (this.isSetScope()) {
            hashCode = hashCode * 8191 + this.scope.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetActions() ? 131071 : 524287);
        if (this.isSetActions()) {
            hashCode = hashCode * 8191 + this.actions.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTableName() ? 131071 : 524287);
        if (this.isSetTableName()) {
            hashCode = hashCode * 8191 + this.tableName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetNsName() ? 131071 : 524287);
        if (this.isSetNsName()) {
            hashCode = hashCode * 8191 + this.nsName.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TAccessControlEntity other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetUsername(), other.isSetUsername());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUsername() && (lastComparison = TBaseHelper.compareTo((String)this.username, (String)other.username)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetScope(), other.isSetScope());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetScope() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.scope), (Comparable)((Object)other.scope))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetActions(), other.isSetActions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetActions() && (lastComparison = TBaseHelper.compareTo((String)this.actions, (String)other.actions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTableName(), other.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tableName, (Comparable)other.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNsName(), other.isSetNsName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNsName() && (lastComparison = TBaseHelper.compareTo((String)this.nsName, (String)other.nsName)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TAccessControlEntity.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TAccessControlEntity.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TAccessControlEntity(");
        boolean first = true;
        sb.append("username:");
        if (this.username == null) {
            sb.append("null");
        } else {
            sb.append(this.username);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("scope:");
        if (this.scope == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.scope);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("actions:");
        if (this.actions == null) {
            sb.append("null");
        } else {
            sb.append(this.actions);
        }
        first = false;
        if (this.isSetTableName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tableName:");
            if (this.tableName == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.tableName, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetNsName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("nsName:");
            if (this.nsName == null) {
                sb.append("null");
            } else {
                sb.append(this.nsName);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.username == null) {
            throw new TProtocolException("Required field 'username' was not present! Struct: " + this.toString());
        }
        if (this.scope == null) {
            throw new TProtocolException("Required field 'scope' was not present! Struct: " + this.toString());
        }
        if (this.actions == null) {
            throw new TProtocolException("Required field 'actions' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.USERNAME, new FieldMetaData("username", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SCOPE, new FieldMetaData("scope", 1, (FieldValueMetaData)new EnumMetaData(16, TPermissionScope.class)));
        tmpMap.put(_Fields.ACTIONS, new FieldMetaData("actions", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 2, new FieldValueMetaData(11, "Bytes")));
        tmpMap.put(_Fields.NS_NAME, new FieldMetaData("nsName", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TAccessControlEntity.class, metaDataMap);
    }

    private static class TAccessControlEntityTupleScheme
    extends TupleScheme<TAccessControlEntity> {
        private TAccessControlEntityTupleScheme() {
        }

        public void write(TProtocol prot, TAccessControlEntity struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.username);
            oprot.writeI32(struct.scope.getValue());
            oprot.writeString(struct.actions);
            BitSet optionals = new BitSet();
            if (struct.isSetTableName()) {
                optionals.set(0);
            }
            if (struct.isSetNsName()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetTableName()) {
                oprot.writeBinary(struct.tableName);
            }
            if (struct.isSetNsName()) {
                oprot.writeString(struct.nsName);
            }
        }

        public void read(TProtocol prot, TAccessControlEntity struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.username = iprot.readString();
            struct.setUsernameIsSet(true);
            struct.scope = TPermissionScope.findByValue(iprot.readI32());
            struct.setScopeIsSet(true);
            struct.actions = iprot.readString();
            struct.setActionsIsSet(true);
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.nsName = iprot.readString();
                struct.setNsNameIsSet(true);
            }
        }
    }

    private static class TAccessControlEntityTupleSchemeFactory
    implements SchemeFactory {
        private TAccessControlEntityTupleSchemeFactory() {
        }

        public TAccessControlEntityTupleScheme getScheme() {
            return new TAccessControlEntityTupleScheme();
        }
    }

    private static class TAccessControlEntityStandardScheme
    extends StandardScheme<TAccessControlEntity> {
        private TAccessControlEntityStandardScheme() {
        }

        public void read(TProtocol iprot, TAccessControlEntity struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.username = iprot.readString();
                            struct.setUsernameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.scope = TPermissionScope.findByValue(iprot.readI32());
                            struct.setScopeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.actions = iprot.readString();
                            struct.setActionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.tableName = iprot.readBinary();
                            struct.setTableNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.nsName = iprot.readString();
                            struct.setNsNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TAccessControlEntity struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.username != null) {
                oprot.writeFieldBegin(USERNAME_FIELD_DESC);
                oprot.writeString(struct.username);
                oprot.writeFieldEnd();
            }
            if (struct.scope != null) {
                oprot.writeFieldBegin(SCOPE_FIELD_DESC);
                oprot.writeI32(struct.scope.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.actions != null) {
                oprot.writeFieldBegin(ACTIONS_FIELD_DESC);
                oprot.writeString(struct.actions);
                oprot.writeFieldEnd();
            }
            if (struct.tableName != null && struct.isSetTableName()) {
                oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                oprot.writeBinary(struct.tableName);
                oprot.writeFieldEnd();
            }
            if (struct.nsName != null && struct.isSetNsName()) {
                oprot.writeFieldBegin(NS_NAME_FIELD_DESC);
                oprot.writeString(struct.nsName);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TAccessControlEntityStandardSchemeFactory
    implements SchemeFactory {
        private TAccessControlEntityStandardSchemeFactory() {
        }

        public TAccessControlEntityStandardScheme getScheme() {
            return new TAccessControlEntityStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        USERNAME(1, "username"),
        SCOPE(2, "scope"),
        ACTIONS(4, "actions"),
        TABLE_NAME(5, "tableName"),
        NS_NAME(6, "nsName");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return USERNAME;
                }
                case 2: {
                    return SCOPE;
                }
                case 4: {
                    return ACTIONS;
                }
                case 5: {
                    return TABLE_NAME;
                }
                case 6: {
                    return NS_NAME;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

