/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.DualAsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.regionserver.PeerActionListener;
import org.apache.hadoop.hbase.replication.regionserver.SyncReplicationPeerInfoProvider;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.NettyAsyncFSWALConfigHelper;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.hbase.thirdparty.com.google.common.collect.Streams;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SyncReplicationWALProvider
implements WALProvider,
PeerActionListener {
    private static final Logger LOG = LoggerFactory.getLogger(SyncReplicationWALProvider.class);
    public static final String DUAL_WAL_IMPL = "hbase.wal.sync.impl";
    private final WALProvider provider;
    private SyncReplicationPeerInfoProvider peerInfoProvider = new DefaultSyncReplicationPeerInfoProvider();
    private WALFactory factory;
    private Configuration conf;
    private List<WALActionsListener> listeners = new ArrayList<WALActionsListener>();
    private EventLoopGroup eventLoopGroup;
    private Class<? extends Channel> channelClass;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private final ConcurrentMap<String, Optional<DualAsyncFSWAL>> peerId2WAL = new ConcurrentHashMap<String, Optional<DualAsyncFSWAL>>();
    private final KeyLocker<String> createLock = new KeyLocker();
    private static final Pattern LOG_PREFIX_PATTERN = Pattern.compile(".*-\\d+-(.+)");

    SyncReplicationWALProvider(WALProvider provider) {
        this.provider = provider;
    }

    public void setPeerInfoProvider(SyncReplicationPeerInfoProvider peerInfoProvider) {
        this.peerInfoProvider = peerInfoProvider;
    }

    @Override
    public void init(WALFactory factory, Configuration conf, String providerId, Abortable abortable) throws IOException {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        this.provider.init(factory, conf, providerId, abortable);
        this.conf = conf;
        this.factory = factory;
        Pair<EventLoopGroup, Class<? extends Channel>> eventLoopGroupAndChannelClass = NettyAsyncFSWALConfigHelper.getEventLoopConfig(conf);
        this.eventLoopGroup = (EventLoopGroup)eventLoopGroupAndChannelClass.getFirst();
        this.channelClass = (Class)eventLoopGroupAndChannelClass.getSecond();
    }

    private String getLogPrefix(String peerId) {
        return this.factory.factoryId + "-" + EnvironmentEdgeManager.currentTime() + "-" + peerId;
    }

    private DualAsyncFSWAL createWAL(String peerId, String remoteWALDir) throws IOException {
        Class clazz = this.conf.getClass(DUAL_WAL_IMPL, DualAsyncFSWAL.class, DualAsyncFSWAL.class);
        try {
            Constructor<?> constructor = null;
            for (Constructor<?> c : clazz.getDeclaredConstructors()) {
                if (c.getParameterCount() <= 0) continue;
                constructor = c;
                break;
            }
            if (constructor == null) {
                throw new IllegalArgumentException("No valid constructor provided for class " + clazz);
            }
            constructor.setAccessible(true);
            return (DualAsyncFSWAL)constructor.newInstance(CommonFSUtils.getWALFileSystem((Configuration)this.conf), ReplicationUtils.getRemoteWALFileSystem((Configuration)this.conf, (String)remoteWALDir), CommonFSUtils.getWALRootDir((Configuration)this.conf), ReplicationUtils.getPeerRemoteWALDir((String)remoteWALDir, (String)peerId), AbstractFSWALProvider.getWALDirectoryName(this.factory.factoryId), AbstractFSWALProvider.getWALArchiveDirectoryName(this.conf, this.factory.factoryId), this.conf, this.listeners, true, this.getLogPrefix(peerId), ".syncrep", this.eventLoopGroup, this.channelClass);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            Throwables.propagateIfPossible((Throwable)cause, IOException.class);
            throw new RuntimeException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DualAsyncFSWAL getWAL(String peerId, String remoteWALDir) throws IOException {
        Optional opt = (Optional)this.peerId2WAL.get(peerId);
        if (opt != null) {
            return opt.orElse(null);
        }
        ReentrantLock lock = this.createLock.acquireLock((Object)peerId);
        try {
            opt = (Optional)this.peerId2WAL.get(peerId);
            if (opt != null) {
                DualAsyncFSWAL dualAsyncFSWAL = opt.orElse(null);
                return dualAsyncFSWAL;
            }
            DualAsyncFSWAL wal = this.createWAL(peerId, remoteWALDir);
            boolean succ = false;
            try {
                wal.init();
                succ = true;
            }
            finally {
                if (!succ) {
                    wal.close();
                }
            }
            this.peerId2WAL.put(peerId, Optional.of(wal));
            DualAsyncFSWAL dualAsyncFSWAL = wal;
            return dualAsyncFSWAL;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public WAL getWAL(RegionInfo region) throws IOException {
        if (region == null) {
            return this.provider.getWAL(null);
        }
        WAL wal = null;
        Optional<Pair<String, String>> peerIdAndRemoteWALDir = this.peerInfoProvider.getPeerIdAndRemoteWALDir(region.getTable());
        if (peerIdAndRemoteWALDir.isPresent()) {
            Pair<String, String> pair = peerIdAndRemoteWALDir.get();
            wal = this.getWAL((String)pair.getFirst(), (String)pair.getSecond());
        }
        return wal != null ? wal : this.provider.getWAL(region);
    }

    private Stream<WAL> getWALStream() {
        return Streams.concat((Stream[])new Stream[]{this.peerId2WAL.values().stream().filter(Optional::isPresent).map(Optional::get), this.provider.getWALs().stream()});
    }

    @Override
    public List<WAL> getWALs() {
        return this.getWALStream().collect(Collectors.toList());
    }

    @Override
    public void shutdown() throws IOException {
        IOException failure = null;
        for (Optional wal : this.peerId2WAL.values()) {
            if (!wal.isPresent()) continue;
            try {
                ((DualAsyncFSWAL)wal.get()).shutdown();
            }
            catch (IOException e) {
                LOG.error("Shutdown WAL failed", (Throwable)e);
                failure = e;
            }
        }
        this.provider.shutdown();
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public void close() throws IOException {
        IOException failure = null;
        for (Optional wal : this.peerId2WAL.values()) {
            if (!wal.isPresent()) continue;
            try {
                ((DualAsyncFSWAL)wal.get()).close();
            }
            catch (IOException e) {
                LOG.error("Close WAL failed", (Throwable)e);
                failure = e;
            }
        }
        this.provider.close();
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public long getNumLogFiles() {
        return (long)this.peerId2WAL.size() + this.provider.getNumLogFiles();
    }

    @Override
    public long getLogFileSize() {
        return this.peerId2WAL.values().stream().filter(Optional::isPresent).map(Optional::get).mapToLong(AbstractFSWAL::getLogFileSize).sum() + this.provider.getLogFileSize();
    }

    private void safeClose(WAL wal) {
        if (wal != null) {
            try {
                wal.close();
            }
            catch (IOException e) {
                LOG.error("Close WAL failed", (Throwable)e);
            }
        }
    }

    @Override
    public void addWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
        this.provider.addWALActionsListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerSyncReplicationStateChange(String peerId, SyncReplicationState from, SyncReplicationState to, int stage) {
        if (from == SyncReplicationState.ACTIVE) {
            if (stage == 0) {
                ReentrantLock lock = this.createLock.acquireLock((Object)peerId);
                try {
                    Optional opt = (Optional)this.peerId2WAL.get(peerId);
                    if (opt != null) {
                        opt.ifPresent(w -> w.skipRemoteWAL(to == SyncReplicationState.STANDBY));
                    }
                    this.peerId2WAL.put(peerId, Optional.empty());
                }
                finally {
                    lock.unlock();
                }
            } else if (stage == 1) {
                ((Optional)this.peerId2WAL.remove(peerId)).ifPresent(this::safeClose);
            }
        }
    }

    public static Optional<String> getSyncReplicationPeerIdFromWALName(String name) {
        if (!name.endsWith(".syncrep")) {
            return Optional.empty();
        }
        String logPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(name);
        Matcher matcher = LOG_PREFIX_PATTERN.matcher(logPrefix);
        if (matcher.matches()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    WALProvider getWrappedProvider() {
        return this.provider;
    }

    private static class DefaultSyncReplicationPeerInfoProvider
    implements SyncReplicationPeerInfoProvider {
        private DefaultSyncReplicationPeerInfoProvider() {
        }

        @Override
        public Optional<Pair<String, String>> getPeerIdAndRemoteWALDir(TableName table) {
            return Optional.empty();
        }

        @Override
        public boolean checkState(TableName table, BiPredicate<SyncReplicationState, SyncReplicationState> checker) {
            return false;
        }
    }
}

