/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.EntryBuffers;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class OutputSink {
    private static final Logger LOG = LoggerFactory.getLogger(OutputSink.class);
    private final WALSplitter.PipelineController controller;
    protected final EntryBuffers entryBuffers;
    private final List<WriterThread> writerThreads = Lists.newArrayList();
    protected final int numThreads;
    protected CancelableProgressable reporter = null;
    protected final AtomicLong totalSkippedEdits = new AtomicLong();
    protected final List<Path> splits = new ArrayList<Path>();
    protected MonitoredTask status = null;
    protected final ThreadPoolExecutor closeThreadPool;
    protected final CompletionService<Void> closeCompletionService;

    public OutputSink(WALSplitter.PipelineController controller, EntryBuffers entryBuffers, int numWriters) {
        this.numThreads = numWriters;
        this.controller = controller;
        this.entryBuffers = entryBuffers;
        this.closeThreadPool = Threads.getBoundedCachedThreadPool((int)this.numThreads, (long)30L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)new ThreadFactoryBuilder().setNameFormat("split-log-closeStream-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
        this.closeCompletionService = new ExecutorCompletionService<Void>(this.closeThreadPool);
    }

    void setReporter(CancelableProgressable reporter) {
        this.reporter = reporter;
    }

    void setStatus(MonitoredTask status) {
        this.status = status;
    }

    void startWriterThreads() throws IOException {
        for (int i = 0; i < this.numThreads; ++i) {
            WriterThread t = new WriterThread(this.controller, this.entryBuffers, this, i);
            t.start();
            this.writerThreads.add(t);
        }
    }

    boolean finishWriterThreads() throws IOException {
        LOG.debug("Waiting for split writer threads to finish");
        boolean progressFailed = false;
        for (WriterThread t : this.writerThreads) {
            t.finish();
        }
        for (WriterThread t : this.writerThreads) {
            if (!progressFailed && this.reporter != null && !this.reporter.progress()) {
                progressFailed = true;
            }
            try {
                t.join();
            }
            catch (InterruptedException ie) {
                InterruptedIOException iie = new InterruptedIOException();
                iie.initCause(ie);
                throw iie;
            }
        }
        this.controller.checkForErrors();
        String msg = this.writerThreads.size() + " split writer threads finished";
        LOG.info(msg);
        this.updateStatusWithMsg(msg);
        return !progressFailed;
    }

    long getTotalSkippedEdits() {
        return this.totalSkippedEdits.get();
    }

    abstract int getNumOpenWriters();

    abstract void append(EntryBuffers.RegionEntryBuffer var1) throws IOException;

    abstract List<Path> close() throws IOException;

    abstract Map<String, Long> getOutputCounts();

    abstract int getNumberOfRecoveredRegions();

    abstract boolean keepRegionEvent(WAL.Entry var1);

    protected final void updateStatusWithMsg(String msg) {
        if (this.status != null) {
            this.status.setStatus(msg);
        }
    }

    public static class WriterThread
    extends Thread {
        private volatile boolean shouldStop = false;
        private WALSplitter.PipelineController controller;
        private EntryBuffers entryBuffers;
        private OutputSink outputSink = null;

        WriterThread(WALSplitter.PipelineController controller, EntryBuffers entryBuffers, OutputSink sink, int i) {
            super(Thread.currentThread().getName() + "-Writer-" + i);
            this.controller = controller;
            this.entryBuffers = entryBuffers;
            this.outputSink = sink;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                LOG.error("Exiting thread", t);
                this.controller.writerThreadError(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() throws IOException {
            LOG.trace("Writer thread starting");
            while (true) {
                EntryBuffers.RegionEntryBuffer buffer;
                if ((buffer = this.entryBuffers.getChunkToWrite()) == null) {
                    Object object = this.controller.dataAvailable;
                    synchronized (object) {
                        block12: {
                            if (this.shouldStop) {
                                return;
                            }
                            try {
                                this.controller.dataAvailable.wait(500L);
                            }
                            catch (InterruptedException ie) {
                                if (this.shouldStop) break block12;
                                throw new RuntimeException(ie);
                            }
                        }
                    }
                }
                assert (buffer != null);
                try {
                    this.writeBuffer(buffer);
                    continue;
                }
                finally {
                    this.entryBuffers.doneWriting(buffer);
                    continue;
                }
                break;
            }
        }

        private void writeBuffer(EntryBuffers.RegionEntryBuffer buffer) throws IOException {
            this.outputSink.append(buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish() {
            Object object = this.controller.dataAvailable;
            synchronized (object) {
                this.shouldStop = true;
                this.controller.dataAvailable.notifyAll();
            }
        }
    }
}

