/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class LazyInitializedWALProvider
implements Closeable {
    private final WALFactory factory;
    private final String providerId;
    private final String providerConfigName;
    private final Abortable abortable;
    private final AtomicReference<WALProvider> holder = new AtomicReference();

    LazyInitializedWALProvider(WALFactory factory, String providerId, String providerConfigName, Abortable abortable) {
        this.factory = factory;
        this.providerId = providerId;
        this.providerConfigName = providerConfigName;
        this.abortable = abortable;
    }

    WALProvider getProvider() throws IOException {
        Configuration conf = this.factory.getConf();
        WALProvider provider;
        while ((provider = this.holder.get()) == null) {
            Class<? extends WALProvider> clz = null;
            if (conf.get(this.providerConfigName) == null) {
                try {
                    clz = conf.getClass("hbase.wal.provider", WALFactory.Providers.defaultProvider.clazz, WALProvider.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (clz == null) {
                clz = this.factory.getProviderClass(this.providerConfigName, conf.get("hbase.wal.provider", WALFactory.DEFAULT_WAL_PROVIDER));
            }
            provider = WALFactory.createProvider(clz);
            provider.init(this.factory, conf, this.providerId, this.abortable);
            provider.addWALActionsListener(new MetricsWAL());
            if (this.holder.compareAndSet(null, provider)) {
                return provider;
            }
            provider.close();
        }
        return provider;
    }

    WALProvider getProviderNoCreate() {
        return this.holder.get();
    }

    @Override
    public void close() throws IOException {
        WALProvider provider = this.holder.get();
        if (provider != null) {
            provider.close();
        }
    }

    void shutdown() throws IOException {
        WALProvider provider = this.holder.get();
        if (provider != null) {
            provider.shutdown();
        }
    }
}

