/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.RecoverLeaseFSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AbstractFSWALProvider<T extends AbstractFSWAL<?>>
implements WALProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFSWALProvider.class);
    public static final String SEPARATE_OLDLOGDIR = "hbase.separate.oldlogdir.by.regionserver";
    public static final boolean DEFAULT_SEPARATE_OLDLOGDIR = false;
    protected volatile T wal;
    protected WALFactory factory;
    protected Configuration conf;
    protected List<WALActionsListener> listeners = new ArrayList<WALActionsListener>();
    protected String providerId;
    protected AtomicBoolean initialized = new AtomicBoolean(false);
    protected String logPrefix;
    protected Abortable abortable;
    private final ReadWriteLock walCreateLock = new ReentrantReadWriteLock();
    public static final String WAL_FILE_NAME_DELIMITER = ".";
    public static final String META_WAL_PROVIDER_ID = ".meta";
    static final String DEFAULT_PROVIDER_ID = "default";
    public static final String SPLITTING_EXT = "-splitting";
    private static final Pattern WAL_FILE_NAME_PATTERN = Pattern.compile("(.+)\\.(\\d+)(\\.[0-9A-Za-z]+)?");
    private static final long NO_TIMESTAMP = -1L;
    public static final Comparator<Path> TIMESTAMP_COMPARATOR = Comparator.comparing(p -> AbstractFSWALProvider.getTimestamp(p.getName())).thenComparing(Path::getName);
    private static final Pattern SERVER_NAME_PATTERN = Pattern.compile("^[^,]+,[\\d]+,[\\d]+");

    @Override
    public void init(WALFactory factory, Configuration conf, String providerId, Abortable abortable) throws IOException {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        this.factory = factory;
        this.conf = conf;
        this.providerId = providerId;
        StringBuilder sb = new StringBuilder().append(factory.factoryId);
        if (providerId != null) {
            if (providerId.startsWith(WAL_FILE_NAME_DELIMITER)) {
                sb.append(providerId);
            } else {
                sb.append(WAL_FILE_NAME_DELIMITER).append(providerId);
            }
        }
        this.logPrefix = sb.toString();
        this.abortable = abortable;
        this.doInit(conf);
    }

    @Override
    public List<WAL> getWALs() {
        if (this.wal != null) {
            return Lists.newArrayList((Object[])new WAL[]{this.wal});
        }
        this.walCreateLock.readLock().lock();
        try {
            if (this.wal == null) {
                List<WAL> list = Collections.emptyList();
                return list;
            }
            ArrayList arrayList = Lists.newArrayList((Object[])new WAL[]{this.wal});
            return arrayList;
        }
        finally {
            this.walCreateLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getWAL(RegionInfo region) throws IOException {
        T walCopy = this.wal;
        if (walCopy != null) {
            return walCopy;
        }
        this.walCreateLock.writeLock().lock();
        try {
            walCopy = this.wal;
            if (walCopy != null) {
                T t = walCopy;
                return t;
            }
            walCopy = this.createWAL();
            boolean succ = false;
            try {
                ((AbstractFSWAL)walCopy).init();
                succ = true;
            }
            finally {
                if (!succ) {
                    ((AbstractFSWAL)walCopy).close();
                }
            }
            this.wal = walCopy;
            T t = walCopy;
            return t;
        }
        finally {
            this.walCreateLock.writeLock().unlock();
        }
    }

    protected abstract T createWAL() throws IOException;

    protected abstract void doInit(Configuration var1) throws IOException;

    @Override
    public void shutdown() throws IOException {
        T log = this.wal;
        if (log != null) {
            ((AbstractFSWAL)log).shutdown();
        }
    }

    @Override
    public void close() throws IOException {
        T log = this.wal;
        if (log != null) {
            ((AbstractFSWAL)log).close();
        }
    }

    @Override
    public long getNumLogFiles() {
        T log = this.wal;
        return log == null ? 0L : (long)((AbstractFSWAL)log).getNumLogFiles();
    }

    @Override
    public long getLogFileSize() {
        T log = this.wal;
        return log == null ? 0L : ((AbstractFSWAL)log).getLogFileSize();
    }

    public static int getNumRolledLogFiles(WAL wal) {
        return ((AbstractFSWAL)wal).getNumRolledLogFiles();
    }

    public static long getLogFileSize(WAL wal) {
        return ((AbstractFSWAL)wal).getLogFileSize();
    }

    public static Path getCurrentFileName(WAL wal) {
        return ((AbstractFSWAL)wal).getCurrentFileName();
    }

    static void requestLogRoll(WAL wal) {
        ((AbstractFSWAL)wal).requestLogRoll();
    }

    public static long extractFileNumFromWAL(WAL wal) {
        Path walPath = ((AbstractFSWAL)wal).getCurrentFileName();
        if (walPath == null) {
            throw new IllegalArgumentException("The WAL path couldn't be null");
        }
        String name = walPath.getName();
        long timestamp = AbstractFSWALProvider.getTimestamp(name);
        if (timestamp == -1L) {
            throw new IllegalArgumentException(name + " is not a valid wal file name");
        }
        return timestamp;
    }

    public static boolean validateWALFilename(String filename) {
        return WAL_FILE_NAME_PATTERN.matcher(filename).matches();
    }

    public static long getTimestamp(String name) {
        Matcher matcher = WAL_FILE_NAME_PATTERN.matcher(name);
        return matcher.matches() ? Long.parseLong(matcher.group(2)) : -1L;
    }

    public static String getWALDirectoryName(String serverName) {
        StringBuilder dirName = new StringBuilder("WALs");
        dirName.append("/");
        dirName.append(serverName);
        return dirName.toString();
    }

    public static String getWALArchiveDirectoryName(Configuration conf, String serverName) {
        StringBuilder dirName = new StringBuilder("oldWALs");
        if (conf.getBoolean(SEPARATE_OLDLOGDIR, false)) {
            dirName.append("/");
            dirName.append(serverName);
        }
        return dirName.toString();
    }

    public static List<Path> getArchivedWALFiles(Configuration conf, ServerName serverName, String logPrefix) throws IOException {
        Path walRootDir = CommonFSUtils.getWALRootDir((Configuration)conf);
        FileSystem fs = walRootDir.getFileSystem(conf);
        ArrayList<Path> archivedWalFiles = new ArrayList<Path>();
        Path oldWalDir = new Path(walRootDir, "oldWALs");
        try {
            for (FileStatus status : fs.listStatus(oldWalDir, p -> p.getName().startsWith(logPrefix))) {
                if (!status.isFile()) continue;
                archivedWalFiles.add(status.getPath());
            }
        }
        catch (FileNotFoundException e) {
            LOG.info("Old WAL dir {} not exists", (Object)oldWalDir);
            return Collections.emptyList();
        }
        Path separatedOldWalDir = new Path(oldWalDir, serverName.toString());
        try {
            for (FileStatus status : fs.listStatus(separatedOldWalDir, p -> p.getName().startsWith(logPrefix))) {
                if (!status.isFile()) continue;
                archivedWalFiles.add(status.getPath());
            }
        }
        catch (FileNotFoundException e) {
            LOG.info("Seprated old WAL dir {} not exists", (Object)separatedOldWalDir);
        }
        return archivedWalFiles;
    }

    public static List<Path> getWALFiles(Configuration c, ServerName serverName) throws IOException {
        Path walRoot = new Path(CommonFSUtils.getWALRootDir((Configuration)c), "WALs");
        FileSystem fs = walRoot.getFileSystem(c);
        ArrayList<Path> walFiles = new ArrayList<Path>();
        Path walDir = new Path(walRoot, serverName.toString());
        try {
            for (FileStatus status : fs.listStatus(walDir)) {
                if (!status.isFile()) continue;
                walFiles.add(status.getPath());
            }
        }
        catch (FileNotFoundException e) {
            LOG.info("WAL dir {} not exists", (Object)walDir);
        }
        return walFiles;
    }

    public static ServerName getServerNameFromWALDirectoryName(Configuration conf, String path) throws IOException {
        String fullPath;
        if (path == null || path.length() <= "WALs".length()) {
            return null;
        }
        if (conf == null) {
            throw new IllegalArgumentException("parameter conf must be set");
        }
        String rootDir = conf.get("hbase.rootdir");
        if (rootDir == null || rootDir.isEmpty()) {
            throw new IllegalArgumentException("hbase.rootdir key not found in conf.");
        }
        StringBuilder startPathSB = new StringBuilder(rootDir);
        if (!rootDir.endsWith("/")) {
            startPathSB.append('/');
        }
        startPathSB.append("WALs");
        if (!"WALs".endsWith("/")) {
            startPathSB.append('/');
        }
        String startPath = startPathSB.toString();
        try {
            fullPath = FileSystem.get((Configuration)conf).makeQualified(new Path(path)).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.info("Call to makeQualified failed on " + path + " " + e.getMessage());
            return null;
        }
        if (!fullPath.startsWith(startPath)) {
            return null;
        }
        String serverNameAndFile = fullPath.substring(startPath.length());
        if (serverNameAndFile.indexOf(47) < "a,0,0".length()) {
            return null;
        }
        Path p = new Path(path);
        return AbstractFSWALProvider.getServerNameFromWALDirectoryName(p);
    }

    public static ServerName getServerNameFromWALDirectoryName(Path logFile) {
        String logDirName = logFile.getParent().getName();
        if (logDirName.equals("WALs")) {
            logDirName = logFile.getName();
        }
        ServerName serverName = null;
        if (logDirName.endsWith(SPLITTING_EXT)) {
            logDirName = logDirName.substring(0, logDirName.length() - SPLITTING_EXT.length());
        }
        try {
            serverName = ServerName.parseServerName((String)logDirName);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            serverName = null;
            LOG.warn("Cannot parse a server name from path={}", (Object)logFile, (Object)ex);
        }
        if (serverName != null && serverName.getStartCode() < 0L) {
            LOG.warn("Invalid log file path={}, start code {} is less than 0", (Object)logFile, (Object)serverName.getStartCode());
            serverName = null;
        }
        return serverName;
    }

    public static boolean isMetaFile(Path p) {
        return AbstractFSWALProvider.isMetaFile(p.getName());
    }

    public static boolean isMetaFile(String p) {
        return p != null && p.endsWith(META_WAL_PROVIDER_ID);
    }

    public static boolean isArchivedLogFile(Path p) {
        String oldLog = "/oldWALs/";
        return p.toString().contains(oldLog);
    }

    public static Path findArchivedLog(Path path, Configuration conf) throws IOException {
        Path oldLogDir;
        Path archivedLogLocation;
        if (path.toString().contains("oldWALs")) {
            return null;
        }
        Path walRootDir = CommonFSUtils.getWALRootDir((Configuration)conf);
        FileSystem fs = path.getFileSystem(conf);
        if (fs.exists(archivedLogLocation = new Path(oldLogDir = new Path(walRootDir, "oldWALs"), path.getName()))) {
            LOG.info("Log " + path + " was moved to " + archivedLogLocation);
            return archivedLogLocation;
        }
        ServerName serverName = AbstractFSWALProvider.getServerNameFromWALDirectoryName(path);
        if (serverName == null) {
            LOG.warn("Can not extract server name from path {}, give up searching the separated old log dir", (Object)path);
            return null;
        }
        oldLogDir = new Path(walRootDir, "oldWALs" + "/" + serverName.getServerName());
        archivedLogLocation = new Path(oldLogDir, path.getName());
        if (fs.exists(archivedLogLocation)) {
            LOG.info("Log " + path + " was moved to " + archivedLogLocation);
            return archivedLogLocation;
        }
        LOG.error("Couldn't locate log: " + path);
        return null;
    }

    public static void recoverLease(Configuration conf, final Path path) {
        try {
            FileSystem dfs = CommonFSUtils.getCurrentFileSystem((Configuration)conf);
            RecoverLeaseFSUtils.recoverFileLease((FileSystem)dfs, (Path)path, (Configuration)conf, (CancelableProgressable)new CancelableProgressable(){

                public boolean progress() {
                    LOG.debug("Still trying to recover WAL lease: " + path);
                    return true;
                }
            });
        }
        catch (IOException e) {
            LOG.warn("unable to recover lease for WAL: " + path, (Throwable)e);
        }
    }

    @Override
    public void addWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
    }

    private static String getWALNameGroupFromWALName(String name, int group) {
        Matcher matcher = WAL_FILE_NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            return matcher.group(group);
        }
        throw new IllegalArgumentException(name + " is not a valid wal file name");
    }

    public static String getWALPrefixFromWALName(String name) {
        return AbstractFSWALProvider.getWALNameGroupFromWALName(name, 1);
    }

    public static ServerName parseServerNameFromWALName(String name) {
        String decoded;
        try {
            decoded = URLDecoder.decode(name, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("should never happen", e);
        }
        Matcher matcher = SERVER_NAME_PATTERN.matcher(decoded);
        if (matcher.find()) {
            return ServerName.valueOf((String)matcher.group());
        }
        throw new IllegalArgumentException(name + " is not started with a server name");
    }

    public static class WALStartTimeComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path o1, Path o2) {
            return Long.compare(WALStartTimeComparator.getTS(o1), WALStartTimeComparator.getTS(o2));
        }

        public static long getTS(Path p) {
            return AbstractFSWALProvider.getTimestamp(p.getName());
        }
    }

    public static interface Initializer {
        public void init(FileSystem var1, Path var2, Configuration var3, long var4) throws IOException;
    }
}

