/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.ShadedAccessControlUtil;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class SnapshotDescriptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotDescriptionUtils.class);
    public static final int SNAPSHOT_LAYOUT_VERSION = 2;
    public static final String SNAPSHOTINFO_FILE = ".snapshotinfo";
    public static final String SNAPSHOT_TMP_DIR_NAME = ".tmp";
    public static final String SNAPSHOT_WORKING_DIR = "hbase.snapshot.working.dir";
    public static final long NO_SNAPSHOT_START_TIME_SPECIFIED = 0L;
    private static final long NO_SNAPSHOT_TTL_SPECIFIED = 0L;
    public static final String MASTER_SNAPSHOT_TIMEOUT_MILLIS = "hbase.snapshot.master.timeout.millis";
    public static final long DEFAULT_MAX_WAIT_TIME = 300000L;
    public static final String SNAPSHOT_CORRUPTED_FILE = "_CORRUPTED";

    private SnapshotDescriptionUtils() {
    }

    public static long getMaxMasterTimeout(Configuration conf, SnapshotProtos.SnapshotDescription.Type type, long defaultMaxWaitTime) {
        switch (type) {
            default: 
        }
        String confKey = MASTER_SNAPSHOT_TIMEOUT_MILLIS;
        return Math.max(conf.getLong(confKey, defaultMaxWaitTime), conf.getLong(MASTER_SNAPSHOT_TIMEOUT_MILLIS, defaultMaxWaitTime));
    }

    public static Path getSnapshotRootDir(Path rootDir) {
        return new Path(rootDir, ".hbase-snapshot");
    }

    public static Path getCompletedSnapshotDir(SnapshotProtos.SnapshotDescription snapshot, Path rootDir) {
        return SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot.getName(), rootDir);
    }

    public static Path getCompletedSnapshotDir(String snapshotName, Path rootDir) {
        return SnapshotDescriptionUtils.getSpecifiedSnapshotDir(SnapshotDescriptionUtils.getSnapshotsDir(rootDir), snapshotName);
    }

    public static Path getWorkingSnapshotDir(Path rootDir, Configuration conf) {
        return new Path(conf.get(SNAPSHOT_WORKING_DIR, SnapshotDescriptionUtils.getDefaultWorkingSnapshotDir(rootDir).toString()));
    }

    public static Path getWorkingSnapshotDir(SnapshotProtos.SnapshotDescription snapshot, Path rootDir, Configuration conf) {
        return SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot.getName(), rootDir, conf);
    }

    public static Path getWorkingSnapshotDir(String snapshotName, Path rootDir, Configuration conf) {
        return SnapshotDescriptionUtils.getSpecifiedSnapshotDir(SnapshotDescriptionUtils.getWorkingSnapshotDir(rootDir, conf), snapshotName);
    }

    public static Path getCorruptedFlagFileForSnapshot(Path workingDir) {
        return new Path(workingDir, SNAPSHOT_CORRUPTED_FILE);
    }

    private static final Path getSpecifiedSnapshotDir(Path snapshotsDir, String snapshotName) {
        return new Path(snapshotsDir, snapshotName);
    }

    public static final Path getSnapshotsDir(Path rootDir) {
        return new Path(rootDir, ".hbase-snapshot");
    }

    public static boolean isSubDirectoryOf(Path workingDir, Path rootDir) {
        return workingDir.toString().startsWith(rootDir.toString() + "/");
    }

    public static boolean isWithinDefaultWorkingDir(Path workingDir, Configuration conf) throws IOException {
        Path defaultWorkingDir = SnapshotDescriptionUtils.getDefaultWorkingSnapshotDir(CommonFSUtils.getRootDir((Configuration)conf));
        return workingDir.equals((Object)defaultWorkingDir) || SnapshotDescriptionUtils.isSubDirectoryOf(workingDir, defaultWorkingDir);
    }

    private static Path getDefaultWorkingSnapshotDir(Path rootDir) {
        return new Path(SnapshotDescriptionUtils.getSnapshotsDir(rootDir), SNAPSHOT_TMP_DIR_NAME);
    }

    public static SnapshotProtos.SnapshotDescription validate(SnapshotProtos.SnapshotDescription snapshot, Configuration conf) throws IllegalArgumentException, IOException {
        long ttl;
        if (!snapshot.hasTable()) {
            throw new IllegalArgumentException("Descriptor doesn't apply to a table, so we can't build it.");
        }
        SnapshotProtos.SnapshotDescription.Builder builder = snapshot.toBuilder();
        long time = snapshot.getCreationTime();
        if (time == 0L) {
            time = EnvironmentEdgeManager.currentTime();
            LOG.debug("Creation time not specified, setting to:" + time + " (current time:" + EnvironmentEdgeManager.currentTime() + ").");
            builder.setCreationTime(time);
        }
        if ((ttl = snapshot.getTtl()) == 0L || ttl > TimeUnit.MILLISECONDS.toSeconds(Long.MAX_VALUE)) {
            long defaultSnapshotTtl = conf.getLong("hbase.master.snapshot.ttl", 0L);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Snapshot current TTL value: {} resetting it to default value: {}", (Object)ttl, (Object)defaultSnapshotTtl);
            }
            ttl = defaultSnapshotTtl;
        }
        builder.setTtl(ttl);
        if (!snapshot.hasVersion()) {
            builder.setVersion(2);
            LOG.debug("Snapshot {} VERSION not specified, setting to {}", (Object)snapshot.getName(), (Object)2);
        }
        RpcServer.getRequestUser().ifPresent(user -> {
            if (AccessChecker.isAuthorizationSupported(conf)) {
                builder.setOwner(user.getShortName());
                LOG.debug("Set {} as owner of Snapshot", (Object)user.getShortName());
            }
        });
        snapshot = builder.build();
        if (SnapshotDescriptionUtils.isSecurityAvailable(conf)) {
            snapshot = SnapshotDescriptionUtils.writeAclToSnapshotDescription(snapshot, conf);
        }
        return snapshot;
    }

    public static void writeSnapshotInfo(SnapshotProtos.SnapshotDescription snapshot, Path workingDir, FileSystem fs) throws IOException {
        block14: {
            FsPermission perms = CommonFSUtils.getFilePermissions((FileSystem)fs, (Configuration)fs.getConf(), (String)"hbase.data.umask");
            Path snapshotInfo = new Path(workingDir, SNAPSHOTINFO_FILE);
            try (FSDataOutputStream out = CommonFSUtils.create((FileSystem)fs, (Path)snapshotInfo, (FsPermission)perms, (boolean)true);){
                snapshot.writeTo((OutputStream)out);
            }
            catch (IOException e) {
                if (fs.delete(snapshotInfo, false)) break block14;
                String msg = "Couldn't delete snapshot info file: " + snapshotInfo;
                LOG.error(msg);
                throw new IOException(msg);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SnapshotProtos.SnapshotDescription readSnapshotInfo(FileSystem fs, Path snapshotDir) throws CorruptedSnapshotException {
        Path snapshotInfo = new Path(snapshotDir, SNAPSHOTINFO_FILE);
        try (FSDataInputStream in = fs.open(snapshotInfo);){
            SnapshotProtos.SnapshotDescription snapshotDescription = SnapshotProtos.SnapshotDescription.parseFrom((InputStream)in);
            return snapshotDescription;
        }
        catch (IOException e) {
            throw new CorruptedSnapshotException("Couldn't read snapshot info from:" + snapshotInfo, (Exception)e);
        }
    }

    public static void completeSnapshot(Path snapshotDir, Path workingDir, FileSystem fs, FileSystem workingDirFs, Configuration conf) throws SnapshotCreationException, IOException {
        LOG.debug("Sentinel is done, just moving the snapshot from " + workingDir + " to " + snapshotDir);
        URI workingURI = workingDirFs.getUri();
        URI rootURI = fs.getUri();
        if (!(workingURI.getScheme().equals(rootURI.getScheme()) && workingURI.getAuthority() != null && workingURI.getAuthority().equals(rootURI.getAuthority()) && workingURI.getUserInfo() != null && workingURI.getUserInfo().equals(rootURI.getUserInfo()) && fs.rename(workingDir, snapshotDir) || FileUtil.copy((FileSystem)workingDirFs, (Path)workingDir, (FileSystem)fs, (Path)snapshotDir, (boolean)true, (boolean)true, (Configuration)conf))) {
            throw new SnapshotCreationException("Failed to copy working directory(" + workingDir + ") to completed directory(" + snapshotDir + ").");
        }
    }

    public static boolean isSnapshotOwner(SnapshotDescription snapshot, User user) {
        if (user == null) {
            return false;
        }
        return user.getShortName().equals(snapshot.getOwner());
    }

    /*
     * Exception decompiling
     */
    public static boolean isSecurityAvailable(Configuration conf) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SnapshotProtos.SnapshotDescription writeAclToSnapshotDescription(final SnapshotProtos.SnapshotDescription snapshot, final Configuration conf) throws IOException {
        ListMultimap perms = (ListMultimap)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<ListMultimap<String, UserPermission>>(){

            @Override
            public ListMultimap<String, UserPermission> run() throws Exception {
                return PermissionStorage.getTablePermissions(conf, TableName.valueOf((String)snapshot.getTable()));
            }
        });
        return snapshot.toBuilder().setUsersAndPermissions(ShadedAccessControlUtil.toUserTablePermissions((ListMultimap)perms)).build();
    }

    public static boolean isExpiredSnapshot(long snapshotTtl, long snapshotCreatedTime, long currentTime) {
        return snapshotCreatedTime > 0L && snapshotTtl > 0L && snapshotTtl < TimeUnit.MILLISECONDS.toSeconds(Long.MAX_VALUE) && snapshotCreatedTime + TimeUnit.SECONDS.toMillis(snapshotTtl) < currentTime;
    }

    public static class CompletedSnaphotDirectoriesFilter
    extends FSUtils.BlackListDirFilter {
        public CompletedSnaphotDirectoriesFilter(FileSystem fs) {
            super(fs, Collections.singletonList(SnapshotDescriptionUtils.SNAPSHOT_TMP_DIR_NAME));
        }
    }
}

