/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class DisabledRSGroupInfoManager
implements RSGroupInfoManager {
    private final ServerManager serverManager;

    public DisabledRSGroupInfoManager(ServerManager serverManager) {
        this.serverManager = serverManager;
    }

    @Override
    public void start() {
    }

    @Override
    public void addRSGroup(RSGroupInfo rsGroupInfo) throws IOException {
        throw new DoNotRetryIOException("RSGroup is disabled");
    }

    @Override
    public void removeRSGroup(String groupName) throws IOException {
        throw new DoNotRetryIOException("RSGroup is disabled");
    }

    @Override
    public void moveServers(Set<Address> servers, String targetGroupName) throws IOException {
        throw new DoNotRetryIOException("RSGroup is disabled");
    }

    private SortedSet<Address> getOnlineServers() {
        TreeSet<Address> onlineServers = new TreeSet<Address>();
        this.serverManager.getOnlineServers().keySet().stream().map(ServerName::getAddress).forEach(onlineServers::add);
        return onlineServers;
    }

    @Override
    public RSGroupInfo getRSGroupOfServer(Address serverHostPort) throws IOException {
        SortedSet<Address> onlineServers = this.getOnlineServers();
        if (onlineServers.contains(serverHostPort)) {
            return new RSGroupInfo("default", onlineServers);
        }
        return null;
    }

    @Override
    public RSGroupInfo getRSGroup(String groupName) throws IOException {
        if ("default".equals(groupName)) {
            return new RSGroupInfo("default", this.getOnlineServers());
        }
        return null;
    }

    @Override
    public List<RSGroupInfo> listRSGroups() throws IOException {
        return Arrays.asList(new RSGroupInfo("default", this.getOnlineServers()));
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public void removeServers(Set<Address> servers) throws IOException {
    }

    @Override
    public RSGroupInfo getRSGroupForTable(TableName tableName) throws IOException {
        return null;
    }

    @Override
    public BalanceResponse balanceRSGroup(String groupName, BalanceRequest request) throws IOException {
        throw new DoNotRetryIOException("RSGroup is disabled");
    }

    @Override
    public void setRSGroup(Set<TableName> tables, String groupName) throws IOException {
        throw new DoNotRetryIOException("RSGroup is disabled");
    }

    @Override
    public String determineRSGroupInfoForTable(TableName tableName) {
        return "default";
    }

    @Override
    public void renameRSGroup(String oldName, String newName) throws IOException {
    }

    @Override
    public void updateRSGroupConfig(String groupName, Map<String, String> configuration) throws IOException {
        throw new DoNotRetryIOException("RSGroup is disabled");
    }
}

