/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.procedure2.BaseRSProcedureCallable;
import org.apache.hadoop.hbase.protobuf.ReplicationProtobufUtil;
import org.apache.hadoop.hbase.regionserver.wal.WALHeaderEOFException;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RecoverLeaseFSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALStreamReader;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplaySyncReplicationWALCallable
extends BaseRSProcedureCallable {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaySyncReplicationWALCallable.class);
    private static final String REPLAY_SYNC_REPLICATION_WAL_BATCH_SIZE = "hbase.replay.sync.replication.wal.batch.size";
    private static final long DEFAULT_REPLAY_SYNC_REPLICATION_WAL_BATCH_SIZE = 0x800000L;
    private String peerId;
    private List<String> wals = new ArrayList<String>();
    private long batchSize;
    private final KeyLocker<String> peersLock = new KeyLocker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCall() throws Exception {
        LOG.info("Received a replay sync replication wals {} event, peerId={}", this.wals, (Object)this.peerId);
        if (this.rs.getReplicationSinkService() != null) {
            ReentrantLock peerLock = this.peersLock.acquireLock((Object)this.wals.get(0));
            try {
                for (String wal : this.wals) {
                    this.replayWAL(wal);
                }
            }
            finally {
                peerLock.unlock();
            }
        }
    }

    @Override
    protected void initParameter(byte[] parameter) throws InvalidProtocolBufferException {
        MasterProcedureProtos.ReplaySyncReplicationWALParameter param = MasterProcedureProtos.ReplaySyncReplicationWALParameter.parseFrom((byte[])parameter);
        this.peerId = param.getPeerId();
        param.getWalList().forEach(this.wals::add);
        this.batchSize = this.rs.getConfiguration().getLong(REPLAY_SYNC_REPLICATION_WAL_BATCH_SIZE, 0x800000L);
    }

    @Override
    public EventType getEventType() {
        return EventType.RS_REPLAY_SYNC_REPLICATION_WAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayWAL(String wal) throws IOException {
        WALStreamReader reader = this.getReader(wal);
        if (reader == null) {
            return;
        }
        try {
            List<WAL.Entry> entries = this.readWALEntries(reader, wal);
            while (!entries.isEmpty()) {
                Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> pair = ReplicationProtobufUtil.buildReplicateWALEntryRequest(entries.toArray(new WAL.Entry[entries.size()]));
                AdminProtos.ReplicateWALEntryRequest request = (AdminProtos.ReplicateWALEntryRequest)pair.getFirst();
                this.rs.getReplicationSinkService().replicateLogEntries(request.getEntryList(), (CellScanner)pair.getSecond(), request.getReplicationClusterId(), request.getSourceBaseNamespaceDirPath(), request.getSourceHFileArchiveDirPath());
                entries = this.readWALEntries(reader, wal);
            }
        }
        finally {
            reader.close();
        }
    }

    private WALStreamReader getReader(String wal) throws IOException {
        Path path = new Path(this.rs.getWALRootDir(), wal);
        try {
            RecoverLeaseFSUtils.recoverFileLease((FileSystem)this.rs.getWALFileSystem(), (Path)path, (Configuration)this.rs.getConfiguration());
            return WALFactory.createStreamReader(this.rs.getWALFileSystem(), path, this.rs.getConfiguration());
        }
        catch (WALHeaderEOFException e) {
            LOG.warn("EOF while opening WAL reader for {}", (Object)path, (Object)e);
            return null;
        }
    }

    private boolean filter(WAL.Entry entry) {
        WALEdit edit = entry.getEdit();
        WALUtil.filterCells(edit, c -> CellUtil.matchingFamily((Cell)c, (byte[])WALEdit.METAFAMILY) ? null : c);
        return !edit.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<WAL.Entry> readWALEntries(WALStreamReader reader, String wal) throws IOException {
        ArrayList<WAL.Entry> entries = new ArrayList<WAL.Entry>();
        if (reader == null) {
            return entries;
        }
        long size = 0L;
        while (true) {
            WAL.Entry entry;
            try {
                entry = reader.next();
            }
            catch (EOFException e) {
                LOG.info("EOF while reading WAL entries from {}: {}, continuing", (Object)wal, (Object)e.toString());
                return entries;
            }
            if (entry == null) return entries;
            if (!this.filter(entry)) continue;
            entries.add(entry);
            if ((size += entry.getEdit().heapSize()) > this.batchSize) return entries;
        }
    }
}

