/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ReplicationOffsetUtil {
    private ReplicationOffsetUtil() {
    }

    public static boolean shouldReplicate(ReplicationGroupOffset offset, String wal) {
        long startWalTs;
        if (offset == null || offset == ReplicationGroupOffset.BEGIN) {
            return true;
        }
        long walTs = AbstractFSWALProvider.getTimestamp(wal);
        if (walTs < (startWalTs = AbstractFSWALProvider.getTimestamp(offset.getWal()))) {
            return false;
        }
        if (walTs > startWalTs) {
            return true;
        }
        return offset.getOffset() >= 0L;
    }
}

