/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.AsyncRegionServerAdmin;
import org.apache.hadoop.hbase.client.ClusterConnectionFactory;
import org.apache.hadoop.hbase.replication.BaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class HBaseReplicationEndpoint
extends BaseReplicationEndpoint
implements Abortable {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseReplicationEndpoint.class);
    private ZKWatcher zkw = null;
    private final Object zkwLock = new Object();
    protected Configuration conf;
    private AsyncClusterConnection conn;
    public static final int DEFAULT_BAD_SINK_THRESHOLD = 3;
    public static final float DEFAULT_REPLICATION_SOURCE_RATIO = 0.5f;
    private float ratio;
    private int badSinkThreshold;
    private Map<ServerName, Integer> badReportCounts;
    private List<ServerName> sinkServers = new ArrayList<ServerName>(0);

    protected AsyncClusterConnection createConnection(Configuration conf) throws IOException {
        return ClusterConnectionFactory.createAsyncClusterConnection(conf, null, User.getCurrent());
    }

    @Override
    public void init(ReplicationEndpoint.Context context) throws IOException {
        super.init(context);
        this.conf = HBaseConfiguration.create((Configuration)this.ctx.getConfiguration());
        this.ratio = this.ctx.getConfiguration().getFloat("replication.source.ratio", 0.5f);
        this.badSinkThreshold = this.ctx.getConfiguration().getInt("replication.bad.sink.threshold", 3);
        this.badReportCounts = Maps.newHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        Object object = this.zkwLock;
        synchronized (object) {
            if (this.zkw != null) {
                this.zkw.close();
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (IOException e) {
                LOG.warn("{} Failed to close the connection", (Object)this.ctx.getPeerId());
            }
        }
    }

    private void reconnect(KeeperException ke) {
        if (ke instanceof KeeperException.ConnectionLossException || ke instanceof KeeperException.SessionExpiredException || ke instanceof KeeperException.AuthFailedException) {
            String clusterKey = this.ctx.getPeerConfig().getClusterKey();
            LOG.warn("Lost the ZooKeeper connection for peer {}", (Object)clusterKey, (Object)ke);
            try {
                this.reloadZkWatcher();
            }
            catch (IOException io) {
                LOG.warn("Creation of ZookeeperWatcher failed for peer {}", (Object)clusterKey, (Object)io);
            }
        }
    }

    @Override
    public void start() {
        this.startAsync();
    }

    @Override
    public void stop() {
        this.stopAsync();
    }

    protected void doStart() {
        try {
            this.reloadZkWatcher();
            this.connectPeerCluster();
            this.notifyStarted();
        }
        catch (IOException e) {
            this.notifyFailed(e);
        }
    }

    protected void doStop() {
        this.disconnect();
        this.notifyStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID getPeerUUID() {
        UUID peerUUID = null;
        try {
            Object object = this.zkwLock;
            synchronized (object) {
                peerUUID = ZKClusterId.getUUIDForCluster((ZKWatcher)this.zkw);
            }
        }
        catch (KeeperException ke) {
            this.reconnect(ke);
        }
        return peerUUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadZkWatcher() throws IOException {
        Object object = this.zkwLock;
        synchronized (object) {
            if (this.zkw != null) {
                this.zkw.close();
            }
            this.zkw = new ZKWatcher(this.ctx.getConfiguration(), "connection to cluster: " + this.ctx.getPeerId(), (Abortable)this);
            this.zkw.registerListener((ZKListener)new PeerRegionServerListener(this));
        }
    }

    private void connectPeerCluster() throws IOException {
        try {
            this.conn = this.createConnection(this.conf);
        }
        catch (IOException ioe) {
            LOG.warn("{} Failed to create connection for peer cluster", (Object)this.ctx.getPeerId(), (Object)ioe);
            throw ioe;
        }
    }

    public void abort(String why, Throwable e) {
        LOG.error("The HBaseReplicationEndpoint corresponding to peer " + this.ctx.getPeerId() + " was aborted for the following reason(s):" + why, e);
    }

    public boolean isAborted() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ServerName> fetchSlavesAddresses() {
        List children = null;
        try {
            Object object = this.zkwLock;
            synchronized (object) {
                children = ZKUtil.listChildrenAndWatchForNewChildren((ZKWatcher)this.zkw, (String)this.zkw.getZNodePaths().rsZNode);
            }
        }
        catch (KeeperException ke) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetch slaves addresses failed", (Throwable)ke);
            }
            this.reconnect(ke);
        }
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList<ServerName> addresses = new ArrayList<ServerName>(children.size());
        for (String child : children) {
            addresses.add(ServerName.parseServerName((String)child));
        }
        return addresses;
    }

    protected synchronized void chooseSinks() {
        List<ServerName> slaveAddresses = this.fetchSlavesAddresses();
        if (slaveAddresses.isEmpty()) {
            LOG.warn("No sinks available at peer. Will not be able to replicate");
        }
        Collections.shuffle(slaveAddresses, ThreadLocalRandom.current());
        int numSinks = (int)Math.ceil((float)slaveAddresses.size() * this.ratio);
        this.sinkServers = slaveAddresses.subList(0, numSinks);
        this.badReportCounts.clear();
    }

    protected synchronized int getNumSinks() {
        return this.sinkServers.size();
    }

    protected synchronized SinkPeer getReplicationSink() throws IOException {
        if (this.sinkServers.isEmpty()) {
            LOG.info("Current list of sinks is out of date or empty, updating");
            this.chooseSinks();
        }
        if (this.sinkServers.isEmpty()) {
            throw new IOException("No replication sinks are available");
        }
        ServerName serverName = this.sinkServers.get(ThreadLocalRandom.current().nextInt(this.sinkServers.size()));
        return new SinkPeer(serverName, this.conn.getRegionServerAdmin(serverName));
    }

    protected synchronized void reportBadSink(SinkPeer sinkPeer) {
        ServerName serverName = sinkPeer.getServerName();
        int badReportCount = this.badReportCounts.compute(serverName, (k, v) -> v == null ? 1 : v + 1);
        if (badReportCount > this.badSinkThreshold) {
            this.sinkServers.remove(serverName);
            if (this.sinkServers.isEmpty()) {
                this.chooseSinks();
            }
        }
    }

    protected synchronized void reportSinkSuccess(SinkPeer sinkPeer) {
        this.badReportCounts.remove(sinkPeer.getServerName());
    }

    List<ServerName> getSinkServers() {
        return this.sinkServers;
    }

    public static class SinkPeer {
        private ServerName serverName;
        private AsyncRegionServerAdmin regionServer;

        public SinkPeer(ServerName serverName, AsyncRegionServerAdmin regionServer) {
            this.serverName = serverName;
            this.regionServer = regionServer;
        }

        ServerName getServerName() {
            return this.serverName;
        }

        public AsyncRegionServerAdmin getRegionServer() {
            return this.regionServer;
        }
    }

    public static class PeerRegionServerListener
    extends ZKListener {
        private final HBaseReplicationEndpoint replicationEndpoint;
        private final String regionServerListNode;

        public PeerRegionServerListener(HBaseReplicationEndpoint endpoint) {
            super(endpoint.zkw);
            this.replicationEndpoint = endpoint;
            this.regionServerListNode = ((HBaseReplicationEndpoint)endpoint).zkw.getZNodePaths().rsZNode;
        }

        public synchronized void nodeChildrenChanged(String path) {
            if (path.equals(this.regionServerListNode)) {
                LOG.info("Detected change to peer region servers, fetching updated list");
                this.replicationEndpoint.chooseSinks();
            }
        }
    }
}

